/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJrtWithReleaseOption
extends ClasspathJrt {
    private static final String MODULE_INFO = "module-info.sig";
    final String release;
    private final String releaseCode;
    private FileSystem fs;
    private final Path releasePath;
    private final String modPathString;
    private CtSym ctSym;

    public ClasspathJrtWithReleaseOption(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, String release) throws CoreException {
        super(zipFilename);
        if (release == null || release.equals("")) {
            throw new IllegalArgumentException("--release argument can not be null");
        }
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.release = this.getReleaseOptionFromCompliance(release);
        try {
            this.ctSym = JRTUtil.getCtSym((Path)Path.of(this.zipFilename, new String[0]).getParent().getParent());
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Failed to init ct.sym for " + this.zipFilename), (Throwable)e));
        }
        this.releaseCode = CtSym.getReleaseCode((String)this.release);
        this.fs = this.ctSym.getFs();
        this.releasePath = this.ctSym.getRoot();
        Path modPath = this.fs.getPath(this.releaseCode + (this.ctSym.isJRE12Plus() ? "" : "-modules"), new String[0]);
        String string = this.modPathString = !Files.exists(modPath, new LinkOption[0]) ? null : this.zipFilename + "|" + modPath.toString();
        if (!Files.exists(this.releasePath.resolve(this.releaseCode), new LinkOption[0])) {
            IllegalArgumentException e = new IllegalArgumentException("release " + this.release + " is not found in the system");
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
        if (Files.exists(this.fs.getPath(this.releaseCode, "system-modules"), new LinkOption[0])) {
            this.fs = null;
        }
        this.loadModules();
    }

    private String getReleaseOptionFromCompliance(String comp) throws CoreException {
        if (JavaCore.compareJavaVersions(comp, "1.5") <= 0) {
            return "6";
        }
        int index = comp.indexOf("1.");
        if (index != -1) {
            return comp.substring(index + 2, comp.length());
        }
        if (comp.indexOf(46) == -1) {
            return comp;
        }
        throw new CoreException(Status.error((String)("Invalid value for --release argument:" + comp)));
    }

    public void loadModules() {
        if (this.fs == null || !this.ctSym.isJRE12Plus()) {
            ClasspathJrt.loadModules(this);
            return;
        }
        if (this.modPathString == null) {
            return;
        }
        modulesCache.computeIfAbsent(this.modPathString, key -> {
            List releaseRoots = this.ctSym.releaseRoots(this.releaseCode);
            final HashMap newCache = new HashMap();
            for (Path root : releaseRoots) {
                try {
                    Files.walkFileTree(root, Collections.emptySet(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isDirectory() || f.getNameCount() < 3) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (f.getFileName().toString().equals(ClasspathJrtWithReleaseOption.MODULE_INFO)) {
                                byte[] content = ClasspathJrtWithReleaseOption.this.ctSym.getFileBytes(f);
                                if (content == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                ClasspathJrtWithReleaseOption.this.acceptModule(content, f.getParent().getFileName().toString(), newCache);
                            }
                            return FileVisitResult.SKIP_SIBLINGS;
                        }
                    });
                }
                catch (IOException e) {
                    Util.log(e, "Failed to init modules cache for " + key);
                }
            }
            return newCache.isEmpty() ? null : Map.copyOf(newCache);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (this.fs == null) {
            return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
        }
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        List releaseRoots = this.ctSym.releaseRoots(this.releaseCode);
        try {
            String fileNameWithoutExtension;
            ClassFileReader reader;
            block11: {
                block10: {
                    reader = null;
                    byte[] content = null;
                    fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    if (releaseRoots.isEmpty()) break block10;
                    Path fullPath = this.ctSym.getFullPath(this.releaseCode, qualifiedBinaryFileName = qualifiedBinaryFileName.replace(".class", ".sig"), moduleName);
                    if (fullPath != null && (content = this.ctSym.getFileBytes(fullPath)) != null) {
                        reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                        if (moduleName != null) {
                            reader.moduleName = moduleName.toCharArray();
                            break block11;
                        } else if (this.ctSym.isJRE12Plus() && (moduleName = this.ctSym.getModuleInJre12plus(this.releaseCode, qualifiedBinaryFileName)) != null) {
                            reader.moduleName = moduleName.toCharArray();
                        }
                    }
                    break block11;
                }
                if (this.jrtFileSystem == null) {
                    return null;
                }
                reader = JRTUtil.getClassfile((JrtFileSystem)this.jrtFileSystem, (String)qualifiedBinaryFileName, (String)moduleName, moduleNameFilter);
            }
            if (reader == null) {
                return null;
            }
            return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, reader.getModule());
        }
        catch (IOException | ClassFormatException throwable) {
            return null;
        }
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        Set<String> cache = ClasspathJrt.getModuleNames(this);
        if (cache != null) {
            return this.selectModules(cache, limitModules);
        }
        return Collections.emptyList();
    }

    @Override
    public void cleanup() {
        try {
            super.cleanup();
        }
        finally {
            this.fs = null;
            this.ctSym = null;
        }
    }

    @Override
    public boolean hasModule() {
        return this.fs == null ? super.hasModule() : this.modPathString != null;
    }

    @Override
    protected String getKey() {
        return this.fs == null ? super.getKey() : this.modPathString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrtWithReleaseOption)) {
            return false;
        }
        ClasspathJrtWithReleaseOption jar = (ClasspathJrtWithReleaseOption)o;
        if (!Util.equalOrNull(this.release, jar.release)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
        return Util.combineHashCodes(hash, this.release.hashCode());
    }

    @Override
    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename + " with --release option " + this.release;
        return start;
    }
}

