/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.ResourceCompilationUnit;

public class ClasspathSourceDirectory
extends ClasspathLocation
implements IModulePathEntry {
    final IContainer sourceFolder;
    final Map<String, SimpleLookupTable> directoryCache = new ConcurrentHashMap<String, SimpleLookupTable>();
    final SimpleLookupTable missingPackageHolder = new SimpleLookupTable();
    final char[][] fullExclusionPatternChars;
    final char[][] fulInclusionPatternChars;

    ClasspathSourceDirectory(IContainer sourceFolder, char[][] fullExclusionPatternChars, char[][] fulInclusionPatternChars) {
        this.sourceFolder = sourceFolder;
        this.fullExclusionPatternChars = fullExclusionPatternChars;
        this.fulInclusionPatternChars = fulInclusionPatternChars;
    }

    @Override
    public void cleanup() {
        this.directoryCache.clear();
    }

    SimpleLookupTable directoryTable(String qualifiedPackageName) {
        SimpleLookupTable dirTable = this.directoryCache.get(qualifiedPackageName);
        if (dirTable == this.missingPackageHolder) {
            return null;
        }
        if (dirTable != null) {
            return dirTable;
        }
        try {
            IResource container = this.sourceFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                Map<String, IType> typesInPackage;
                IResource[] members = ((IContainer)container).members();
                dirTable = new SimpleLookupTable();
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    String fullPath;
                    String name;
                    int index;
                    IResource m = iResourceArray[n2];
                    if (m.getType() == 1 && (index = org.eclipse.jdt.internal.core.util.Util.indexOfJavaLikeExtension(name = m.getName())) >= 0 && !Util.isExcluded((char[])(fullPath = m.getFullPath().toString()).toCharArray(), (char[][])this.fulInclusionPatternChars, (char[][])this.fullExclusionPatternChars, (boolean)false)) {
                        dirTable.put((Object)name.substring(0, index), (Object)m);
                    }
                    ++n2;
                }
                IJavaProject project = JavaCore.create(container.getProject());
                Map<String, Map<String, IType>> secondaryTypePaths = JavaModelManager.getJavaModelManager().secondaryTypes(project, false, null);
                if (secondaryTypePaths.size() > 0 && (typesInPackage = secondaryTypePaths.get(qualifiedPackageName.replace('/', '.'))) != null && typesInPackage.size() > 0) {
                    for (String secondaryTypeName : typesInPackage.keySet()) {
                        IType secondaryType = typesInPackage.get(secondaryTypeName);
                        IJavaElement parent = secondaryType.getParent();
                        String fullPath = parent.getResource().getFullPath().toString();
                        if (Util.isExcluded((char[])fullPath.toCharArray(), (char[][])this.fulInclusionPatternChars, (char[][])this.fullExclusionPatternChars, (boolean)false)) continue;
                        dirTable.put((Object)secondaryTypeName, (Object)parent.getResource());
                    }
                }
                this.directoryCache.put(qualifiedPackageName, dirTable);
                return dirTable;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathSourceDirectory)) {
            return false;
        }
        return this.sourceFolder.equals((Object)((ClasspathSourceDirectory)o).sourceFolder);
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName);
    }

    @Override
    public NameEnvironmentAnswer findClass(String sourceFileWithoutExtension, String qualifiedPackageName, String moduleName, String qualifiedSourceFileWithoutExtension) {
        IFile file;
        SimpleLookupTable dirTable = this.directoryTable(qualifiedPackageName);
        if (dirTable != null && dirTable.elementSize > 0 && (file = (IFile)dirTable.get((Object)sourceFileWithoutExtension)) != null) {
            return new NameEnvironmentAnswer((ICompilationUnit)new ResourceCompilationUnit(file, this.module == null ? null : this.module.name()), null);
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.sourceFolder.getProjectRelativePath();
    }

    public int hashCode() {
        return this.sourceFolder == null ? super.hashCode() : this.sourceFolder.hashCode();
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return false;
        }
        return this.directoryTable(qualifiedPackageName) != null;
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        SimpleLookupTable dirTable = this.directoryTable(qualifiedPackageName);
        return dirTable != null && dirTable.elementSize > 0;
    }

    @Override
    public void reset() {
        this.directoryCache.clear();
    }

    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString();
    }

    @Override
    public String debugPathString() {
        return this.sourceFolder.getFullPath().toString();
    }
}

