/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.LoaderAwareClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class MarkAsStepOverAdapter
extends AbstractTransformableClassNode {
    private Method[] methods;

    public MarkAsStepOverAdapter(Method[] methods) {
        this.methods = methods;
    }

    @Override
    protected boolean transform() {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            MethodNode orgMethod = this.getMethod(method);
            for (AbstractInsnNode insnNode : orgMethod.instructions) {
                if (!(insnNode instanceof LineNumberNode)) continue;
                ((LineNumberNode)insnNode).line = 65534;
            }
            ++n2;
        }
        return true;
    }

    public static byte[] transformTeamManager(byte[] classfileBuffer, ClassLoader loader) {
        if (!IS_DEBUG) {
            return classfileBuffer;
        }
        Method[] methodsToMark = new Method[]{new Method("getMemberId", "(ILjava/lang/Class;)I")};
        MarkAsStepOverAdapter adapter = new MarkAsStepOverAdapter(methodsToMark);
        ClassReader reader = new ClassReader(classfileBuffer);
        reader.accept((ClassVisitor)adapter, 4);
        if (adapter.transform()) {
            LoaderAwareClassWriter writer = new LoaderAwareClassWriter(reader, 2, loader);
            adapter.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return classfileBuffer;
    }
}

