/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;

public class FakedTrackingVariable
extends LocalDeclaration {
    private static final char[] UNASSIGNED_CLOSEABLE_NAME = "<unassigned Closeable value>".toCharArray();
    private static final char[] UNASSIGNED_CLOSEABLE_NAME_TEMPLATE = "<unassigned Closeable value from line {0}>".toCharArray();
    private static final char[] TEMPLATE_ARGUMENT = "{0}".toCharArray();
    private static final int CLOSE_SEEN = 1;
    private static final int SHARED_WITH_OUTSIDE = 2;
    private static final int OWNED_BY_OUTSIDE = 4;
    private static final int CLOSED_IN_NESTED_METHOD = 8;
    private static final int REPORTED_EXPLICIT_CLOSE = 16;
    private static final int REPORTED_POTENTIAL_LEAK = 32;
    private static final int REPORTED_DEFINITIVE_LEAK = 64;
    private static final int FOREACH_ELEMENT_VAR = 128;
    private static final int TWR_EFFECTIVELY_FINAL = 256;
    public MessageSend acquisition;
    public static boolean TEST_372319 = false;
    private int globalClosingState = 0;
    private boolean useAnnotations = false;
    public static final int NOT_OWNED = -2;
    public static final int NOT_OWNED_PER_DEFAULT = -1;
    public static final int OWNED_PER_DEFAULT = 1;
    public static final int OWNED = 2;
    public int owningState = 0;
    public LocalVariableBinding originalBinding;
    public FieldBinding originalFieldBinding;
    public FakedTrackingVariable innerTracker;
    public FakedTrackingVariable outerTracker;
    MethodScope methodScope;
    private HashMap<ASTNode, Integer> recordedLocations;
    private ASTNode currentAssignment;
    private FlowContext tryContext;
    private BlockScope blockScope;
    private Set<FlowContext> modificationContexts;

    static int owningStateFromTagBits(long owningTagBits, int defaultState) {
        if (owningTagBits == 0x200000000000000L) {
            return 2;
        }
        if (owningTagBits == 0x400000000000000L) {
            return -2;
        }
        return defaultState;
    }

    public FakedTrackingVariable(LocalVariableBinding original, ASTNode location, FlowInfo flowInfo, FlowContext flowContext, int nullStatus, boolean useAnnotations) {
        this(original.name, location, original.declaringScope, flowInfo, flowContext, nullStatus, useAnnotations);
        this.methodScope = original.declaringScope.methodScope();
        this.originalBinding = original;
    }

    public FakedTrackingVariable(LocalVariableBinding original, BlockScope scope, ASTNode location, FlowInfo flowInfo, FlowContext flowContext, int nullStatus, boolean useAnnotations) {
        this(original.name, location, original.declaringScope, flowInfo, flowContext, nullStatus, useAnnotations);
        this.methodScope = original.declaringScope.methodScope();
        this.originalBinding = original;
        this.blockScope = scope;
    }

    public FakedTrackingVariable(FieldBinding original, BlockScope scope, ASTNode location, FlowInfo flowInfo, FlowContext flowContext, int nullStatus, boolean useAnnotations) {
        this(original.name, location, scope, flowInfo, flowContext, nullStatus, useAnnotations);
        this.originalFieldBinding = original;
        this.blockScope = scope;
    }

    private FakedTrackingVariable(char[] name, ASTNode location, BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, int nullStatus, boolean useAnnotations) {
        super(name, location.sourceStart, location.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.useAnnotations = useAnnotations;
        while (flowContext != null) {
            if (flowContext instanceof FinallyFlowContext) {
                this.tryContext = ((FinallyFlowContext)flowContext).tryContext;
                break;
            }
            flowContext = flowContext.parent;
        }
        this.resolve(scope);
        if (nullStatus != 0) {
            flowInfo.markNullStatus(this.binding, nullStatus);
        }
    }

    private FakedTrackingVariable(BlockScope scope, ASTNode location, FlowInfo flowInfo, int nullStatus) {
        super(UNASSIGNED_CLOSEABLE_NAME, location.sourceStart, location.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = scope.methodScope();
        this.originalBinding = null;
        this.useAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
        this.resolve(scope);
        if (nullStatus != 0) {
            flowInfo.markNullStatus(this.binding, nullStatus);
        }
    }

    private void attachTo(LocalVariableBinding local) {
        local.closeTracker = this;
        this.originalBinding = local;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    @Override
    public void resolve(BlockScope scope) {
        this.binding = new LocalVariableBinding(this.name, (TypeBinding)scope.getJavaLangObject(), 0, false);
        this.binding.closeTracker = this;
        this.binding.declaringScope = scope;
        this.binding.setConstant(Constant.NotAConstant);
        this.binding.useFlag = 1;
        this.binding.id = scope.registerTrackingVariable(this);
    }

    /*
     * Unable to fully structure code
     */
    private static FakedTrackingVariable getRiskyCloseTrackerAt(LocalVariableBinding local, Scope scope, FlowInfo flowInfo) {
        if (local.closeTracker == null) {
            return null;
        }
        if (flowInfo.nullStatus(local.closeTracker.binding) == 1) ** GOTO lbl12
        return local.closeTracker;
lbl-1000:
        // 1 sources

        {
            tracker = ((BlockScope)scope).getCloseTrackerFor(local);
            if (tracker != null) {
                if (tracker.riskyNullStatusAt(flowInfo) != 0) {
                    return tracker;
                }
                if (tracker.hasDefinitelyNoResource(flowInfo)) {
                    return null;
                }
            }
            scope = scope.parent;
lbl12:
            // 2 sources

            ** while (scope instanceof BlockScope)
        }
lbl13:
        // 1 sources

        return null;
    }

    public static FakedTrackingVariable getCloseTrackingVariable(Expression expression, FlowInfo flowInfo, FlowContext flowContext, boolean useAnnotations) {
        if (flowInfo.reachMode() != 0) {
            return null;
        }
        while (true) {
            if (expression instanceof CastExpression) {
                expression = ((CastExpression)expression).expression;
                continue;
            }
            if (!(expression instanceof Assignment)) break;
            expression = ((Assignment)expression).expression;
        }
        if (expression instanceof ConditionalExpression) {
            return FakedTrackingVariable.getMoreUnsafeFromBranches((ConditionalExpression)expression, flowInfo, branch -> FakedTrackingVariable.getCloseTrackingVariable(branch, flowInfo, flowContext, useAnnotations));
        }
        if (expression instanceof SwitchExpression) {
            SwitchExpression se = (SwitchExpression)expression;
            for (Expression re : se.resultExpressions()) {
                FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(re, flowInfo, flowContext, useAnnotations);
                if (fakedTrackingVariable == null) continue;
                return fakedTrackingVariable;
            }
            return null;
        }
        FieldBinding fieldBinding = null;
        if (expression instanceof SingleNameReference) {
            SingleNameReference name = (SingleNameReference)expression;
            if (name.binding instanceof LocalVariableBinding) {
                LocalVariableBinding local = (LocalVariableBinding)name.binding;
                if (local.closeTracker != null) {
                    return local.closeTracker;
                }
                if (!FakedTrackingVariable.isCloseableNotWhiteListed(expression.resolvedType)) {
                    return null;
                }
                if ((local.tagBits & 0x2000L) != 0L) {
                    return null;
                }
                LocalDeclaration location = local.declaration;
                local.closeTracker = new FakedTrackingVariable(local, location, flowInfo, flowContext, 1, useAnnotations);
                if (local.isParameter()) {
                    local.closeTracker.globalClosingState |= 4;
                }
                return local.closeTracker;
            }
            if (name.binding instanceof FieldBinding) {
                fieldBinding = (FieldBinding)name.binding;
            }
        } else if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis()) {
                fieldBinding = fieldReference.binding;
            }
        } else {
            if (expression instanceof AllocationExpression) {
                return ((AllocationExpression)expression).closeTracker;
            }
            if (expression instanceof MessageSend) {
                return ((MessageSend)expression).closeTracker;
            }
        }
        if (fieldBinding != null) {
            return fieldBinding.closeTracker;
        }
        return null;
    }

    public static FakedTrackingVariable preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, Expression rhs, FlowInfo flowInfo, boolean useAnnotations) {
        FakedTrackingVariable closeTracker = null;
        if (FakedTrackingVariable.containsAllocation(rhs)) {
            closeTracker = local.closeTracker;
            if (closeTracker == null && rhs.resolvedType != TypeBinding.NULL) {
                closeTracker = new FakedTrackingVariable(local, location, flowInfo, null, 1, useAnnotations);
                if (local.isParameter()) {
                    closeTracker.globalClosingState |= 4;
                }
            }
            if (closeTracker != null) {
                closeTracker.currentAssignment = location;
                FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, closeTracker, rhs, useAnnotations);
            }
        } else if (rhs instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)rhs;
            closeTracker = local.closeTracker;
            if (closeTracker != null) {
                closeTracker = FakedTrackingVariable.handleReassignment(flowInfo, closeTracker, location);
            }
            if (rhs.resolvedType != TypeBinding.NULL && (!rhs.resolvedType.hasTypeBit(8) || FakedTrackingVariable.isBlacklistedMethod(rhs))) {
                if (closeTracker == null) {
                    closeTracker = new FakedTrackingVariable(local, location, flowInfo, null, 1, useAnnotations);
                }
                messageSend.closeTracker = closeTracker;
                closeTracker.currentAssignment = location;
            }
            if (closeTracker != null && messageSend.binding != null && (messageSend.binding.tagBits & 0x400000000000000L) == 0L) {
                closeTracker.owningState = 2;
            }
        } else if (rhs instanceof CastExpression) {
            CastExpression cast = (CastExpression)rhs;
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, cast.expression, flowInfo, useAnnotations);
        }
        return closeTracker;
    }

    static void checkMethodForMissingAnnotation(MessageSend messageSend, Scope scope) {
        if ((messageSend.binding.original().extendedTagBits & 2) != 0) {
            scope.problemReporter().messageWithUnresolvedOwningAnnotation(messageSend, scope.environment());
        }
    }

    static void checkParameterForMissingAnnotation(ASTNode location, MethodBinding method, int rank, Scope scope) {
        if (method != null && method.parameterHasMissingOwningAnnotation(rank)) {
            scope.problemReporter().parameterWithUnresolvedOwningAnnotation(location, method.original(), rank, scope.environment());
        }
    }

    static void checkFieldForMissingAnnotation(ASTNode location, FieldBinding fieldBinding, Scope scope) {
        if (fieldBinding != null && (fieldBinding.extendedTagBits & 2L) != 0L) {
            scope.problemReporter().fieldWithUnresolvedOwningAnnotation(location, fieldBinding, scope.environment());
        }
    }

    private static boolean containsAllocation(SwitchExpression location) {
        for (Expression re : location.resultExpressions()) {
            if (!FakedTrackingVariable.containsAllocation(re)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAllocation(ASTNode location) {
        if (location instanceof AllocationExpression) {
            return true;
        }
        if (location instanceof ConditionalExpression) {
            ConditionalExpression conditional = (ConditionalExpression)location;
            return FakedTrackingVariable.containsAllocation(conditional.valueIfTrue) || FakedTrackingVariable.containsAllocation(conditional.valueIfFalse);
        }
        if (location instanceof SwitchExpression) {
            return FakedTrackingVariable.containsAllocation((SwitchExpression)location);
        }
        if (location instanceof CastExpression) {
            return FakedTrackingVariable.containsAllocation(((CastExpression)location).expression);
        }
        if (location instanceof MessageSend && FakedTrackingVariable.isFluentMethod(((MessageSend)location).binding)) {
            return FakedTrackingVariable.containsAllocation(((MessageSend)location).receiver);
        }
        return false;
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, FlowInfo flowInfo, FakedTrackingVariable closeTracker, Expression expression, boolean useAnnotations) {
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, (AllocationExpression)expression, closeTracker, useAnnotations);
        } else if (expression instanceof ConditionalExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, (ConditionalExpression)expression, closeTracker, useAnnotations);
        } else if (expression instanceof SwitchExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, (SwitchExpression)expression, closeTracker, useAnnotations);
        } else if (expression instanceof CastExpression) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, ((CastExpression)expression).expression, flowInfo, useAnnotations);
        } else if (expression instanceof MessageSend && FakedTrackingVariable.isFluentMethod(((MessageSend)expression).binding)) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, ((MessageSend)expression).receiver, flowInfo, useAnnotations);
        }
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, FlowInfo flowInfo, ConditionalExpression conditional, FakedTrackingVariable closeTracker, boolean useAnnotations) {
        FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, closeTracker, conditional.valueIfFalse, useAnnotations);
        FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, closeTracker, conditional.valueIfTrue, useAnnotations);
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, FlowInfo flowInfo, SwitchExpression se, FakedTrackingVariable closeTracker, boolean useAnnotations) {
        for (Expression re : se.resultExpressions()) {
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, flowInfo, closeTracker, re, useAnnotations);
        }
    }

    private static void preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, FlowInfo flowInfo, AllocationExpression allocationExpression, FakedTrackingVariable closeTracker, boolean useAnnotations) {
        allocationExpression.closeTracker = closeTracker;
        if (allocationExpression.arguments != null && allocationExpression.arguments.length > 0) {
            FakedTrackingVariable inner;
            Expression firstArg = allocationExpression.arguments[0];
            if (FakedTrackingVariable.isCloseableNotWhiteListed(firstArg.resolvedType) && (inner = FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, firstArg, flowInfo, useAnnotations)) != closeTracker && closeTracker.innerTracker == null) {
                closeTracker.innerTracker = inner;
            }
        }
    }

    public static void analyseCloseableAllocation(BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, AllocationExpression allocation) {
        if (flowInfo.reachMode() != 0) {
            return;
        }
        if (allocation.resolvedType.hasTypeBit(8)) {
            if (allocation.closeTracker != null) {
                allocation.closeTracker.withdraw();
                allocation.closeTracker = null;
            }
        } else if (allocation.resolvedType.hasTypeBit(4)) {
            boolean isWrapper = true;
            if (allocation.arguments != null && allocation.arguments.length > 0) {
                FakedTrackingVariable innerTracker = FakedTrackingVariable.findCloseTracker(scope, flowInfo, allocation.arguments[0]);
                if (innerTracker != null) {
                    int finallyStatus;
                    FakedTrackingVariable currentInner = innerTracker;
                    do {
                        if (currentInner != allocation.closeTracker) continue;
                        return;
                    } while ((currentInner = currentInner.innerTracker) != null);
                    int newStatus = 2;
                    if (allocation.closeTracker == null) {
                        allocation.closeTracker = new FakedTrackingVariable(scope, allocation, flowInfo, 1);
                    } else if (scope.finallyInfo != null && (finallyStatus = scope.finallyInfo.nullStatus(allocation.closeTracker.binding)) != 1) {
                        newStatus = finallyStatus;
                    }
                    if (allocation.closeTracker.innerTracker != null && allocation.closeTracker.innerTracker != innerTracker) {
                        innerTracker = FakedTrackingVariable.pickMoreUnsafe(allocation.closeTracker.innerTracker, innerTracker, flowInfo);
                    }
                    allocation.closeTracker.innerTracker = innerTracker;
                    innerTracker.outerTracker = allocation.closeTracker;
                    flowInfo.markNullStatus(allocation.closeTracker.binding, newStatus);
                    if (newStatus != 2) {
                        FakedTrackingVariable currentTracker = innerTracker;
                        while (currentTracker != null) {
                            flowInfo.markNullStatus(currentTracker.binding, newStatus);
                            currentTracker.globalClosingState |= allocation.closeTracker.globalClosingState;
                            currentTracker = currentTracker.innerTracker;
                        }
                    }
                    return;
                }
                if (!FakedTrackingVariable.isAnyCloseable(allocation.arguments[0].resolvedType)) {
                    isWrapper = false;
                }
            } else {
                isWrapper = false;
            }
            if (isWrapper) {
                if (allocation.closeTracker != null) {
                    allocation.closeTracker.withdraw();
                    allocation.closeTracker = null;
                }
            } else {
                FakedTrackingVariable.handleRegularResource(scope, flowInfo, flowContext, allocation);
            }
        } else {
            FakedTrackingVariable.handleRegularResource(scope, flowInfo, flowContext, allocation);
        }
    }

    public static FlowInfo analyseCloseableAcquisition(BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, MessageSend acquisition) {
        if (acquisition instanceof CopyInheritance.RoleConstructorCall) {
            return flowInfo;
        }
        AbstractMethodDeclaration referenceMethod = scope.methodScope().referenceMethod();
        if (referenceMethod != null && referenceMethod.isGenerated) {
            return flowInfo;
        }
        if (FakedTrackingVariable.isFluentMethod(acquisition.binding)) {
            acquisition.closeTracker = FakedTrackingVariable.findCloseTracker(scope, flowInfo, acquisition.receiver);
            return flowInfo;
        }
        if (acquisition.resolvedType.hasTypeBit(8) && !FakedTrackingVariable.isBlacklistedMethod(acquisition)) {
            if (acquisition.closeTracker != null) {
                acquisition.closeTracker.withdraw();
                acquisition.closeTracker = null;
            }
            return flowInfo;
        }
        FakedTrackingVariable tracker = acquisition.closeTracker;
        if (scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled) {
            int initialNullStatus;
            FakedTrackingVariable.checkMethodForMissingAnnotation(acquisition, scope);
            long owningTagBits = acquisition.binding.tagBits & 0x600000000000000L;
            int n = initialNullStatus = owningTagBits == 0x400000000000000L ? 4 : 2;
            if (tracker == null) {
                acquisition.closeTracker = tracker = new FakedTrackingVariable(scope, acquisition, flowInfo, initialNullStatus);
                tracker.owningState = FakedTrackingVariable.owningStateFromTagBits(owningTagBits, 1);
            } else {
                flowInfo.markNullStatus(tracker.binding, initialNullStatus);
            }
            tracker.acquisition = acquisition;
            return flowInfo;
        }
        if (tracker != null) {
            tracker.withdraw();
            acquisition.closeTracker = null;
            return flowInfo;
        }
        acquisition.closeTracker = tracker = new FakedTrackingVariable(scope, acquisition, flowInfo, 1);
        tracker.acquisition = acquisition;
        tracker.globalClosingState |= 2;
        FlowInfo outsideInfo = flowInfo.copy();
        outsideInfo.markAsDefinitelyNonNull(tracker.binding);
        tracker.markNullStatus(flowInfo, flowContext, 2);
        return FlowInfo.conditional(outsideInfo, flowInfo);
    }

    static boolean isFluentMethod(MethodBinding binding) {
        if (binding.isStatic()) {
            return false;
        }
        ReferenceBinding declaringClass = binding.declaringClass;
        while (declaringClass != null) {
            if (declaringClass.equals(binding.returnType)) {
                char[][][] cArray = TypeConstants.FLUENT_RESOURCE_CLASSES;
                int n = TypeConstants.FLUENT_RESOURCE_CLASSES.length;
                int n2 = 0;
                while (n2 < n) {
                    char[][] compoundName = cArray[n2];
                    if (CharOperation.equals(compoundName, declaringClass.compoundName)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            declaringClass = declaringClass.superclass();
        }
        return false;
    }

    private static FakedTrackingVariable getMoreUnsafeFromBranches(ConditionalExpression conditionalExpression, FlowInfo flowInfo, Function<Expression, FakedTrackingVariable> retriever) {
        FakedTrackingVariable trackerIfTrue = retriever.apply(conditionalExpression.valueIfTrue);
        FakedTrackingVariable trackerIfFalse = retriever.apply(conditionalExpression.valueIfFalse);
        return FakedTrackingVariable.pickMoreUnsafe(trackerIfTrue, trackerIfFalse, flowInfo);
    }

    private static FakedTrackingVariable pickMoreUnsafe(FakedTrackingVariable tracker1, FakedTrackingVariable tracker2, FlowInfo info) {
        if (tracker1 == null) {
            return tracker2;
        }
        if (tracker2 == null) {
            return tracker1;
        }
        int status1 = info.nullStatus(tracker1.binding);
        int status2 = info.nullStatus(tracker2.binding);
        if (status1 == 2 || status2 == 4) {
            return FakedTrackingVariable.pick(tracker1, tracker2);
        }
        if (status1 == 4 || status2 == 2) {
            return FakedTrackingVariable.pick(tracker2, tracker1);
        }
        if ((status1 & 0x10) != 0) {
            return FakedTrackingVariable.pick(tracker1, tracker2);
        }
        if ((status2 & 0x10) != 0) {
            return FakedTrackingVariable.pick(tracker2, tracker1);
        }
        return FakedTrackingVariable.pick(tracker1, tracker2);
    }

    private static FakedTrackingVariable pick(FakedTrackingVariable tracker1, FakedTrackingVariable tracker2) {
        tracker2.withdraw();
        return tracker1;
    }

    private static void handleRegularResource(BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, AllocationExpression allocation) {
        FakedTrackingVariable presetTracker = allocation.closeTracker;
        LocalVariableBinding local = null;
        if (presetTracker != null && presetTracker.originalBinding != null) {
            if (!presetTracker.isInFinallyBlockOf(flowContext) || !presetTracker.recordFirstModification(flowContext)) {
                local = presetTracker.originalBinding;
                FakedTrackingVariable.handleReassignment(flowInfo, presetTracker, presetTracker.currentAssignment);
                if (local != null && !presetTracker.hasDefinitelyNoResource(flowInfo) && presetTracker.currentAssignment instanceof Assignment) {
                    boolean useAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
                    allocation.closeTracker = local.closeTracker = new FakedTrackingVariable(local, scope, presetTracker.currentAssignment, flowInfo, flowContext, 2, useAnnotations);
                    if (useAnnotations) {
                        allocation.closeTracker.owningState = 2;
                    }
                    FlowInfo enclosingFinallyInfo = null;
                    Scope current = scope;
                    while (current instanceof BlockScope && enclosingFinallyInfo == null) {
                        enclosingFinallyInfo = current.finallyInfo;
                        current = current.parent;
                    }
                    if (enclosingFinallyInfo != null) {
                        int finallyNullStatus = enclosingFinallyInfo.nullStatus(presetTracker.binding);
                        enclosingFinallyInfo.markNullStatus(local.closeTracker.binding, finallyNullStatus);
                    }
                    presetTracker.markNullStatus(flowInfo, flowContext, 1);
                }
            }
        } else {
            allocation.closeTracker = new FakedTrackingVariable(scope, allocation, flowInfo, 1);
        }
        allocation.closeTracker.markNullStatus(flowInfo, flowContext, 2);
    }

    private boolean isInFinallyBlockOf(FlowContext flowContext) {
        if (this.tryContext != null) {
            do {
                if (flowContext != this.tryContext) continue;
                return true;
            } while ((flowContext = flowContext.parent) != null);
        }
        return false;
    }

    private boolean recordFirstModification(FlowContext flowContext) {
        if (this.modificationContexts == null) {
            this.modificationContexts = new HashSet<FlowContext>();
            this.modificationContexts.add(flowContext);
            return true;
        }
        FlowContext current = flowContext;
        while (current != null) {
            if (this.modificationContexts.contains(current)) {
                return false;
            }
            current = current.parent;
        }
        return this.modificationContexts.add(flowContext);
    }

    private static FakedTrackingVariable handleReassignment(FlowInfo flowInfo, FakedTrackingVariable existingTracker, ASTNode location) {
        int riskyStatus = existingTracker.riskyNullStatusAt(flowInfo);
        if (riskyStatus != 0 && !(location instanceof LocalDeclaration)) {
            existingTracker.recordErrorLocation(location, riskyStatus);
            return null;
        }
        return existingTracker;
    }

    private static FakedTrackingVariable findCloseTracker(BlockScope scope, FlowInfo flowInfo, Expression arg) {
        while (arg instanceof Assignment) {
            Assignment assign = (Assignment)arg;
            LocalVariableBinding innerLocal = assign.localVariableBinding();
            if (innerLocal != null) {
                return innerLocal.closeTracker;
            }
            arg = assign.expression;
        }
        if (arg instanceof SingleNameReference) {
            LocalVariableBinding local = arg.localVariableBinding();
            if (local != null) {
                return local.closeTracker;
            }
        } else {
            if (arg instanceof AllocationExpression) {
                return ((AllocationExpression)arg).closeTracker;
            }
            if (arg instanceof MessageSend) {
                return ((MessageSend)arg).closeTracker;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void handleResourceAssignment(BlockScope scope, FlowInfo upstreamInfo, FlowInfo flowInfo, FlowContext flowContext, ASTNode location, Expression rhs, LocalVariableBinding local) {
        block23: {
            block24: {
                block25: {
                    previousTracker = FakedTrackingVariable.getRiskyCloseTrackerAt(local, scope, upstreamInfo);
                    disconnectedTracker = null;
                    if (previousTracker != null) {
                        if (previousTracker.riskyNullStatusAt(upstreamInfo) != 0) {
                            disconnectedTracker = previousTracker;
                        }
                    } else {
                        previousTracker = local.closeTracker;
                    }
                    useAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
                    if (rhs.resolvedType == TypeBinding.NULL) break block23;
                    rhsTrackVar = FakedTrackingVariable.getCloseTrackingVariable(rhs, flowInfo, flowContext, useAnnotations);
                    if (rhsTrackVar == null) break block24;
                    if (local.closeTracker != null) break block25;
                    if (rhsTrackVar.originalBinding != null) {
                        local.closeTracker = rhsTrackVar;
                    } else if (rhsTrackVar.originalFieldBinding != null) {
                        local.closeTracker = rhsTrackVar;
                    }
                    if (rhsTrackVar.currentAssignment == location) {
                        rhsTrackVar.globalClosingState &= -135;
                    }
                    break block23;
                }
                if (!(rhs instanceof AllocationExpression) && !(rhs instanceof ConditionalExpression) && !(rhs instanceof SwitchExpression) && !(rhs instanceof MessageSend)) ** GOTO lbl-1000
                if (rhsTrackVar == disconnectedTracker) {
                    return;
                }
                if (local.closeTracker == rhsTrackVar && rhsTrackVar.isNotOwned()) {
                    local.closeTracker = new FakedTrackingVariable(local, scope, location, flowInfo, flowContext, 2, useAnnotations);
                } else lbl-1000:
                // 2 sources

                {
                    rhsTrackVar.attachTo(local);
                }
                break block23;
            }
            if (previousTracker != null) {
                currentFlowContext = flowContext;
                if (previousTracker.tryContext != null) {
                    while (currentFlowContext != null) {
                        if (previousTracker.tryContext != currentFlowContext) {
                            currentFlowContext = currentFlowContext.parent;
                            continue;
                        }
                        break;
                    }
                } else {
                    if ((previousTracker.globalClosingState & 134) == 0 && flowInfo.hasNullInfoFor(previousTracker.binding)) {
                        previousTracker.markNullStatus(flowInfo, flowContext, 2);
                    }
                    local.closeTracker = FakedTrackingVariable.analyseCloseableExpression(scope, flowInfo, flowContext, useAnnotations, local, location, rhs, previousTracker);
                }
            } else {
                rhsTrackVar = FakedTrackingVariable.analyseCloseableExpression(scope, flowInfo, flowContext, useAnnotations, local, location, rhs, null);
                if (rhsTrackVar != null) {
                    rhsTrackVar.attachTo(local);
                    if (!useAnnotations && (rhsTrackVar.globalClosingState & 134) == 0) {
                        rhsTrackVar.markNullStatus(flowInfo, flowContext, 2);
                    }
                }
            }
        }
        if (disconnectedTracker != null) {
            if (disconnectedTracker.innerTracker != null && disconnectedTracker.innerTracker.binding.declaringScope == scope) {
                disconnectedTracker.innerTracker.outerTracker = null;
                scope.pruneWrapperTrackingVar(disconnectedTracker);
            } else {
                upstreamStatus = disconnectedTracker.riskyNullStatusAt(upstreamInfo);
                if (upstreamStatus != 0) {
                    disconnectedTracker.recordErrorLocation(location, upstreamStatus);
                }
            }
        }
    }

    public int riskyNullStatusAt(FlowInfo info) {
        if (this.hasDefinitelyNoResource(info)) {
            return 0;
        }
        int nullStatus = this.getNullStatusAggressively(this.binding, info);
        if ((nullStatus & 5) == 0) {
            return nullStatus;
        }
        return 0;
    }

    public static void handleResourceFieldAssignment(BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, ASTNode location, Expression rhs) {
        FakedTrackingVariable rhsTrackVar;
        boolean useAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
        if (rhs.resolvedType != TypeBinding.NULL && (rhsTrackVar = FakedTrackingVariable.getCloseTrackingVariable(rhs, flowInfo, flowContext, useAnnotations)) != null && useAnnotations && location instanceof Assignment) {
            Expression lhs = ((Assignment)location).lhs;
            FieldBinding field = null;
            if (lhs instanceof SingleNameReference) {
                field = ((SingleNameReference)lhs).fieldBinding();
            } else if (lhs instanceof FieldReference) {
                FieldReference fieldReference = (FieldReference)lhs;
                if (fieldReference.receiver.isThis()) {
                    field = fieldReference.binding;
                }
            }
            if (field != null && (field.tagBits & 0x400000000000000L) == 0L) {
                FakedTrackingVariable.checkFieldForMissingAnnotation(lhs, field, scope);
                if ((field.tagBits & 0x200000000000000L) != 0L) {
                    rhsTrackVar.markNullStatus(flowInfo, flowContext, 4);
                } else {
                    rhsTrackVar.markAsShared();
                }
            }
        }
    }

    private static FakedTrackingVariable analyseCloseableExpression(BlockScope scope, FlowInfo flowInfo, FlowContext flowContext, boolean useAnnotations, LocalVariableBinding local, ASTNode location, Expression expression, FakedTrackingVariable previousTracker) {
        FakedTrackingVariable tracker;
        ReferenceBinding resourceType;
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        if (expression instanceof Literal) {
            return null;
        }
        if (expression instanceof ConditionalExpression) {
            return FakedTrackingVariable.getMoreUnsafeFromBranches((ConditionalExpression)expression, flowInfo, branch -> FakedTrackingVariable.analyseCloseableExpression(scope, flowInfo, flowContext, useAnnotations, local, location, branch, previousTracker));
        }
        if (expression instanceof SwitchExpression) {
            SwitchExpression se = (SwitchExpression)expression;
            FakedTrackingVariable mostRisky = null;
            for (Expression result : se.resultExpressions()) {
                FakedTrackingVariable current = FakedTrackingVariable.analyseCloseableExpression(scope, flowInfo, flowContext, useAnnotations, local, location, result, previousTracker);
                mostRisky = FakedTrackingVariable.pickMoreUnsafe(mostRisky, current, flowInfo);
            }
            return mostRisky;
        }
        boolean isResourceProducer = false;
        if (expression.resolvedType instanceof ReferenceBinding && (resourceType = (ReferenceBinding)expression.resolvedType).hasTypeBit(8)) {
            if (FakedTrackingVariable.isBlacklistedMethod(expression)) {
                isResourceProducer = true;
            } else {
                return null;
            }
        }
        if (local == null) {
            tracker = null;
            if (useAnnotations && (expression.bits & 7) == 1) {
                FieldBinding fieldBinding = ((Reference)expression).lastFieldBinding();
                FakedTrackingVariable.checkFieldForMissingAnnotation(expression, fieldBinding, scope);
                long owningBits = 0L;
                if (fieldBinding != null) {
                    owningBits = fieldBinding.getAnnotationTagBits() & 0x600000000000000L;
                }
                int status = 1;
                if (owningBits == 0x200000000000000L) {
                    status = 4;
                } else if (owningBits == 0x400000000000000L) {
                    status = 16;
                }
                tracker = new FakedTrackingVariable(local, scope, location, flowInfo, flowContext, status, useAnnotations);
                tracker.owningState = -2;
            }
            return tracker;
        }
        if (expression instanceof AllocationExpression) {
            tracker = ((AllocationExpression)expression).closeTracker;
            if (tracker != null && tracker.originalBinding == null) {
                return null;
            }
            return tracker;
        }
        if (expression instanceof MessageSend || expression instanceof ArrayReference) {
            int initialNullStatus = 0;
            if (FakedTrackingVariable.isBlacklistedMethod(expression)) {
                initialNullStatus = 2;
            } else if (useAnnotations) {
                initialNullStatus = FakedTrackingVariable.getNullStatusFromMessageSend(expression, scope);
            }
            if (initialNullStatus != 0) {
                return new FakedTrackingVariable(local, location, flowInfo, flowContext, initialNullStatus, useAnnotations);
            }
            FakedTrackingVariable tracker2 = new FakedTrackingVariable(local, location, flowInfo, flowContext, 16, useAnnotations);
            if (!isResourceProducer && !useAnnotations) {
                tracker2.globalClosingState |= 2;
            }
            return tracker2;
        }
        if ((expression.bits & 7) == 1 || expression instanceof QualifiedNameReference && ((QualifiedNameReference)expression).isFieldAccess()) {
            if (!useAnnotations) {
                tracker = new FakedTrackingVariable(local, location, flowInfo, flowContext, 1, useAnnotations);
                tracker.globalClosingState |= 4;
                return tracker;
            }
        } else if (expression instanceof LambdaExpression) {
            return new FakedTrackingVariable(local, location, flowInfo, flowContext, 2, useAnnotations);
        }
        if (local.closeTracker != null) {
            return local.closeTracker;
        }
        FakedTrackingVariable newTracker = new FakedTrackingVariable(local, location, flowInfo, flowContext, 1, useAnnotations);
        LocalVariableBinding rhsLocal = expression.localVariableBinding();
        if (rhsLocal != null && rhsLocal.isParameter()) {
            newTracker.globalClosingState |= 4;
        }
        return newTracker;
    }

    private static boolean isBlacklistedMethod(Expression expression) {
        MethodBinding method;
        if (expression instanceof MessageSend && (method = ((MessageSend)expression).binding) != null && method.isValidBinding()) {
            return CharOperation.equals(method.declaringClass.compoundName, TypeConstants.JAVA_NIO_FILE_FILES);
        }
        return false;
    }

    protected static int getNullStatusFromMessageSend(Expression expression, Scope scope) {
        if (expression instanceof MessageSend) {
            MessageSend message = (MessageSend)expression;
            FakedTrackingVariable.checkMethodForMissingAnnotation(message, scope);
            if ((((MessageSend)expression).binding.tagBits & 0x400000000000000L) != 0L) {
                return 4;
            }
            return 2;
        }
        return 0;
    }

    public static void cleanUpAfterAssignment(BlockScope currentScope, int lhsBits, Expression expression) {
        boolean useAnnotations = currentScope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
        if (useAnnotations && (lhsBits & 1) != 0) {
            return;
        }
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable tracker = ((AllocationExpression)expression).closeTracker;
            if (tracker != null && tracker.originalBinding == null) {
                tracker.withdraw();
                ((AllocationExpression)expression).closeTracker = null;
            }
        } else if (expression instanceof MessageSend) {
            FakedTrackingVariable tracker = ((MessageSend)expression).closeTracker;
            if (tracker != null && tracker.originalBinding == null) {
                tracker.withdraw();
                ((MessageSend)expression).closeTracker = null;
            }
        } else {
            LocalVariableBinding local = expression.localVariableBinding();
            if (local != null && (lhsBits & 1) != 0 && !useAnnotations && local.closeTracker != null) {
                local.closeTracker.withdraw();
            }
        }
    }

    public static void cleanUpUnassigned(BlockScope scope, final ASTNode location, final FlowInfo flowInfo, final boolean returnMissingOwning) {
        if (!scope.hasResourceTrackers()) {
            return;
        }
        final boolean useAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
        location.traverse(new ASTVisitor(){

            @Override
            public boolean visit(MessageSend messageSend, BlockScope skope) {
                FakedTrackingVariable closeTracker = messageSend.closeTracker;
                this.handle(closeTracker, flowInfo, messageSend, skope);
                return true;
            }

            @Override
            public boolean visit(AllocationExpression allocation, BlockScope skope) {
                if (this.handle(allocation.closeTracker, flowInfo, allocation, skope)) {
                    allocation.closeTracker = null;
                }
                return true;
            }

            protected boolean handle(FakedTrackingVariable closeTracker, FlowInfo flow, ASTNode loc, BlockScope skope) {
                if (closeTracker != null && closeTracker.originalBinding == null && closeTracker.originalFieldBinding == null) {
                    int nullStatus = closeTracker.riskyNullStatusAt(flow);
                    if (nullStatus != 0) {
                        int reportFlag = closeTracker.reportError(skope.problemReporter(), loc, nullStatus);
                        closeTracker.markAllConnected(ftv -> {
                            int n2 = ftv.globalClosingState = ftv.globalClosingState | reportFlag;
                        });
                    } else if (returnMissingOwning && useAnnotations) {
                        skope.problemReporter().shouldMarkMethodAsOwning(location);
                    }
                    closeTracker.withdraw();
                    return true;
                }
                return false;
            }
        }, scope);
    }

    public static boolean isAnyCloseable(TypeBinding typeBinding) {
        return typeBinding instanceof ReferenceBinding && typeBinding.hasTypeBit(3);
    }

    public static boolean isCloseableNotWhiteListed(TypeBinding typeBinding) {
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
            return referenceBinding.hasTypeBit(3) && !referenceBinding.hasTypeBit(8);
        }
        return false;
    }

    public int findMostSpecificStatus(FlowInfo flowInfo, BlockScope currentScope, BlockScope locationScope) {
        int status = 1;
        FakedTrackingVariable currentTracker = this;
        while (currentTracker != null) {
            LocalVariableBinding currentVar = currentTracker.binding;
            int currentStatus = this.getNullStatusAggressively(currentVar, flowInfo);
            if (locationScope != null) {
                currentStatus = this.mergeCloseStatus(locationScope, currentStatus, currentVar, currentScope);
            }
            if (currentStatus == 4) {
                status = currentStatus;
                break;
            }
            if (status == 2 || status == 1) {
                status = currentStatus;
            }
            currentTracker = currentTracker.innerTracker;
        }
        return status;
    }

    private int getNullStatusAggressively(LocalVariableBinding local, FlowInfo flowInfo) {
        if (flowInfo == FlowInfo.DEAD_END) {
            return 1;
        }
        int reachMode = flowInfo.reachMode();
        int status = 0;
        try {
            if (reachMode != 0) {
                flowInfo.tagBits &= 0xFFFFFFFC;
            }
            status = flowInfo.nullStatus(local);
            if (TEST_372319) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            flowInfo.tagBits |= reachMode;
        }
        if ((status & 2) != 0) {
            if ((status & 0x24) != 0) {
                return 16;
            }
            return 2;
        }
        if ((status & 4) != 0) {
            if ((status & 0x10) != 0) {
                return 16;
            }
            return 4;
        }
        if ((status & 0x10) != 0) {
            return 16;
        }
        if (status == 1 && this.originalBinding == null && this.originalFieldBinding == null) {
            return 2;
        }
        return status;
    }

    public int mergeCloseStatus(BlockScope currentScope, int status, LocalVariableBinding local, BlockScope outerScope) {
        if (status != 4) {
            if (currentScope.finallyInfo != null) {
                int finallyStatus = currentScope.finallyInfo.nullStatus(local);
                if (finallyStatus == 4) {
                    return finallyStatus;
                }
                if (finallyStatus != 2 && currentScope.finallyInfo.hasNullInfoFor(local)) {
                    status = 16;
                }
            }
            if (currentScope != outerScope && currentScope.parent instanceof BlockScope) {
                return this.mergeCloseStatus((BlockScope)currentScope.parent, status, local, outerScope);
            }
        }
        return status;
    }

    public void markClose(FlowInfo flowInfo, FlowContext flowContext) {
        this.markAllConnected(current -> {
            flowInfo.markAsDefinitelyNonNull(current.binding);
            current.globalClosingState |= 1;
            flowContext.markFinallyNullStatus(current.binding, 4);
        });
    }

    public void markNullStatus(FlowInfo flowInfo, FlowContext flowContext, int status) {
        this.markAllConnected(current -> {
            flowInfo.markNullStatus(current.binding, status);
            flowContext.markFinallyNullStatus(current.binding, status);
        });
    }

    public void markOwnedByOutside(FlowInfo flowInfo, FlowContext flowContext) {
        this.markAllConnected(current -> {
            flowInfo.markAsDefinitelyNonNull(current.binding);
            flowContext.markFinallyNullStatus(current.binding, 4);
            current.globalClosingState = 4;
        });
    }

    public void markAllConnected(Consumer<FakedTrackingVariable> operation) {
        FakedTrackingVariable current = this;
        do {
            operation.accept(current);
        } while ((current = current.innerTracker) != null);
        current = this.outerTracker;
        while (current != null) {
            operation.accept(current);
            current = current.outerTracker;
        }
    }

    public void markClosedInNestedMethod() {
        this.globalClosingState |= 8;
    }

    public boolean isClosedInNestedMethod() {
        return (this.globalClosingState & 8) != 0;
    }

    public void markClosedEffectivelyFinal() {
        this.globalClosingState |= 0x100;
    }

    public static FlowInfo markPassedToOutside(BlockScope scope, Expression expression, FlowInfo flowInfo, FlowContext flowContext, boolean owned) {
        FakedTrackingVariable trackVar = FakedTrackingVariable.getCloseTrackingVariable(expression, flowInfo, flowContext, scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled);
        if (trackVar != null) {
            FlowInfo infoResourceIsClosed = owned ? flowInfo : flowInfo.copy();
            int flag = owned ? 4 : 2;
            trackVar.markAllConnected(ftv -> {
                ftv.globalClosingState |= flag;
                if (scope.methodScope() != ftv.methodScope) {
                    ftv.globalClosingState |= 8;
                }
                ftv.markNullStatus(flowInfo, flowContext, 4);
            });
            if (owned) {
                return infoResourceIsClosed;
            }
            return FlowInfo.conditional(flowInfo, infoResourceIsClosed).unconditionalCopy();
        }
        return flowInfo;
    }

    public static void markForeachElementVar(LocalDeclaration local) {
        if (local.binding != null && local.binding.closeTracker != null) {
            local.binding.closeTracker.globalClosingState |= 0x80;
        }
    }

    public boolean hasDefinitelyNoResource(FlowInfo flowInfo) {
        if (this.originalBinding == null) {
            return false;
        }
        if (flowInfo.isDefinitelyNull(this.originalBinding)) {
            return true;
        }
        return !flowInfo.isDefinitelyAssigned(this.originalBinding) && !flowInfo.isPotentiallyAssigned(this.originalBinding);
    }

    public boolean isClosedInFinallyOfEnclosing(BlockScope scope) {
        BlockScope currentScope = scope;
        while (currentScope.finallyInfo == null || !currentScope.finallyInfo.isDefinitelyNonNull(this.binding)) {
            if (!(currentScope.parent instanceof BlockScope)) {
                return false;
            }
            currentScope = (BlockScope)currentScope.parent;
        }
        return true;
    }

    public boolean isClosedInFinally() {
        return this.blockScope != null && this.isClosedInFinallyOfEnclosing(this.blockScope);
    }

    public boolean isResourceBeingReturned(FakedTrackingVariable returnedResource, boolean useOwningAnnotation) {
        FakedTrackingVariable current = this;
        do {
            if (current != returnedResource) continue;
            if (!useOwningAnnotation) {
                this.globalClosingState |= 0x40;
            }
            return true;
        } while ((current = current.innerTracker) != null);
        return false;
    }

    public void withdraw() {
        this.binding.declaringScope.removeTrackingVar(this);
        if (this.acquisition != null && this.acquisition.closeTracker == this) {
            this.acquisition.closeTracker = null;
        }
    }

    public void recordErrorLocation(ASTNode location, int nullStatus) {
        if (this.isNotOwned()) {
            return;
        }
        if (this.recordedLocations == null) {
            this.recordedLocations = new HashMap();
        }
        this.recordedLocations.put(location, nullStatus);
    }

    public boolean reportRecordedErrors(Scope scope, int mergedStatus, boolean atDeadEnd) {
        FakedTrackingVariable current = this;
        while (current.globalClosingState == 0) {
            current = current.innerTracker;
            if (current != null) continue;
            if (atDeadEnd && this.neverClosedAtLocations()) {
                mergedStatus = 2;
            }
            if ((mergedStatus & 0x32) == 0) break;
            this.reportError(scope.problemReporter(), null, mergedStatus);
            return true;
        }
        boolean hasReported = false;
        if (this.recordedLocations != null) {
            int reportFlags = 0;
            for (Map.Entry<ASTNode, Integer> entry : this.recordedLocations.entrySet()) {
                reportFlags |= this.reportError(scope.problemReporter(), entry.getKey(), entry.getValue());
                hasReported = true;
            }
            if (reportFlags != 0) {
                current = this;
                do {
                    current.globalClosingState |= reportFlags;
                } while ((current = current.innerTracker) != null);
            }
        }
        return hasReported;
    }

    public boolean hasRecordedLocations() {
        return this.recordedLocations != null;
    }

    private boolean neverClosedAtLocations() {
        if (this.recordedLocations != null) {
            for (Integer value : this.recordedLocations.values()) {
                if (((Object)value).equals(2)) continue;
                return false;
            }
        }
        return true;
    }

    public int reportError(ProblemReporter problemReporter, ASTNode location, int nullStatus) {
        int reportFlag;
        if (this.isNotOwned()) {
            return 0;
        }
        boolean isPotentialProblem = false;
        if (nullStatus == 2) {
            if ((this.globalClosingState & 8) != 0) {
                isPotentialProblem = true;
            }
        } else if ((nullStatus & 0x30) != 0) {
            isPotentialProblem = true;
        }
        if (isPotentialProblem) {
            if ((this.globalClosingState & 0x60) != 0) {
                return 0;
            }
            problemReporter.potentiallyUnclosedCloseable(this, location);
        } else {
            if ((this.globalClosingState & 0x40) != 0) {
                return 0;
            }
            problemReporter.unclosedCloseable(this, location);
        }
        int n = reportFlag = isPotentialProblem ? 32 : 64;
        if (location == null) {
            this.markAllConnected(current -> {
                int n2 = current.globalClosingState = current.globalClosingState | reportFlag;
            });
        }
        return reportFlag;
    }

    public void reportExplicitClosing(ProblemReporter problemReporter) {
        if (this.originalBinding != null && this.originalBinding.isParameter()) {
            return;
        }
        if ((this.globalClosingState & 1) == 0) {
            return;
        }
        if ((this.globalClosingState & 0x194) == 0) {
            if (this.originalFieldBinding != null && this.blockScope instanceof MethodScope) {
                AbstractMethodDeclaration method = ((MethodScope)this.blockScope).referenceMethod();
                if (method.binding != null && method.binding.isClosingMethod()) {
                    return;
                }
            }
            this.globalClosingState |= 0x10;
            problemReporter.explicitlyClosedAutoCloseable(this);
        }
    }

    public String nameForReporting(ASTNode location, ReferenceContext referenceContext) {
        int reportLine;
        int[] lineEnds;
        int resourceLine;
        CompilationResult compResult;
        if (this.name == UNASSIGNED_CLOSEABLE_NAME && location != null && referenceContext != null && (compResult = referenceContext.compilationResult()) != null && (resourceLine = Util.getLineNumber(this.sourceStart, lineEnds = compResult.getLineSeparatorPositions(), 0, lineEnds.length - 1)) != (reportLine = Util.getLineNumber(location.sourceStart, lineEnds, 0, lineEnds.length - 1))) {
            char[] replacement = Integer.toString(resourceLine).toCharArray();
            return String.valueOf(CharOperation.replace(UNASSIGNED_CLOSEABLE_NAME_TEMPLATE, TEMPLATE_ARGUMENT, replacement));
        }
        if (this.originalFieldBinding != null) {
            return String.valueOf(CharOperation.concat(ConstantPool.This, this.name, '.'));
        }
        return String.valueOf(this.name);
    }

    public void markAsShared() {
        this.globalClosingState |= 2;
    }

    public boolean isShared() {
        return (this.globalClosingState & 2) != 0;
    }

    protected boolean isNotOwned() {
        if (this.useAnnotations) {
            return this.owningState < 0;
        }
        return (this.globalClosingState & 4) != 0;
    }

    public boolean closeSeen() {
        return (this.globalClosingState & 1) != 0;
    }

    public static class IteratorForReporting
    implements Iterator<FakedTrackingVariable> {
        private final Set<FakedTrackingVariable> varSet;
        private final Scope scope;
        private final boolean atExit;
        private Stage stage;
        private Iterator<FakedTrackingVariable> iterator;
        private FakedTrackingVariable next;

        public IteratorForReporting(List<FakedTrackingVariable> variables, Scope scope, boolean atExit) {
            this.varSet = new HashSet<FakedTrackingVariable>(variables);
            this.scope = scope;
            this.atExit = atExit;
            this.setUpForStage(Stage.OuterLess);
        }

        @Override
        public boolean hasNext() {
            switch (this.stage) {
                case OuterLess: {
                    FakedTrackingVariable trackingVar;
                    while (this.iterator.hasNext()) {
                        trackingVar = this.iterator.next();
                        if (trackingVar.outerTracker != null) continue;
                        return this.found(trackingVar);
                    }
                    this.setUpForStage(Stage.InnerOfProcessed);
                }
                case InnerOfProcessed: {
                    FakedTrackingVariable outer;
                    FakedTrackingVariable trackingVar;
                    while (this.iterator.hasNext()) {
                        trackingVar = this.iterator.next();
                        outer = trackingVar.outerTracker;
                        if (outer.binding.declaringScope != this.scope || this.varSet.contains(outer)) continue;
                        return this.found(trackingVar);
                    }
                    this.setUpForStage(Stage.InnerOfNotEnclosing);
                }
                case InnerOfNotEnclosing: {
                    FakedTrackingVariable outer;
                    FakedTrackingVariable trackingVar;
                    block8: while (this.iterator.hasNext()) {
                        trackingVar = this.iterator.next();
                        outer = trackingVar.outerTracker;
                        if (this.varSet.contains(outer)) continue;
                        BlockScope outerTrackerScope = outer.binding.declaringScope;
                        Scope currentScope = this.scope;
                        while ((currentScope = currentScope.parent) instanceof BlockScope) {
                            if (outerTrackerScope == currentScope) break block8;
                        }
                        return this.found(trackingVar);
                    }
                    this.setUpForStage(Stage.AtExit);
                }
                case AtExit: {
                    if (this.atExit && this.iterator.hasNext()) {
                        return this.found(this.iterator.next());
                    }
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected Stage " + String.valueOf((Object)this.stage));
        }

        private boolean found(FakedTrackingVariable trackingVar) {
            this.iterator.remove();
            this.next = trackingVar;
            return true;
        }

        private void setUpForStage(Stage nextStage) {
            this.iterator = this.varSet.iterator();
            this.stage = nextStage;
        }

        @Override
        public FakedTrackingVariable next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static enum Stage {
            OuterLess,
            InnerOfProcessed,
            InnerOfNotEnclosing,
            AtExit;

        }
    }
}

