/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;

public class CallinMethodMappingsAttribute
extends AbstractAttribute {
    public static final short STATIC_ROLE_METHOD = 1;
    public static final short INHERITED = 4;
    public static final short COVARIANT_BASE_RETURN = 8;
    public static final int CONSTANT_PART_LENGTH = 20;
    public static final int BASE_METHOD_PART_LENGTH = 13;
    public Mapping[] _mappings;
    private int _size;

    public CallinMethodMappingsAttribute(CallinMappingDeclaration[] decls) {
        super(IOTConstants.CALLIN_METHOD_MAPPINGS);
        this._size = 0;
        int len = decls.length;
        int i = 0;
        while (i < decls.length) {
            if (decls[i].ignoreFurtherInvestigation) {
                --len;
            }
            ++i;
        }
        this._mappings = new Mapping[len];
        int idx = 0;
        int i2 = 0;
        while (i2 < decls.length) {
            CallinMappingDeclaration decl = decls[i2];
            if (!decl.ignoreFurtherInvestigation) {
                this._size += 20;
                short flags = 0;
                if (decl.roleMethodSpec.resolvedMethod.isStatic()) {
                    flags = (short)(flags | 1);
                }
                if (decl.hasCovariantReturn()) {
                    flags = (short)(flags | 8);
                }
                int n = idx++;
                Mapping mapping = new Mapping(decl.name, decl.roleMethodSpec.selector, decl.roleMethodSpec.signature(CompilerOptions.WeavingScheme.OTRE), flags, decl.liftMethod != null ? decl.liftMethod.selector : new char[]{}, decl.liftMethod != null ? decl.liftMethod.signature() : new char[]{}, decl.getCallinModifier());
                this._mappings[n] = mapping;
                Mapping currentMapping = mapping;
                currentMapping.setSMAPinfo(decl);
                MethodSpec[] baseMethods = decl.baseMethodSpecs;
                currentMapping._baseMethods = new BaseMethod[baseMethods.length];
                this._size += 2;
                int j = 0;
                while (j < baseMethods.length) {
                    MethodSpec bm = baseMethods[j];
                    MethodDeclaration wrapper = decl.getWrapper(bm);
                    this._size += 13;
                    currentMapping._baseMethods[j] = new BaseMethod(bm.codegenSeletor(), bm.resolvedMethod.signature(), wrapper.selector, wrapper.binding.signature(), bm.isCallin(), bm.resolvedMethod.isStatic(), bm.getTranslationFlags());
                    if (decl.mappings != null) {
                        currentMapping._baseMethods[j]._methodSpec = bm;
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    public CallinMethodMappingsAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.CALLIN_METHOD_MAPPINGS);
        this._reader = reader;
        this._readOffset = readOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        this._size = 0;
        int numMappings = this.consumeShort();
        this._mappings = new Mapping[numMappings];
        int i = 0;
        while (i < numMappings) {
            this._mappings[i] = this.readMapping();
            ++i;
        }
    }

    @Override
    public void merge(ModelElement model, AbstractAttribute other) {
        assert (other instanceof CallinMethodMappingsAttribute);
        assert (model instanceof TypeModel);
        ReferenceBinding typeBinding = ((TypeModel)model).getBinding();
        CallinMethodMappingsAttribute otherCMMA = (CallinMethodMappingsAttribute)other;
        HashMap<String, Mapping> set = new HashMap<String, Mapping>();
        LinkedList<CallinCalloutBinding> newBindings = new LinkedList<CallinCalloutBinding>();
        int i = 0;
        while (i < this._mappings.length) {
            set.put(new String(this._mappings[i]._mappingName), this._mappings[i]);
            ++i;
        }
        i = 0;
        while (i < otherCMMA._mappings.length) {
            Mapping mapping = otherCMMA._mappings[i];
            if (!set.containsKey(new String(mapping._mappingName))) {
                set.put(new String(mapping._mappingName), mapping.cloneForSubrole());
                this._size += mapping.getSize();
                newBindings.add(this.createBinding(typeBinding, mapping));
            }
            ++i;
        }
        Collection values = set.values();
        this._mappings = new Mapping[values.size()];
        values.toArray(this._mappings);
        if (newBindings.size() > 0) {
            CallinCalloutBinding[] callins = new CallinCalloutBinding[newBindings.size()];
            newBindings.toArray(callins);
            typeBinding.addCallinCallouts(callins);
        }
    }

    private Mapping readMapping() {
        this._size += 20;
        Mapping map = new Mapping(this.consumeName(), (short)this.consumeShort(), (short)this.consumeShort(), this.consumeName(), this.consumeName(), this.consumeName(), (short)this.consumeShort(), this.consumeName(), this.consumeName(), this.consumeName());
        this._size += 2;
        int numBaseMethods = this.consumeShort();
        map._baseMethods = new BaseMethod[numBaseMethods];
        int i = 0;
        while (i < numBaseMethods) {
            map._baseMethods[i] = this.readBaseMethod();
            ++i;
        }
        return map;
    }

    private BaseMethod readBaseMethod() {
        this._size += 13;
        return new BaseMethod(this.consumeName(), this.consumeName(), this.consumeName(), this.consumeName(), this.consumeByte(), this.consumeInt());
    }

    @Override
    public void write(ClassFile classFile) {
        super.write(classFile);
        this.writeValues(classFile);
        this.writeBack(classFile);
    }

    private void writeValues(ClassFile classFile) {
        if (this._contentsOffset + 8 + this._size >= this._contents.length) {
            this._contents = classFile.getResizedContents(8 + this._size);
        }
        this.writeName(this._name);
        this.writeInt(this._size + 2);
        this.writeUnsignedShort(this._mappings.length);
        int i = 0;
        while (i < this._mappings.length) {
            Mapping map = this._mappings[i];
            this.writeName(map._fileName);
            this.writeUnsignedShort(map._lineNumber);
            this.writeUnsignedShort(map._lineOffset);
            this.writeName(map._mappingName);
            this.writeName(map._roleSelector);
            this.writeName(map._roleSignature);
            this.writeUnsignedShort(map._flags);
            this.writeName(map._liftMethodName);
            this.writeName(map._liftMethodSignature);
            this.writeName(map._callinModifier);
            this.writeBaseMethods(this._mappings[i]._baseMethods);
            ++i;
        }
    }

    private void writeBaseMethods(BaseMethod[] methods) {
        this.writeUnsignedShort(methods.length);
        int i = 0;
        while (i < methods.length) {
            this.writeName(methods[i]._selector);
            this.writeName(methods[i]._signature);
            this.writeName(methods[i]._wrapperName);
            this.writeName(methods[i]._wrapperSign);
            int flags = 0;
            if (methods[i]._isCallin) {
                flags |= 1;
            }
            if (methods[i]._isStatic) {
                flags |= 2;
            }
            this.writeByte((byte)flags);
            if (methods[i]._methodSpec != null) {
                methods[i].fetchTranslationFlags();
            }
            this.writeInt(methods[i]._translationFlags);
            ++i;
        }
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 65536);
        if (((ReferenceBinding)binding).isRole()) {
            ((ReferenceBinding)binding).roleModel.addAttribute(this);
        }
    }

    @Override
    public void evaluateLateAttribute(ReferenceBinding roleBinding, int state) {
        if (state != 17) {
            return;
        }
        CallinCalloutBinding[] callins = new CallinCalloutBinding[this._mappings.length];
        int i = 0;
        while (i < this._mappings.length) {
            callins[i] = this.createBinding(roleBinding, this._mappings[i]);
            ++i;
        }
        if (callins.length > 0) {
            roleBinding.addCallinCallouts(callins);
        }
    }

    private CallinCalloutBinding createBinding(ReferenceBinding roleBinding, Mapping mapping) {
        int closePos;
        CallinCalloutBinding result = null;
        CallinCalloutBinding[] callinCallouts = roleBinding.callinCallouts;
        if (callinCallouts != null) {
            int i = 0;
            while (i < callinCallouts.length) {
                if (CharOperation.equals(mapping._mappingName, callinCallouts[i].name)) {
                    result = callinCallouts[i];
                    result.callinModifier = this.encodeCallinModifier(mapping._callinModifier);
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            result = new CallinCalloutBinding(roleBinding, mapping._mappingName, this.encodeCallinModifier(mapping._callinModifier));
        }
        BaseMethod[] mappingBaseMethods = mapping._baseMethods;
        MethodBinding[] baseMethods = new MethodBinding[mappingBaseMethods.length];
        ReferenceBinding currentType = roleBinding;
        char[] roleSignature = mapping._roleSignature;
        if (result.callinModifier == 142 && (closePos = CharOperation.indexOf(')', roleSignature)) > -1) {
            roleSignature = CharOperation.subarray(roleSignature, 0, closePos + 1);
        }
        block1: while (currentType != null) {
            ReferenceBinding currentType2 = currentType;
            while (currentType2 != null) {
                MethodBinding[] methods = currentType2.getMethods(mapping._roleSelector);
                int j = 0;
                while (j < methods.length) {
                    if (CharOperation.prefixEquals(roleSignature, MethodSpec.signature(methods[j], CompilerOptions.WeavingScheme.OTRE))) {
                        result._roleMethodBinding = methods[j];
                        break block1;
                    }
                    ++j;
                }
                currentType2 = currentType2.superclass();
            }
            currentType = currentType.enclosingType();
        }
        if (result._roleMethodBinding == null) {
            throw new InternalCompilerError("role method specified in callin mapping does not exist " + String.valueOf(mapping));
        }
        int i = 0;
        while (i < mappingBaseMethods.length) {
            block14: {
                BaseMethod bm = mappingBaseMethods[i];
                currentType = roleBinding.baseclass();
                while (currentType != null) {
                    MethodBinding[] methods = currentType.getMethods(bm._selector);
                    int j = 0;
                    while (j < methods.length) {
                        if (CharOperation.equals(bm._signature, methods[j].signature())) {
                            baseMethods[i] = methods[j];
                            break block14;
                        }
                        ++j;
                    }
                    currentType = currentType.superclass();
                }
                baseMethods[i] = new ProblemMethodBinding(bm._selector, null, roleBinding.baseclass(), 1);
            }
            ++i;
        }
        result._baseMethods = baseMethods;
        mapping._binding = result;
        result.copyInheritanceSrc = this.findTSuperBinding(mapping._mappingName, roleBinding);
        return result;
    }

    private CallinCalloutBinding findTSuperBinding(char[] name, ReferenceBinding roleType) {
        ReferenceBinding[] tsuperRoles = roleType.roleModel.getTSuperRoleBindings();
        int i = tsuperRoles.length - 1;
        while (i >= 0) {
            if (tsuperRoles[i].callinCallouts != null) {
                CallinCalloutBinding[] callinCalloutBindingArray = tsuperRoles[i].callinCallouts;
                int n = tsuperRoles[i].callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(mapping.name, name)) {
                        return mapping.copyInheritanceSrc != null ? mapping.copyInheritanceSrc : mapping;
                    }
                    ++n2;
                }
            }
            --i;
        }
        return null;
    }

    private int encodeCallinModifier(char[] modifierName) {
        if (CharOperation.equals(modifierName, IOTConstants.NAME_REPLACE)) {
            return 142;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_AFTER)) {
            return 138;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_BEFORE)) {
            return 143;
        }
        throw new InternalCompilerError("invalid callin modifier in byte code");
    }

    public int getLength() {
        return this._mappings.length;
    }

    public char[] getCallinNameAt(int i) {
        return this._mappings[i]._mappingName;
    }

    public String getRoleMethodNameAt(int i) {
        return new String(this._mappings[i]._roleSelector);
    }

    public String getRoleMethodSignatureAt(int i) {
        return new String(this._mappings[i]._roleSignature);
    }

    public String[] getBaseMethodNamesAt(int i) {
        BaseMethod[] baseMethods = this._mappings[i]._baseMethods;
        String[] names = new String[baseMethods.length];
        int j = 0;
        while (j < baseMethods.length) {
            names[j] = new String(baseMethods[j]._selector);
            ++j;
        }
        return names;
    }

    public String[] getBaseMethodSignaturesAt(int i) {
        BaseMethod[] baseMethods = this._mappings[i]._baseMethods;
        String[] signatures = new String[baseMethods.length];
        int j = 0;
        while (j < baseMethods.length) {
            signatures[j] = new String(baseMethods[j]._signature);
            ++j;
        }
        return signatures;
    }

    public int getCallinModifierAt(int i) {
        char[] modifierName = this._mappings[i]._callinModifier;
        if (CharOperation.equals(modifierName, IOTConstants.NAME_BEFORE)) {
            return 143;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_REPLACE)) {
            return 142;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_AFTER)) {
            return 138;
        }
        return -1;
    }

    public boolean getCovariantReturnAt(int i) {
        return (this._mappings[i]._flags & 8) != 0;
    }

    public String toString() {
        Object result = new String(this._name);
        int i = 0;
        while (i < this._mappings.length) {
            result = (String)result + "\n" + String.valueOf(this._mappings[i]);
            ++i;
        }
        return result;
    }

    public boolean isInherited() {
        Mapping[] mappingArray = this._mappings;
        int n = this._mappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            if ((mapping._flags & 4) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private class BaseMethod {
        static final int CALLIN = 1;
        static final int STATIC = 2;
        char[] _selector;
        char[] _signature;
        char[] _wrapperName;
        char[] _wrapperSign;
        boolean _isCallin;
        boolean _isStatic;
        int _translationFlags;
        MethodSpec _methodSpec = null;

        BaseMethod(char[] sel, char[] sig, char[] wrapName, char[] wrapSign, int flags, int translationFlags) {
            this(sel, sig, wrapName, wrapSign, (flags & 1) != 0, (flags & 2) != 0, translationFlags);
        }

        BaseMethod(char[] sel, char[] sig, char[] wrapName, char[] wrapSign, boolean isCallin, boolean isStatic, int translationFlags) {
            this._selector = sel;
            this._signature = sig;
            this._wrapperName = wrapName;
            this._wrapperSign = wrapSign;
            this._isCallin = isCallin;
            this._isStatic = isStatic;
            this._translationFlags = translationFlags;
        }

        public String toString() {
            return (this._isCallin ? "callin " : "") + (this._isStatic ? "static " : "") + new String(this._selector) + new String(this._signature);
        }

        public void fetchTranslationFlags() {
            this._translationFlags = this._methodSpec.getTranslationFlags();
            this._methodSpec = null;
        }
    }

    public class Mapping {
        public CallinCalloutBinding _binding;
        short _lineNumber;
        short _lineOffset;
        short _flags;
        char[] _fileName;
        char[] _mappingName;
        char[] _roleSelector;
        char[] _roleSignature;
        char[] _liftMethodName;
        char[] _liftMethodSignature;
        char[] _callinModifier;
        BaseMethod[] _baseMethods;

        Mapping(char[] name, char[] selector, char[] signature, short flags, char[] liftMethodName, char[] liftMethodSignature, char[] modifier) {
            this._mappingName = name;
            this._roleSelector = selector;
            this._roleSignature = signature;
            this._flags = flags;
            this._liftMethodName = liftMethodName;
            this._liftMethodSignature = liftMethodSignature;
            this._callinModifier = modifier;
        }

        Mapping(char[] fileName, short lineNumber, short lineOffset, char[] name, char[] selector, char[] signature, short flags, char[] liftMethodName, char[] liftMethodSignature, char[] modifier) {
            this(name, selector, signature, flags, liftMethodName, liftMethodSignature, modifier);
            this._fileName = fileName;
            this._lineNumber = lineNumber;
            this._lineOffset = lineOffset;
        }

        int getSize() {
            return 22 + this._baseMethods.length * 13;
        }

        public String toString() {
            String result = new String(this._mappingName) + ":\n" + new String(this._roleSelector) + new String(this._roleSignature) + " <- " + new String(this._callinModifier) + " ";
            int i = 0;
            while (i < this._baseMethods.length) {
                result = result + new String(this._baseMethods[i]._selector) + new String(this._baseMethods[i]._signature);
                if ((this._flags & 8) != 0) {
                    result = result + "+";
                }
                ++i;
            }
            if (this._liftMethodName.length > 0) {
                result = result + "\nlift by: " + new String(this._liftMethodName) + new String(this._liftMethodSignature);
            }
            return result;
        }

        void setSMAPinfo(CallinMappingDeclaration decl) {
            this._fileName = this.getFileName(decl);
            int[] lineEnds = decl.scope.referenceCompilationUnit().compilationResult().getLineSeparatorPositions();
            this._lineNumber = (short)Util.getLineNumber(decl.sourceStart, lineEnds, 0, lineEnds.length - 1);
            short lineEnd = (short)Util.getLineNumber(decl.declarationSourceEnd, lineEnds, 0, lineEnds.length - 1);
            this._lineOffset = (short)(lineEnd - this._lineNumber);
        }

        private char[] getFileName(CallinMappingDeclaration decl) {
            CompilationUnitDeclaration compilationUnit = decl.scope.referenceCompilationUnit();
            char[] fullName = compilationUnit.getFileName();
            char[][] packageName = null;
            if (compilationUnit.currentPackage == null || compilationUnit.currentPackage.tokens.length == 0) {
                int pos = CharOperation.lastIndexOf('/', fullName);
                if (pos == -1) {
                    return fullName;
                }
                return CharOperation.subarray(fullName, pos + 1, -1);
            }
            packageName = compilationUnit.currentPackage.tokens;
            char[][] components = CharOperation.splitOn('/', fullName);
            int pos = CharOperation.lastIndexOf('/', fullName);
            if (pos == -1) {
                return CharOperation.concatWith(packageName, fullName, '/');
            }
            if (components.length <= packageName.length) {
                throw new InternalCompilerError("too few path elements");
            }
            int start = components.length - (packageName.length + 1);
            int end = components.length;
            if (!CharOperation.equals(packageName, CharOperation.subarray(components, start, end - 1))) {
                decl.scope.problemReporter().packageIsNotExpectedPackage(compilationUnit);
            }
            return CharOperation.concatWith(CharOperation.subarray(components, start, end), '/');
        }

        public boolean roleMethodIsPrivate() {
            if (this._binding == null) {
                return false;
            }
            return this._binding._roleMethodBinding.isPrivate();
        }

        public char[][] getWrapperNames() {
            if (this._baseMethods == null) {
                return null;
            }
            char[][] names = new char[this._baseMethods.length][];
            int i = 0;
            while (i < this._baseMethods.length) {
                names[i] = this._baseMethods[i]._wrapperName;
                ++i;
            }
            return names;
        }

        public char[][] getWrapperSignatures() {
            if (this._baseMethods == null) {
                return null;
            }
            char[][] signatures = new char[this._baseMethods.length][];
            int i = 0;
            while (i < this._baseMethods.length) {
                signatures[i] = this._baseMethods[i]._wrapperSign;
                ++i;
            }
            return signatures;
        }

        public Mapping cloneForSubrole() {
            Mapping other = new Mapping(this._fileName, this._lineNumber, this._lineOffset, this._mappingName, this._roleSelector, this._roleSignature, this._flags, this._liftMethodName, this._liftMethodSignature, this._callinModifier);
            other._flags = (short)(other._flags | 4);
            other._baseMethods = this._baseMethods;
            return other;
        }
    }
}

