/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialRoleReceiverExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinMethodMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinParamMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CopyInheritanceSourceAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.StaticReplaceBindingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.MethodMappingImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SourcePosition;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.StepOverSourcePosition;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.PredicateGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class CallinImplementor
extends MethodMappingImplementor {
    public static final String OT_LOCAL = "_OT$local$";
    static final char[] ROLE_VAR_NAME = CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, IOTConstants.ROLE);
    static final char[] OLD_IS_EXECUTING = "_OT$oldIsExecuting".toCharArray();
    private ClassScope _roleScope;

    public CallinImplementor(RoleModel role) {
        super(role);
        this._roleScope = role.getAst().scope;
        this.bindingDirection = 3;
    }

    public boolean transform() {
        AbstractMethodMappingDeclaration[] methodMappings = this._role.getAst().callinCallouts;
        if (methodMappings == null || methodMappings.length == 0) {
            return true;
        }
        if (this._role._hasBindingAmbiguity) {
            int i = 0;
            while (i < methodMappings.length) {
                if (methodMappings[i].isCallin()) {
                    this._roleScope.problemReporter().callinDespiteLiftingProblem(this._role.getBinding(), 141003, methodMappings[i]);
                }
                ++i;
            }
        }
        boolean result = true;
        CallinMappingDeclaration[] callinMappings = new CallinMappingDeclaration[methodMappings.length];
        int num = 0;
        LinkedList<CallinMappingDeclaration> staticReplaces = new LinkedList<CallinMappingDeclaration>();
        int idx = 0;
        while (idx < methodMappings.length) {
            AbstractMethodMappingDeclaration methodMapping = methodMappings[idx];
            if (!methodMapping.ignoreFurtherInvestigation && methodMapping.isCallin()) {
                result &= this.createCallin((CallinMappingDeclaration)methodMapping);
                callinMappings[num++] = (CallinMappingDeclaration)methodMapping;
                if (methodMapping.isStaticReplace()) {
                    staticReplaces.add((CallinMappingDeclaration)methodMapping);
                }
            }
            ++idx;
        }
        CallinMappingDeclaration[] callinMappingDeclarationArray = callinMappings;
        callinMappings = new CallinMappingDeclaration[num];
        System.arraycopy(callinMappingDeclarationArray, 0, callinMappings, 0, num);
        this._role.addAttribute(new CallinMethodMappingsAttribute(callinMappings));
        if (staticReplaces.size() > 0) {
            CallinMappingDeclaration[] callins = new CallinMappingDeclaration[staticReplaces.size()];
            staticReplaces.toArray(callins);
            this._role.getTeamModel().addOrMergeAttribute(new StaticReplaceBindingsAttribute(callins));
        }
        return result;
    }

    private boolean createCallin(CallinMappingDeclaration callinMappingDeclaration) {
        callinMappingDeclaration.updateTSuperMethods();
        MethodBinding roleMethodBinding = callinMappingDeclaration.getRoleMethod();
        if (roleMethodBinding == null || !roleMethodBinding.isValidBinding()) {
            return false;
        }
        MethodSpec[] baseMethodSpecs = callinMappingDeclaration.baseMethodSpecs;
        int i = 0;
        while (i < baseMethodSpecs.length) {
            this.createWrapperMethod(callinMappingDeclaration, roleMethodBinding, baseMethodSpecs[i]);
            ++i;
        }
        return true;
    }

    private void createWrapperMethod(final CallinMappingDeclaration callinBindingDeclaration, final MethodBinding roleMethodBinding, final MethodSpec baseMethodSpec) {
        TypeBinding typeBinding;
        TypeBinding wrapperReturnType;
        TypeDeclaration teamDecl = this._role.getTeamModel().getAst();
        final AstGenerator gen = new AstGenerator(callinBindingDeclaration.roleMethodSpec.sourceStart, callinBindingDeclaration.roleMethodSpec.sourceEnd);
        gen.replaceableEnclosingClass = teamDecl.binding;
        if (this._role.getClassPartBinding() != null) {
            gen.replaceableBaseAnchor = this._role.getClassPartBinding().getField(IOTConstants._OT_BASE, true);
        }
        char[] roleName = this._role.getName();
        char[] roleMethodName = roleMethodBinding.selector;
        char[] newMethodName = this.makeWrapperName(callinBindingDeclaration, roleName, roleMethodName, baseMethodSpec.selector);
        char[] otBaseArg = IOTConstants.BASE;
        TypeParameter[] typeParams = this.getTypeParameters(callinBindingDeclaration.hasSignature, roleMethodBinding, callinBindingDeclaration.roleMethodSpec, gen);
        Argument[] arguments = this.copyArguments(gen, callinBindingDeclaration.scope, baseMethodSpec.resolvedParameters(), baseMethodSpec);
        if (arguments != null && typeParams != null) {
            TypeBinding[] roleParams = callinBindingDeclaration.roleMethodSpec.resolvedParameters();
            Pair[] mappingExpressions = callinBindingDeclaration.mappingExpressions;
            int i = 0;
            while (i < arguments.length) {
                TypeBinding mappedRoleParam = null;
                if (mappingExpressions != null) {
                    int j = 0;
                    while (j < mappingExpressions.length) {
                        if ((Integer)mappingExpressions[j].second == i) {
                            mappedRoleParam = roleParams[j];
                            break;
                        }
                        ++j;
                    }
                } else if (i < roleParams.length) {
                    mappedRoleParam = roleParams[i];
                }
                if (mappedRoleParam != null && mappedRoleParam.isTypeVariable()) {
                    arguments[i].type = gen.singleTypeReference(mappedRoleParam.internalName());
                }
                ++i;
            }
        }
        if (arguments != null) {
            int len = arguments.length;
            Argument[] argumentArray = arguments;
            arguments = new Argument[len + 1];
            System.arraycopy(argumentArray, 0, arguments, 1, len);
        } else {
            arguments = new Argument[1];
        }
        final ReferenceBinding baseTypeBinding = this._role.getBaseTypeBinding();
        TypeReference baseTypeReference = gen.baseclassReference(baseTypeBinding);
        Argument baseArgument = gen.argument(otBaseArg, baseTypeReference);
        baseArgument.modifiers |= 0x10;
        baseArgument.isGenerated = true;
        arguments[0] = baseArgument;
        if (callinBindingDeclaration.isReplaceCallin()) {
            wrapperReturnType = MethodModel.getReturnType(roleMethodBinding);
            typeBinding = wrapperReturnType;
        } else {
            typeBinding = wrapperReturnType = TypeBinding.VOID;
        }
        if (baseMethodSpec.returnNeedsTranslation) {
            char[] liftCallSelector;
            TypeBinding roleReturn = callinBindingDeclaration.realRoleReturn;
            int dims = wrapperReturnType.dimensions();
            if (roleReturn == null) {
                roleReturn = wrapperReturnType;
            }
            wrapperReturnType = ((ReferenceBinding)roleReturn.leafComponentType()).baseclass();
            if (dims > 0) {
                wrapperReturnType = this._roleScope.createArrayType(wrapperReturnType, dims);
                liftCallSelector = new ArrayLifting().ensureTransformMethod((BlockScope)callinBindingDeclaration.scope, (Expression)gen.thisReference(), (TypeBinding)wrapperReturnType, (TypeBinding)roleReturn, (boolean)true).selector;
            } else {
                liftCallSelector = Lifting.getLiftMethodName(roleReturn);
            }
            TypeDeclaration teamType = this._roleScope.referenceContext;
            AbstractMethodDeclaration liftMethod = null;
            while (liftMethod == null) {
                if (teamType == null) {
                    throw new InternalCompilerError("Required lift method " + String.valueOf(liftCallSelector) + " not found in scope of role " + String.valueOf(this._roleScope.referenceContext.name));
                }
                if (teamType.isRole()) {
                    teamType = teamType.getRoleModel().getInterfaceAst();
                }
                liftMethod = TypeAnalyzer.findMethodDecl(teamType, liftCallSelector, 1);
                teamType = teamType.enclosingType;
            }
            callinBindingDeclaration.liftMethod = liftMethod.binding;
        }
        boolean isReturnBoxed = false;
        TypeBinding baseReturnType = baseMethodSpec.resolvedMethod.returnType;
        if (callinBindingDeclaration.isReplaceCallin()) {
            arguments = MethodSignatureEnhancer.enhanceArguments(arguments, new char[0], true, gen, this._role.getWeavingScheme());
            if (wrapperReturnType.isBaseType()) {
                TypeBinding baseReturn = baseReturnType;
                isReturnBoxed = baseReturn.isBaseType() && baseReturn != TypeBinding.VOID;
                wrapperReturnType = callinBindingDeclaration.scope.getJavaLangObject();
            }
        } else if (callinBindingDeclaration.callinModifier == 138) {
            arguments = this.addResultArgument(arguments, callinBindingDeclaration, baseMethodSpec, gen);
        }
        Argument[] argumentArray = arguments;
        int liftMethod = arguments.length;
        int teamType = 0;
        while (teamType < liftMethod) {
            Argument argument = argumentArray[teamType];
            argument.type.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
            ++teamType;
        }
        int modifiers = 1;
        if (callinBindingDeclaration.isReplaceCallin()) {
            modifiers |= Integer.MIN_VALUE;
        }
        MethodDeclaration newMethod = gen.method(teamDecl.compilationResult, modifiers, wrapperReturnType, newMethodName, arguments);
        newMethod.thrownExceptions = AstClone.copyExceptions(baseMethodSpec.resolvedMethod, gen);
        newMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLIN;
        newMethod.returnType.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        newMethod.typeParameters = typeParams;
        gen.maybeAddTypeParametersToMethod(baseTypeBinding, newMethod);
        int iProblem = teamDecl.getTeamModel().canLiftingFail(this._role.getBinding());
        if (iProblem != 0) {
            callinBindingDeclaration.addRoleLiftingProblem(this._role.getBinding(), iProblem);
        }
        if (callinBindingDeclaration.rolesWithLiftingProblem != null) {
            this.declareLiftingFailedException(callinBindingDeclaration, newMethod, gen);
        }
        AstEdit.addMethod(teamDecl, newMethod);
        callinBindingDeclaration.setWrapper(baseMethodSpec, newMethod);
        MethodModel.addCallinFlag(newMethod, 2);
        newMethod.model._declaringMappings = Collections.singletonList(callinBindingDeclaration);
        if (newMethod.hasErrors()) {
            AstEdit.removeMethod(teamDecl, newMethod.binding);
            return;
        }
        this.setBaseArgBestName(newMethod, baseArgument);
        final TypeBinding finalWrapperReturnType = wrapperReturnType;
        final boolean finalIsReturnBoxed = isReturnBoxed;
        final RoleModel finalRole = this._role;
        MethodModel.getModel(newMethod).setStatementsGenerator(new AbstractStatementsGenerator(){

            @Override
            public boolean generateStatements(AbstractMethodDeclaration methodDecl) {
                return CallinImplementor.this.generateCallinStatements((MethodDeclaration)methodDecl, callinBindingDeclaration, finalRole, roleMethodBinding, baseTypeBinding, baseMethodSpec, finalWrapperReturnType, finalIsReturnBoxed, gen);
            }
        });
    }

    protected void declareLiftingFailedException(CallinMappingDeclaration callinBindingDeclaration, MethodDeclaration wrapperMethod, AstGenerator gen) {
        QualifiedTypeReference liftingFailed = gen.qualifiedTypeReference(IOTConstants.O_O_LIFTING_FAILED_EXCEPTION);
        AstEdit.addException(wrapperMethod, liftingFailed, false);
        for (Map.Entry<ReferenceBinding, Integer> entry : callinBindingDeclaration.rolesWithLiftingProblem.entrySet()) {
            this._roleScope.problemReporter().callinDespiteLiftingProblem(entry.getKey(), entry.getValue(), callinBindingDeclaration);
        }
    }

    boolean generateCallinStatements(MethodDeclaration callinWrapperDecl, CallinMappingDeclaration callinBindingDeclaration, RoleModel roleModel, MethodBinding roleMethodBinding, ReferenceBinding baseTypeBinding, MethodSpec baseMethodSpec, TypeBinding wrapperReturnType, boolean isReturnBoxed, AstGenerator gen) {
        Statement predicateCheck;
        if (callinBindingDeclaration.mappings == AbstractMethodMappingDeclaration.PENDING_MAPPINGS) {
            return false;
        }
        if (this._role.isRoleFile()) {
            this.synthGen = MethodModel.setupSourcePositionMapping(callinWrapperDecl, callinWrapperDecl.sourceStart, this._role.getTeamModel().getAst(), this._role, null);
            if (this.synthGen != null) {
                gen = this.synthGen;
            }
        }
        PredicateGenerator predGen = new PredicateGenerator(roleModel.getBinding(), callinBindingDeclaration.isReplaceCallin());
        char[] roleTypeName = roleModel.getInterfaceAst().name;
        char[] otBaseArg = IOTConstants.BASE;
        char[] roleMethodName = roleMethodBinding.selector;
        TypeBinding[] roleParameters = roleMethodBinding.getSourceParameters();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        char[] resultName = null;
        if (callinBindingDeclaration.callinModifier == 138 && baseMethodSpec.resolvedType() != TypeBinding.VOID) {
            resultName = IOTConstants.RESULT;
        }
        if ((predicateCheck = predGen.createBasePredicateCheck(callinBindingDeclaration, baseMethodSpec, resultName, gen)) != null) {
            statements.add(predicateCheck);
        }
        MessageSend resetFlag = CallinImplementor.setExecutingCallin(roleModel, statements);
        ArrayList<Statement> tryStatements = new ArrayList<Statement>();
        Expression receiver = null;
        Expression[] messageSendArguments = this.makeWrapperCallArguments(callinBindingDeclaration, callinWrapperDecl, baseMethodSpec, null, resultName != null);
        if (messageSendArguments == null) {
            callinBindingDeclaration.tagAsHavingErrors();
            return false;
        }
        this.packUnmappedArgs(baseMethodSpec, callinBindingDeclaration, callinWrapperDecl, tryStatements, gen);
        Expression[] predicateArgs = null;
        int offset = callinBindingDeclaration.isReplaceCallin() ? this.getMethodSignatureEnhancer().ENHANCING_ARG_LEN : 0;
        int plainLen = messageSendArguments.length - offset;
        boolean needRoleVar = false;
        if (roleMethodBinding.isStatic()) {
            receiver = gen.singleNameReference(roleMethodBinding.declaringClass.sourceName());
            if (offset > 0) {
                predicateArgs = new Expression[plainLen];
                System.arraycopy(messageSendArguments, offset, predicateArgs, 0, plainLen);
            } else {
                predicateArgs = messageSendArguments;
            }
            predicateArgs = this.maybeAddResultReference(callinBindingDeclaration, predicateArgs, resultName, gen);
        } else {
            if (!roleModel.getBinding().isCompatibleWith(roleMethodBinding.declaringClass)) {
                receiver = gen.qualifiedThisReference(TeamModel.strengthenEnclosing(roleModel.getBinding().enclosingType(), roleMethodBinding.declaringClass));
            } else {
                receiver = gen.singleNameReference(ROLE_VAR_NAME);
                needRoleVar = true;
                if (roleMethodBinding.isPrivate()) {
                    receiver = gen.castExpression(receiver, gen.typeReference(roleModel.getClassPartBinding()), 1);
                }
            }
            if (needRoleVar) {
                tryStatements.add(this.createLiftedRoleVar(callinBindingDeclaration, roleModel, baseTypeBinding, otBaseArg, gen));
            }
            assert (roleParameters.length == plainLen);
            Expression[] newArgs = new Expression[plainLen];
            int i = offset;
            while (i < messageSendArguments.length) {
                char[] localName = (OT_LOCAL + i).toCharArray();
                tryStatements.add(gen.localVariable(localName, roleParameters[i - offset], (Expression)new PotentialRoleReceiverExpression(messageSendArguments[i], ROLE_VAR_NAME, gen.typeReference(roleModel.getClassPartBinding()))));
                newArgs[i - offset] = gen.singleNameReference(localName);
                ++i;
            }
            predicateArgs = this.maybeAddResultReference(callinBindingDeclaration, newArgs, resultName, gen);
            Expression[] expressionArray = newArgs;
            newArgs = new Expression[messageSendArguments.length];
            System.arraycopy(expressionArray, 0, newArgs, offset, plainLen);
            i = 0;
            while (i < offset) {
                newArgs[i] = messageSendArguments[i];
                ++i;
            }
            messageSendArguments = newArgs;
        }
        predicateCheck = predGen.createPredicateCheck(callinBindingDeclaration, roleModel.getAst(), receiver, predicateArgs, messageSendArguments, gen);
        if (predicateCheck != null) {
            tryStatements.add(predicateCheck);
        }
        MessageSend roleMessageSend = gen.messageSend(receiver, roleMethodName, messageSendArguments);
        roleMessageSend.isPushedOutRoleMethodCall = true;
        AstGenerator stepOverGen = new AstGenerator(0x7FFFFFFD, 0);
        if (callinBindingDeclaration.isReplaceCallin()) {
            Expression roleMessageSendExpression;
            block27: {
                TypeBinding returnLeaf;
                roleMessageSendExpression = roleMessageSend;
                if (roleMethodBinding.returnType.isArrayType() && (returnLeaf = roleMethodBinding.returnType.leafComponentType()).isRole()) {
                    ReferenceBinding returnEnclosing = returnLeaf.enclosingType();
                    ReferenceBinding currentType = roleModel.getBinding();
                    while ((currentType = currentType.enclosingType()) != null) {
                        if (!TypeBinding.equalsEquals(currentType, returnEnclosing)) {
                            continue;
                        }
                        break block27;
                    }
                    roleMessageSendExpression = new PotentialLowerExpression(roleMessageSend, wrapperReturnType, receiver);
                }
            }
            callinBindingDeclaration.resultVar = gen.localVariable(IOTConstants.OT_RESULT, wrapperReturnType, null);
            callinBindingDeclaration.resultVar.type.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
            tryStatements.add(callinBindingDeclaration.resultVar);
            tryStatements.add(gen.assignment(gen.singleNameReference(IOTConstants.OT_RESULT), roleMessageSendExpression));
            if (isReturnBoxed && !callinBindingDeclaration.isResultMapped) {
                tryStatements.add(CallinImplementor.genResultNotProvidedCheck(this._role.getTeamModel().getBinding().sourceName(), roleTypeName, roleMethodBinding, baseTypeBinding, baseMethodSpec, gen));
            }
            if (callinBindingDeclaration.mappings != null && callinBindingDeclaration.isResultMapped) {
                tryStatements.add(stepOverGen.returnStatement(new PotentialRoleReceiverExpression(callinBindingDeclaration.getResultExpression(baseMethodSpec, isReturnBoxed, stepOverGen), ROLE_VAR_NAME, gen.typeReference(roleModel.getClassPartBinding()))));
            } else {
                tryStatements.add(stepOverGen.returnStatement(stepOverGen.singleNameReference(IOTConstants.OT_RESULT)));
            }
            TryStatement tryFinally = gen.tryFinally(tryStatements.toArray(new Statement[tryStatements.size()]), new Statement[]{resetFlag});
            statements.add(tryFinally);
        } else {
            tryStatements.add(roleMessageSend);
            statements.add(gen.tryFinally(tryStatements.toArray(new Statement[tryStatements.size()]), new Statement[]{resetFlag}));
            statements.add(stepOverGen.returnStatement(null));
        }
        callinWrapperDecl.setStatements(statements.toArray(new Statement[statements.size()]));
        if (callinBindingDeclaration.positions != null) {
            MethodModel model = MethodModel.getModel(callinWrapperDecl);
            model.addAttribute(new CallinParamMappingsAttribute(callinBindingDeclaration));
        }
        return true;
    }

    public static MessageSend setExecutingCallin(RoleModel roleModel, List<Statement> statements) {
        AstGenerator stepOverGen = new AstGenerator(0x7FFFFFFD, 0);
        roleModel.getLineNumberProvider().addLineInfo(roleModel.getBinding(), 65534, -1, false);
        statements.add(stepOverGen.localVariable(OLD_IS_EXECUTING, TypeBinding.BOOLEAN, (Expression)stepOverGen.messageSend(stepOverGen.thisReference(), IOTConstants.SET_EXECUTING_CALLIN, new Expression[]{stepOverGen.booleanLiteral(true)})));
        return stepOverGen.messageSend(stepOverGen.thisReference(), IOTConstants.SET_EXECUTING_CALLIN, new Expression[]{stepOverGen.singleNameReference(OLD_IS_EXECUTING)});
    }

    private Statement createLiftedRoleVar(CallinMappingDeclaration callinBindingDeclaration, RoleModel roleModel, ReferenceBinding baseTypeBinding, char[] otBaseArg, AstGenerator gen) {
        TypeBinding[] typeArguments;
        MessageSend liftCall = Lifting.liftCall(callinBindingDeclaration.scope, ThisReference.implicitThis(), gen.baseNameReference(otBaseArg), baseTypeBinding, roleModel.getBinding(), callinBindingDeclaration.isReplaceCallin());
        ReferenceBinding roleVarType = roleModel.getInterfacePartBinding();
        MethodBinding[] liftMethod = roleVarType.enclosingType().getMethods(liftCall.selector);
        if (liftMethod != null && liftMethod.length > 0 && (typeArguments = liftMethod[0].typeVariables()) != Binding.NO_TYPE_VARIABLES) {
            try {
                roleVarType = Config.getLookupEnvironment().createParameterizedType(roleVarType, typeArguments, null, -1, roleModel.getBinding().enclosingType(), Binding.NO_ANNOTATIONS);
            }
            catch (Config.NotConfiguredException e) {
                e.logWarning("Cannot lookup parameterized type");
            }
        }
        return gen.localVariable(ROLE_VAR_NAME, roleVarType, (Expression)liftCall);
    }

    private Expression[] maybeAddResultReference(CallinMappingDeclaration callinBindingDeclaration, Expression[] messageSendArguments, char[] resultName, AstGenerator gen) {
        Expression[] predicateArgs = null;
        if (callinBindingDeclaration.hasSignature) {
            predicateArgs = messageSendArguments;
            if (resultName != null) {
                int l = messageSendArguments.length;
                predicateArgs = new Expression[l + 1];
                System.arraycopy(messageSendArguments, 0, predicateArgs, 0, l);
                predicateArgs[l] = gen.baseNameReference(resultName);
            }
        }
        return predicateArgs;
    }

    private void packUnmappedArgs(MethodSpec baseMethodSpec, CallinMappingDeclaration callinBindingDeclaration, MethodDeclaration callinWrapper, ArrayList<Statement> statements, AstGenerator gen) {
        int[] unmapped = callinBindingDeclaration.getUnmappedBasePositions(baseMethodSpec);
        if (unmapped.length == 0) {
            return;
        }
        SourcePosition savePos = gen.getSourcePosition();
        gen.setSourcePosition(new StepOverSourcePosition());
        try {
            int unusedIdx;
            int basePos = 1;
            if (callinBindingDeclaration.isReplaceCallin()) {
                basePos += this.getMethodSignatureEnhancer().ENHANCING_ARG_LEN;
                unusedIdx = 0;
                if (baseMethodSpec.isCallin()) {
                    unusedIdx = this.getMethodSignatureEnhancer().ENHANCING_ARG_LEN;
                    if (baseMethodSpec.isStatic()) {
                        unusedIdx += 2;
                    }
                }
            } else {
                statements.add(gen.localVariable(this.getMethodSignatureEnhancer().UNUSED_ARGS, new ArrayQualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1, new long[]{gen.pos, gen.pos, gen.pos}), (Expression)gen.arrayAllocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), unmapped.length, null)));
                unusedIdx = 0;
            }
            int i = 0;
            while (i < unmapped.length) {
                Argument arg = callinWrapper.arguments[basePos + unmapped[i]];
                TypeBinding paramType = arg.type.resolvedType;
                Expression rhs = gen.singleNameReference(arg.name);
                if (paramType.isBaseType()) {
                    rhs = gen.createBoxing(rhs, (BaseTypeBinding)paramType);
                }
                statements.add(gen.assignment(new ArrayReference(gen.singleNameReference(this.getMethodSignatureEnhancer().UNUSED_ARGS), gen.intLiteral(unusedIdx++)), rhs));
                ++i;
            }
        }
        finally {
            gen.setSourcePosition(savePos);
        }
    }

    private Argument[] addResultArgument(Argument[] arguments, CallinMappingDeclaration mapping, MethodSpec baseMethodSpec, AstGenerator gen) {
        Argument[] newArgs = new Argument[arguments.length + 1];
        newArgs[0] = arguments[0];
        TypeBinding baseReturnType = baseMethodSpec.resolvedMethod.returnType;
        if (baseReturnType == TypeBinding.VOID) {
            return arguments;
        }
        ITeamAnchor baseSideAnchor = RoleTypeCreator.getPlayedByAnchor(mapping.scope);
        TypeReference baseTypeRef = this.getAnchoredTypeReference(gen, baseSideAnchor, baseReturnType);
        if (baseTypeRef == null) {
            baseTypeRef = gen.typeReference(baseReturnType);
        }
        newArgs[1] = gen.argument(IOTConstants.RESULT, baseTypeRef);
        newArgs[1].isGenerated = true;
        if (arguments.length > 1) {
            System.arraycopy(arguments, 1, newArgs, 2, arguments.length - 1);
        }
        mapping.resultVar = newArgs[1];
        return newArgs;
    }

    private char[] makeWrapperName(CallinMappingDeclaration callinBindingDeclaration, char[] roleName, char[] roleMethodName, char[] baseMethodName) {
        MethodBinding existingMethod;
        char[] newMethodName;
        char[] currentName = newMethodName = CharOperation.concatWith(new char[][]{CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, roleName), roleMethodName, baseMethodName}, '$');
        int i = 0;
        do {
            if ((existingMethod = this._role.getTeamModel().getBinding().getMethod(callinBindingDeclaration.scope, currentName)) == null) continue;
            currentName = CharOperation.concat(newMethodName, String.valueOf(i++).toCharArray(), '$');
        } while (existingMethod != null);
        return currentName;
    }

    private void setBaseArgBestName(MethodDeclaration newMethod, Argument baseArg) {
        baseArg.bind(newMethod.scope, baseArg.type.resolvedType, false);
        LocalVariableBinding baseArgBinding = newMethod.arguments[0].binding;
        ReferenceBinding roleBinding = this._role.getBinding();
        if (!roleBinding.isHierarchyInconsistent() && !this._role.hasBaseclassProblem()) {
            FieldBinding baseField = TypeAnalyzer.findField(roleBinding, IOTConstants._OT_BASE, false, true, 13);
            if (baseField != null) {
                baseArgBinding.shareBestName(baseField);
            } else if (!roleBinding.isRegularInterface()) {
                throw new InternalCompilerError("Role has no base field: " + new String(roleBinding.readableName()));
            }
        }
    }

    @Override
    TypeBinding[] getImplementationParamters(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperMethod) {
        if (methodMapping.isReplaceCallin()) {
            MethodBinding roleMethod = methodMapping.getImplementationMethodSpec().resolvedMethod;
            TypeBinding[] roleParameters = roleMethod.parameters;
            return roleParameters;
        }
        return super.getImplementationParamters(methodMapping, wrapperMethod);
    }

    @Override
    Expression getArgument(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperDeclaration, TypeBinding[] implParameters, int idx, boolean hasResultArgument, final MethodSpec sourceMethodSpec) {
        int wrapperPrefixLen;
        final MethodSpec implementationMethodSpec = methodMapping.getImplementationMethodSpec();
        Expression mappedArgExpr = null;
        int pos = -1;
        char[] targetArgName = null;
        int generatedArgsLen = methodMapping.isReplaceCallin() ? this.getMethodSignatureEnhancer().ENHANCING_ARG_LEN : 0;
        final int srcIdx = idx - generatedArgsLen;
        int n = wrapperPrefixLen = hasResultArgument ? 2 : 1;
        if (methodMapping.mappings == null || methodMapping.mappings.length == 0 || idx < generatedArgsLen) {
            targetArgName = idx + wrapperPrefixLen < wrapperDeclaration.arguments.length ? wrapperDeclaration.arguments[idx + wrapperPrefixLen].name : CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, "missingArg".toCharArray());
            MethodSpec rmSpec = methodMapping.roleMethodSpec;
            mappedArgExpr = this.genSimpleArgExpr(targetArgName, rmSpec);
            if (idx >= generatedArgsLen) {
                mappedArgExpr.resolve(wrapperDeclaration.scope);
            }
        } else {
            targetArgName = implementationMethodSpec.arguments[srcIdx].name;
            Pair<Expression, Integer> mapper = methodMapping.mappingExpressions[srcIdx];
            mappedArgExpr = (Expression)mapper.first;
            if (mapper.second != null) {
                pos = (Integer)mapper.second;
            }
        }
        if (mappedArgExpr != null) {
            SourceTypeBinding roleType = methodMapping.scope.enclosingSourceType();
            if (idx >= implParameters.length) {
                return mappedArgExpr;
            }
            TypeBinding expectedType = implParameters[idx];
            if (expectedType.isRole() && TypeBinding.notEquals(expectedType.enclosingType(), roleType.enclosingType())) {
                expectedType = TeamModel.strengthenRoleType(roleType, expectedType);
            }
            AstGenerator gen = new AstGenerator(mappedArgExpr.sourceStart, mappedArgExpr.sourceEnd);
            SingleNameReference receiver = null;
            TypeBinding expectedLeaf = expectedType.leafComponentType();
            if (RoleTypeBinding.isRoleWithoutExplicitAnchor(expectedLeaf) && TypeBinding.equalsEquals(roleType.getRealClass(), ((ReferenceBinding)expectedLeaf).enclosingType())) {
                receiver = gen.singleNameReference(ROLE_VAR_NAME);
            }
            if (sourceMethodSpec.hasSignature) {
                if (sourceMethodSpec.argNeedsTranslation(srcIdx)) {
                    mappedArgExpr.tagReportedBaseclassDecapsulation();
                    return Lifting.liftCall(methodMapping.scope, receiver != null ? receiver : gen.qualifiedThisReference(expectedLeaf.enclosingType()), mappedArgExpr, sourceMethodSpec.resolvedParameters()[srcIdx], expectedType, methodMapping.isReplaceCallin());
                }
                if (methodMapping.mappings == null) {
                    return mappedArgExpr;
                }
            }
            Expression liftExpr = gen.potentialLift(receiver, mappedArgExpr, expectedType, methodMapping.isReplaceCallin());
            if (methodMapping.mappings != null && liftExpr instanceof PotentialLiftExpression) {
                final int srcPos = pos;
                ((PotentialLiftExpression)liftExpr).onLiftingRequired(new Runnable(){

                    @Override
                    public void run() {
                        if (srcPos != -1) {
                            sourceMethodSpec.argNeedsTranslation[srcPos] = true;
                        }
                        implementationMethodSpec.argNeedsTranslation[srcIdx] = true;
                    }
                });
            }
            return liftExpr;
        }
        wrapperDeclaration.scope.problemReporter().unmappedParameter(targetArgName, implementationMethodSpec, methodMapping.isCallout());
        return null;
    }

    public static Statement genResultNotProvidedCheck(char[] teamName, char[] roleName, MethodBinding roleMethodBinding, TypeBinding baseTypeBinding, MethodSpec baseMethodSpec, AstGenerator gen) {
        String errMsg = Messages.bind("(team: {0}, role: {1}, method {2})\nBase call to {3}.{4} is missing", new Object[]{new String(teamName), new String(roleName), new String(roleMethodBinding.readableName()), new String(baseTypeBinding.readableName()), new String(baseMethodSpec.resolvedMethod.readableName())});
        return gen.ifStatement(new EqualExpression(gen.singleNameReference(IOTConstants.OT_RESULT), gen.nullLiteral(), 18), gen.block(new Statement[]{gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_RESULT_NOT_PROVIDED), new Expression[]{gen.stringLiteral(errMsg.toCharArray())}))}));
    }

    public static boolean avoidWrapRoleType(BlockScope scope, Expression receiver) {
        AbstractMethodDeclaration refMethod;
        MethodScope methodScope = scope.methodScope();
        return methodScope != null && (refMethod = methodScope.referenceMethod()) != null && refMethod.isMappingWrapper._callin() && receiver instanceof SingleNameReference && CharOperation.equals(((SingleNameReference)receiver).token, CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, IOTConstants.ROLE));
    }

    public static void checkCopyCallinBinding(CallinMethodMappingsAttribute attr, ModelElement element) {
        CallinMethodMappingsAttribute.Mapping[] mappings;
        if (!(element instanceof RoleModel)) {
            return;
        }
        RoleModel roleModel = (RoleModel)element;
        TypeDeclaration teamDecl = roleModel.getTeamModel().getAst();
        if (teamDecl == null) {
            return;
        }
        CallinMethodMappingsAttribute.Mapping[] mappingArray = mappings = attr._mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            CallinMethodMappingsAttribute.Mapping mapping = mappingArray[n2];
            if (mapping.roleMethodIsPrivate()) {
                CallinImplementor.copyCallinTo(mapping, teamDecl);
            }
            ++n2;
        }
    }

    private static void copyCallinTo(CallinMethodMappingsAttribute.Mapping mapping, TypeDeclaration teamDecl) {
        char[][] wrapperNames = mapping.getWrapperNames();
        char[][] wrapperSignatures = mapping.getWrapperSignatures();
        ReferenceBinding teamBinding = mapping._binding._declaringRoleClass.enclosingType();
        if (teamBinding == null || !teamBinding.superclass().isTeam()) {
            return;
        }
        teamBinding = teamBinding.superclass();
        int i = 0;
        while (i < wrapperNames.length) {
            MethodBinding[] methods = teamBinding.getMethods(wrapperNames[i]);
            int j = 0;
            while (j < methods.length) {
                if (CharOperation.equals(wrapperSignatures[i], methods[i].signature())) {
                    CallinImplementor.copyOneCallinTo(methods[i], mapping._binding, teamDecl);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void copyOneCallinTo(MethodBinding method, CallinCalloutBinding callinBinding, TypeDeclaration teamDecl) {
        AstGenerator gen = new AstGenerator(teamDecl.sourceStart, teamDecl.sourceEnd);
        AbstractMethodDeclaration newMethod = AstConverter.createMethod(method, teamDecl.binding, teamDecl.compilationResult, Expression.DecapsulationState.REPORTED, gen, teamDecl.scope);
        MethodBinding origin = method.copyInheritanceSrc != null ? method.copyInheritanceSrc : method;
        AstEdit.addMethod(teamDecl, newMethod, false, false, origin);
        newMethod.binding.copiedInContext = teamDecl.binding.enclosingType();
        MethodModel newModel = MethodModel.getModel(newMethod);
        newModel.addAttribute(CopyInheritanceSourceAttribute.copyInherSrcAttribute(origin, newModel));
        MethodModel.saveReturnType(newMethod.binding, MethodModel.getReturnType(method));
        newMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLIN;
    }
}

