/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.extractcallin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BaseCallMessageSend;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodBindingOperator;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTNodeCreator;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.OTRefactoringMessages;
import org.eclipse.objectteams.otdt.internal.refactoring.util.RefactoringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractCallinRefactoring
extends Refactoring {
    private Map<ICompilationUnit, TextFileChange> fChanges = null;
    private boolean fDeleteBaseMethod;
    private CompilationUnit fRootBase;
    private AST fBaseAST;
    private ICompilationUnit fBaseCUnit;
    private ICompilationUnit fRoleCUnit;
    private CompilationUnit fRootRole;
    private AST fRoleAST;
    private IType fRoleType;
    private TextFileChange fBaseTextFileChange;
    private TextFileChange fRoleTextFileChange;
    private List<ICallinMapping> fBoundCallinMappings;
    private String fRoleMethodName;
    private IType fBaseType;
    private ASTRewrite fBaseRewrite;
    private int fMappingKind;
    private boolean fCopyBaseMethod = true;
    private IMethod fBaseMethod;
    private List<IRoleType> fBoundRoles;
    private IMethod fExtractedBaseMethod;
    private MethodDeclaration fBaseMethodDeclaration;
    private ASTRewrite fRoleRewrite;
    private ImportRewrite fRoleImportRewriter;
    private MethodInvocation fExtractedMethodInvocation;

    public ExtractCallinRefactoring() {
    }

    public ExtractCallinRefactoring(IMethod baseMethod) {
        this();
        this.fBaseMethod = baseMethod;
    }

    public ExtractCallinRefactoring(IMethod baseMethod, IType role, int mappingKind) {
        this(baseMethod);
        this.fRoleType = role;
        this.fMappingKind = mappingKind;
    }

    public List<IRoleType> getCandidateRoles() {
        return this.fBoundRoles;
    }

    public void setRoleType(IType role) {
        this.fRoleType = role;
    }

    public void setCopyBaseMethod(boolean copyBaseMethod) {
        this.fCopyBaseMethod = copyBaseMethod;
    }

    public void setMappingKind(int mappingKind) {
        this.fMappingKind = mappingKind;
    }

    public int getMappingKind() {
        return this.fMappingKind;
    }

    public void setChanges(Map<ICompilationUnit, TextFileChange> fChanges) {
        this.fChanges = fChanges;
    }

    public Map<ICompilationUnit, TextFileChange> getChanges() {
        return this.fChanges;
    }

    public IMethod getBaseMethod() {
        return this.fBaseMethod;
    }

    public boolean isCopyBaseMethod() {
        return this.fCopyBaseMethod;
    }

    public boolean isDeleteBaseMethod() {
        return this.fDeleteBaseMethod;
    }

    public void setDeleteBaseMethod(boolean deleteRoleMethod) {
        this.fDeleteBaseMethod = deleteRoleMethod;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(OTRefactoringMessages.ExtractCallinRefactoring_preconditions_progress, 1);
            if (this.fBaseMethod == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_unspecifiedMethod_error));
            } else if (!this.fBaseMethod.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_inexistentMethod_error, (Object[])new Object[]{this.fBaseMethod.getElementName()})));
            } else if (this.fBaseMethod.isBinary()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_baseMethodBinary_error, (Object[])new Object[]{this.fBaseMethod.getElementName()})));
            } else if (this.fBaseMethod.isReadOnly()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_baseMethodReadOnly_error, (Object[])new Object[]{this.fBaseMethod.getElementName()})));
            } else if (!this.fBaseMethod.getCompilationUnit().isStructureKnown()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_compileErrors_error, (Object[])new Object[]{this.fBaseMethod.getCompilationUnit().getElementName()})));
            } else if (Flags.isAbstract((int)this.fBaseMethod.getFlags())) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_baseMethodAbstract_error, (Object[])new Object[]{this.fBaseMethod.getElementName()})));
            } else if (this.fBaseMethod instanceof AbstractCalloutMapping) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_baseMethodCallout_error, (Object[])new Object[]{this.fBaseMethod.getElementName()})));
            } else {
                status.merge(this.initialize(monitor));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus initialize(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.fRoleMethodName = this.fBaseMethod.getElementName();
            this.fBaseType = this.fBaseMethod.getDeclaringType();
            this.fBaseCUnit = this.fBaseType.getCompilationUnit();
            if (this.fRootBase == null) {
                this.fRootBase = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fBaseCUnit, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
            }
            this.fBaseMethodDeclaration = RefactoringUtil.methodToDeclaration(this.fBaseMethod, this.fRootBase);
            this.fBaseAST = this.fRootBase.getAST();
            this.fBoundRoles = this.findCandidateRoles();
            if (this.fBoundRoles.size() == 0) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_unboundRole_error, (Object[])new Object[]{this.fBaseType.getElementName()})));
            }
        }
        catch (CoreException e) {
            status.merge(this.createCouldNotParseStatus());
        }
        if (status.hasFatalError()) {
            return status;
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.fRoleType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_roleUnspecified_error));
        } else if (!this.fRoleType.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_roleInexistent_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
        } else if (this.fRoleType.isBinary()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_roleBinary_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
        } else if (this.fRoleType.isReadOnly()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_roleReadOnly_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
        }
        this.fRoleCUnit = this.fRoleType.getCompilationUnit();
        if (this.fRootRole == null) {
            this.fRootRole = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fRoleCUnit, (boolean)true, (IProgressMonitor)new SubProgressMonitor(pm, 99));
        }
        this.fRoleImportRewriter = StubUtility.createImportRewrite((CompilationUnit)this.fRootRole, (boolean)true);
        this.fRoleAST = this.fRootRole.getAST();
        if (this.fDeleteBaseMethod) {
            // empty if block
        }
        status.merge(this.checkRoleMethodName());
        status.merge(this.checkCallinKind());
        return status;
    }

    private RefactoringStatus checkCallinKind() throws JavaModelException {
        if (this.fMappingKind == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_callinKindUnspecified_error);
        }
        if (this.fMappingKind == 1 && !this.isExtractBeforeAvailable()) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_callToExtractNotFound_Before_error);
        }
        if (this.fMappingKind == 2 && !this.isExtractAfterAvailable()) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_callToExtractNotFound_After_error);
        }
        if (this.fMappingKind != 3 && this.fMappingKind != 1 && this.fMappingKind != 2) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_callinKindInvalid_error);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.extractCallin();
        CompositeChange change = new CompositeChange(this.getName(), (Change[])new TextFileChange[]{this.fBaseTextFileChange, this.fRoleTextFileChange});
        return change;
    }

    public String getName() {
        return OTRefactoringMessages.ExtractCallin_extractCallin_name;
    }

    private void extractCallin() throws CoreException {
        this.fBaseRewrite = ASTRewrite.create((AST)this.fBaseAST);
        this.fRoleRewrite = ASTRewrite.create((AST)this.fRoleAST);
        MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(this.fBaseMethod, this.fRootBase);
        List statements = baseMethodDeclaration.getBody().statements();
        this.fExtractedBaseMethod = null;
        switch (this.fMappingKind) {
            case 1: {
                this.fExtractedMethodInvocation = (MethodInvocation)((ExpressionStatement)statements.get(0)).getExpression();
                IMethodBinding methodBinding = this.fExtractedMethodInvocation.resolveMethodBinding();
                this.fExtractedBaseMethod = (IMethod)methodBinding.getJavaElement();
                this.fBaseRewrite.getListRewrite((ASTNode)baseMethodDeclaration.getBody(), Block.STATEMENTS_PROPERTY).remove((ASTNode)statements.get(0), null);
                break;
            }
            case 2: {
                this.fExtractedMethodInvocation = (MethodInvocation)((ExpressionStatement)statements.get(statements.size() - 1)).getExpression();
                IMethodBinding methodBinding = this.fExtractedMethodInvocation.resolveMethodBinding();
                this.fExtractedBaseMethod = (IMethod)methodBinding.getJavaElement();
                this.fBaseRewrite.getListRewrite((ASTNode)baseMethodDeclaration.getBody(), Block.STATEMENTS_PROPERTY).remove((ASTNode)statements.get(statements.size() - 1), null);
                break;
            }
            case 3: {
                this.fExtractedBaseMethod = this.fBaseMethod;
                break;
            }
        }
        MethodDeclaration extractedCallin = this.extractCallinMethod();
        this.insertMethodIntoRole(extractedCallin);
        CallinMappingDeclaration callinMapping = this.createMethodMapping();
        this.appendMethodMappingToRole(callinMapping);
        if (this.fDeleteBaseMethod && this.fMappingKind != 3) {
            MethodDeclaration extractedBaseMethodDecl = RefactoringUtil.methodToDeclaration(this.fExtractedBaseMethod, this.fRootBase);
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.typeToDeclaration(this.fBaseType, this.fRootBase);
            ChildListPropertyDescriptor descriptor = this.typeToBodyDeclarationProperty(this.fBaseType, this.fRootBase);
            this.fBaseRewrite.getListRewrite((ASTNode)declaration, descriptor).remove((ASTNode)extractedBaseMethodDecl, null);
        }
        HashSet staticImports = new HashSet();
        HashSet imports = new HashSet();
        MethodDeclaration extractedCallinMethodDeclaration = RefactoringUtil.methodToDeclaration(this.fExtractedBaseMethod, this.fRootBase);
        ImportRewriteUtil.collectImports((IJavaProject)this.fRoleType.getJavaProject(), (ASTNode)extractedCallinMethodDeclaration, imports, staticImports, (boolean)false);
        if (this.fMappingKind != 3) {
            ImportRewriteUtil.collectImports((IJavaProject)this.fRoleType.getJavaProject(), (ASTNode)this.fExtractedMethodInvocation, imports, staticImports, (boolean)false);
        }
        for (ITypeBinding typeBinding : imports) {
            this.fRoleImportRewriter.addImport(typeBinding);
        }
        for (IBinding binding : staticImports) {
            this.fRoleImportRewriter.addStaticImport(binding);
        }
        MultiTextEdit baseMultiEdit = new MultiTextEdit();
        baseMultiEdit.addChild(this.fBaseRewrite.rewriteAST());
        this.fBaseTextFileChange = new TextFileChange(this.fBaseCUnit.getElementName(), (IFile)this.fBaseCUnit.getResource());
        this.fBaseTextFileChange.setTextType("java");
        this.fBaseTextFileChange.setEdit((TextEdit)baseMultiEdit);
        MultiTextEdit roleMultiEdit = new MultiTextEdit();
        roleMultiEdit.addChild(this.fRoleRewrite.rewriteAST());
        this.fRoleTextFileChange = new TextFileChange(this.fRoleCUnit.getElementName(), (IFile)this.fRoleCUnit.getResource());
        this.fRoleTextFileChange.setTextType("java");
        this.fRoleTextFileChange.setEdit((TextEdit)roleMultiEdit);
        if (this.fRoleImportRewriter.hasRecordedChanges()) {
            TextEdit edit = this.fRoleImportRewriter.rewriteImports(null);
            roleMultiEdit.addChild(edit);
            this.fRoleTextFileChange.addTextEditGroup(new TextEditGroup(OTRefactoringMessages.OTRefactoring_organizeImports_editName, new TextEdit[]{edit}));
        }
    }

    private MethodDeclaration extractCallinMethod() throws JavaModelException {
        MethodDeclaration extractedCallinMethodDeclaration = RefactoringUtil.methodToDeclaration(this.fExtractedBaseMethod, this.fRootBase);
        MethodDeclaration copyOfExtractedCallin = (MethodDeclaration)ASTNode.copySubtree((AST)this.fRoleAST, (ASTNode)extractedCallinMethodDeclaration);
        copyOfExtractedCallin.getName().setIdentifier(this.fRoleMethodName);
        if (this.fMappingKind == 3) {
            this.addCallinModifier(this.fRoleRewrite, copyOfExtractedCallin);
            if (!this.fCopyBaseMethod) {
                Block body = this.fRoleAST.newBlock();
                BaseCallMessageSend baseCall = this.createBaseMethodInvocation(this.fRoleMethodName, this.fExtractedBaseMethod, this.fBaseMethod);
                body.statements().add(this.fRoleAST.newExpressionStatement((Expression)baseCall));
                copyOfExtractedCallin.setBody(body);
            }
        } else if (!Flags.isPrivate((int)this.fExtractedBaseMethod.getFlags())) {
            this.changeToPrivateVisibility(this.fRoleRewrite, copyOfExtractedCallin);
        }
        return copyOfExtractedCallin;
    }

    private BaseCallMessageSend createBaseMethodInvocation(String roleMethodName, IMethod roleMethod, IMethod baseMethod) throws JavaModelException {
        BaseCallMessageSend baseCall = this.fRoleAST.newBaseCallMessageSend();
        baseCall.setName(this.fRoleAST.newSimpleName(roleMethodName));
        this.copyInvocationParameters(baseCall, roleMethod);
        int roleMethodParameterLength = roleMethod.getParameterNames().length;
        int baseMethodParameterLength = baseMethod.getParameterNames().length;
        if (roleMethodParameterLength < baseMethodParameterLength) {
            this.appendInvocationParameters(baseCall, baseMethod, baseMethodParameterLength - roleMethodParameterLength);
        }
        return baseCall;
    }

    static MethodSpec createMethodSpec(AST ast, ImportRewrite imports, IMethodBinding methodBinding, String[] argNames) {
        ArrayList<SingleVariableDeclaration> args = new ArrayList<SingleVariableDeclaration>();
        int i = 0;
        while (i < methodBinding.getParameterTypes().length) {
            ITypeBinding paramType = methodBinding.getParameterTypes()[i];
            args.add(ASTNodeCreator.createArgument((AST)ast, (int)0, (Type)imports.addImport(paramType, ast), (String)argNames[i], null));
            ++i;
        }
        ITypeBinding providedReturnType = methodBinding.getReturnType();
        Type returnType = imports.addImport(providedReturnType, ast);
        return ASTNodeCreator.createMethodSpec((AST)ast, (String)methodBinding.getName(), (Type)returnType, args, (boolean)true);
    }

    private void appendMethodMappingToRole(CallinMappingDeclaration callinMapping) throws JavaModelException {
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.typeToDeclaration(this.fRoleType, this.fRootRole);
        ChildListPropertyDescriptor descriptor = this.typeToBodyDeclarationProperty(this.fRoleType, this.fRootRole);
        this.fRoleRewrite.getListRewrite((ASTNode)declaration, descriptor).insertLast((ASTNode)callinMapping, null);
    }

    private CallinMappingDeclaration createMethodMapping() throws JavaModelException {
        CallinMappingDeclaration mapping = this.fRoleAST.newCallinMappingDeclaration();
        mapping.setBindingOperator(this.createCallinBindingOp());
        IMethodBinding roleMethodBinding = RefactoringUtil.methodToDeclaration(this.fExtractedBaseMethod, this.fRootBase).resolveBinding();
        MethodSpec roleMethodSpec = ExtractCallinRefactoring.createMethodSpec(this.fRoleAST, this.fRoleImportRewriter, roleMethodBinding, this.fExtractedBaseMethod.getParameterNames());
        roleMethodSpec.setName(this.fRoleAST.newSimpleName(this.fRoleMethodName));
        mapping.setRoleMappingElement((MethodMappingElement)roleMethodSpec);
        IMethodBinding baseMethodBinding = RefactoringUtil.methodToDeclaration(this.fBaseMethod, this.fRootBase).resolveBinding();
        MethodSpec baseMethodSpec = ExtractCallinRefactoring.createMethodSpec(this.fRoleAST, this.fRoleImportRewriter, baseMethodBinding, this.fBaseMethod.getParameterNames());
        mapping.getBaseMappingElements().add(baseMethodSpec);
        if (this.needsParameterMapping()) {
            List parameters = roleMethodSpec.parameters();
            int i = 0;
            while (i < parameters.size()) {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)parameters.get(i);
                ParameterMapping parameterMapping = this.fRoleAST.newParameterMapping();
                Expression expr = (Expression)ASTNode.copySubtree((AST)this.fRoleAST, (ASTNode)((Expression)this.fExtractedMethodInvocation.arguments().get(i)));
                parameterMapping.setIdentifier(this.fRoleAST.newSimpleName(varDecl.getName().getIdentifier()));
                parameterMapping.setExpression(expr);
                parameterMapping.setDirection("<-");
                mapping.getParameterMappings().add(parameterMapping);
                ++i;
            }
        }
        return mapping;
    }

    private boolean needsParameterMapping() throws JavaModelException {
        if (this.fMappingKind == 3) {
            return false;
        }
        if (this.fExtractedBaseMethod.getParameterNames().length == 0) {
            return false;
        }
        if (this.fExtractedMethodInvocation.arguments().size() > this.fBaseMethod.getParameterNames().length) {
            return true;
        }
        int i = 0;
        while (i < this.fExtractedMethodInvocation.arguments().size()) {
            Expression expression = (Expression)this.fExtractedMethodInvocation.arguments().get(i);
            if (expression instanceof SimpleName) {
                if (!((SimpleName)expression).getIdentifier().equals(this.fBaseMethod.getParameterNames()[i])) {
                    return true;
                }
            } else {
                return true;
            }
            ++i;
        }
        return false;
    }

    private MethodBindingOperator createCallinBindingOp() {
        Modifier.ModifierKeyword keyword;
        switch (this.fMappingKind) {
            case 1: {
                keyword = Modifier.ModifierKeyword.BEFORE_KEYWORD;
                break;
            }
            case 2: {
                keyword = Modifier.ModifierKeyword.AFTER_KEYWORD;
                break;
            }
            case 3: {
                keyword = Modifier.ModifierKeyword.REPLACE_KEYWORD;
                break;
            }
            default: {
                return null;
            }
        }
        return this.fRoleAST.newMethodBindingOperator(keyword, 3);
    }

    private void addCallinModifier(ASTRewrite astRewrite, MethodDeclaration methodDeclaration) {
        Modifier callinModifier = this.fRoleAST.newModifier(Modifier.ModifierKeyword.CALLIN_KEYWORD);
        astRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)callinModifier, null);
        List modifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            Modifier modifier;
            if (!(extendedModifier instanceof Modifier) || !Modifier.isPublic((int)(modifier = (Modifier)extendedModifier).getKeyword().toFlagValue()) && !Modifier.isProtected((int)modifier.getKeyword().toFlagValue()) && !Modifier.isPrivate((int)modifier.getKeyword().toFlagValue())) continue;
            astRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY).remove((ASTNode)modifier, null);
            break;
        }
    }

    private void insertMethodIntoRole(MethodDeclaration methodDeclaration) throws JavaModelException {
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.typeToDeclaration(this.fRoleType, this.fRootRole);
        ChildListPropertyDescriptor descriptor = this.typeToBodyDeclarationProperty(this.fRoleType, this.fRootRole);
        this.fRoleRewrite.getListRewrite((ASTNode)declaration, descriptor).insertLast((ASTNode)methodDeclaration, null);
    }

    private void changeToPrivateVisibility(ASTRewrite astRewrite, MethodDeclaration methodDeclaration) {
        Modifier privateVisibility = methodDeclaration.getAST().newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        List modifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!(extendedModifier instanceof Modifier)) continue;
            Modifier modifier = (Modifier)extendedModifier;
            if (Modifier.isPublic((int)modifier.getKeyword().toFlagValue())) {
                astRewrite.replace((ASTNode)modifier, (ASTNode)privateVisibility, null);
                return;
            }
            if (Modifier.isProtected((int)modifier.getKeyword().toFlagValue())) {
                astRewrite.replace((ASTNode)modifier, (ASTNode)privateVisibility, null);
                return;
            }
            if (!Modifier.isPrivate((int)modifier.getKeyword().toFlagValue())) continue;
            return;
        }
        astRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)privateVisibility, null);
    }

    private void copyInvocationParameters(BaseCallMessageSend baseCall, IMethod method) throws JavaModelException {
        String[] names;
        String[] stringArray = names = method.getParameterNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            baseCall.getArguments().add(this.fRoleAST.newSimpleName(element));
            ++n2;
        }
    }

    private void appendInvocationParameters(BaseCallMessageSend baseCall, IMethod method, int offset) throws JavaModelException {
        String[] names = method.getParameterNames();
        int i = offset;
        while (i < names.length) {
            String name = names[i];
            baseCall.getArguments().add(this.fBaseAST.newSimpleName(name));
            ++i;
        }
    }

    private ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    private ASTNode typeToDeclaration(IType type, CompilationUnit node) throws JavaModelException {
        Name result = (Name)NodeFinder.perform((ASTNode)node, (ISourceRange)type.getNameRange());
        if (type.isAnonymous()) {
            return this.getParent((ASTNode)result, AnonymousClassDeclaration.class);
        }
        return this.getParent((ASTNode)result, AbstractTypeDeclaration.class);
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType type, CompilationUnit node) throws JavaModelException {
        ASTNode result = this.typeToDeclaration(type, node);
        if (result instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)result).getBodyDeclarationsProperty();
        }
        if (result instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private ArrayList<IRoleType> findCandidateRoles() throws CoreException {
        ArrayList<IRoleType> boundRoles = RefactoringUtil.getAllRolesForBase(this.fBaseType);
        ArrayList<IRoleType> rolesToRemove = new ArrayList<IRoleType>();
        for (IRoleType boundRole : boundRoles) {
            if (boundRole.exists() && !boundRole.isReadOnly() && !boundRole.isBinary()) continue;
            rolesToRemove.add(boundRole);
        }
        boundRoles.removeAll(rolesToRemove);
        return boundRoles;
    }

    public IMethod[] getBoundBaseMethods() throws JavaModelException {
        ArrayList<IMethod> boundBaseMethods = new ArrayList<IMethod>();
        for (ICallinMapping mapping : this.fBoundCallinMappings) {
            boundBaseMethods.addAll(Arrays.asList(mapping.getBoundBaseMethods()));
        }
        return boundBaseMethods.toArray(new IMethod[boundBaseMethods.size()]);
    }

    public List<ICallinMapping> getBoundCallinMappings() {
        return this.fBoundCallinMappings;
    }

    public void setRoleMethodName(String name) {
        this.fRoleMethodName = name;
    }

    private RefactoringStatus checkIfMethodExists() {
        try {
            if (this.methodWithNameExists(this.fRoleType, this.fRoleMethodName)) {
                return RefactoringStatus.createErrorStatus((String)NLS.bind((String)OTRefactoringMessages.ExtractCallinRefactoring_methodNameClash, (Object)this.fRoleMethodName));
            }
        }
        catch (JavaModelException exception) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_bindingSearchFailed_error);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus createCouldNotParseStatus() {
        return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_unparseableType_error);
    }

    private boolean methodWithNameExists(IType type, String methodName) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isExtractBeforeAvailable() {
        List statements = this.fBaseMethodDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return false;
        }
        if (statements.get(0) instanceof ExpressionStatement && ((ExpressionStatement)statements.get(0)).getExpression() instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)((ExpressionStatement)statements.get(0)).getExpression();
            Expression receiver = invocation.getExpression();
            boolean isSelfcall = false;
            if (receiver == null) {
                isSelfcall = true;
            } else if (receiver instanceof ThisExpression) {
                boolean bl = isSelfcall = ((ThisExpression)receiver).getQualifier() == null;
            }
            if (isSelfcall) {
                return !((IMethod)invocation.resolveMethodBinding().getJavaElement()).getDeclaringType().isBinary();
            }
        }
        return false;
    }

    public boolean isExtractAfterAvailable() {
        MethodInvocation invocation;
        List statements = this.fBaseMethodDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return false;
        }
        return statements.get(statements.size() - 1) instanceof ExpressionStatement && ((ExpressionStatement)statements.get(statements.size() - 1)).getExpression() instanceof MethodInvocation && ((IMethod)(invocation = (MethodInvocation)((ExpressionStatement)statements.get(statements.size() - 1)).getExpression()).resolveMethodBinding().getJavaElement()).getDeclaringType().equals(this.fBaseType);
    }

    RefactoringStatus checkRoleMethodName() {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.checkIfMethodExists());
        status.merge(this.checkMethodName(this.fRoleMethodName));
        return status;
    }

    private RefactoringStatus checkMethodName(String name) {
        String complianceLevel;
        RefactoringStatus result = new RefactoringStatus();
        if (name == null) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_roleMethodUnspecified_error);
        }
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.ExtractCallinRefactoring_roleMethodNameEmpty_error);
        }
        IJavaProject javaProject = this.fRoleType.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        IStatus status = JavaConventions.validateMethodName((String)name, (String)sourceLevel, (String)(complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)));
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }
}

