/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StatementWithFinallyBlock;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.InsideStatementWithFinallyBlockFlowContext;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TSuperMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public StatementWithFinallyBlock[] statementsWithFinallyBlock;
    public LocalVariableBinding saveValueVariable;
    public int initStateIndex = -1;
    private final boolean implicitReturn;
    public boolean isGenerated;

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    public ReturnStatement(Expression expression, int sourceStart, int sourceEnd) {
        this(expression, sourceStart, sourceEnd, false);
    }

    public ReturnStatement(Expression expression, int sourceStart, int sourceEnd, boolean implicitReturn) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.expression = expression;
        this.implicitReturn = implicitReturn;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expression instanceof FunctionalExpression && (this.expression.resolvedType == null || !this.expression.resolvedType.isValidBinding())) {
            flowContext.recordAbruptExit();
            return FlowInfo.DEAD_END;
        }
        MethodScope methodScope = currentScope.methodScope();
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            this.expression.checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
            if (flowInfo.reachMode() == 0) {
                CompilerOptions compilerOptions = currentScope.compilerOptions();
                if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
                    this.checkAgainstNullAnnotation(currentScope, flowContext, flowInfo, this.expression);
                }
                if (compilerOptions.analyseResourceLeaks) {
                    long owningTagBits = methodScope.referenceMethodBinding().tagBits & 0x600000000000000L;
                    flowInfo = ReturnStatement.anylizeCloseableReturnExpression(this.expression, currentScope, owningTagBits, flowContext, flowInfo);
                }
            }
        }
        this.initStateIndex = methodScope.recordInitializationStates(flowInfo);
        FlowContext traversedContext = flowContext;
        int stmtCount = 0;
        boolean saveValueNeeded = false;
        boolean hasValueToSave = this.needValueStore();
        boolean noAutoCloseables = true;
        do {
            StatementWithFinallyBlock stmt;
            if ((stmt = traversedContext.statementWithFinallyBlock()) != null) {
                if (this.statementsWithFinallyBlock == null) {
                    this.statementsWithFinallyBlock = new StatementWithFinallyBlock[5];
                }
                if (stmtCount == this.statementsWithFinallyBlock.length) {
                    this.statementsWithFinallyBlock = new StatementWithFinallyBlock[stmtCount * 2];
                    System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, stmtCount);
                }
                this.statementsWithFinallyBlock[stmtCount++] = stmt;
                if (stmt.isFinallyBlockEscaping()) {
                    saveValueNeeded = false;
                    this.bits |= 0x20000000;
                    break;
                }
                if (stmt instanceof TryStatement && ((TryStatement)stmt).resources.length > 0) {
                    noAutoCloseables = false;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext instanceof InsideStatementWithFinallyBlockFlowContext) {
                ASTNode node = traversedContext.associatedNode;
                if (node instanceof SynchronizedStatement) {
                    this.bits |= 0x40000000;
                    continue;
                }
                if (!(node instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.finallyBlockInits);
                if (!hasValueToSave) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                saveValueNeeded = true;
                this.initStateIndex = methodScope.recordInitializationStates(flowInfo);
                continue;
            }
            if (traversedContext instanceof InitializationFlowContext) {
                currentScope.problemReporter().cannotReturnInInitializer(this);
                return FlowInfo.DEAD_END;
            }
            if (!(traversedContext.associatedNode instanceof SwitchExpression)) continue;
            currentScope.problemReporter().returnOutOfSwitchExpression(this);
            return FlowInfo.DEAD_END;
        } while ((traversedContext = traversedContext.getLocalParent()) != null);
        if (this.statementsWithFinallyBlock != null && stmtCount != this.statementsWithFinallyBlock.length) {
            this.statementsWithFinallyBlock = new StatementWithFinallyBlock[stmtCount];
            System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, stmtCount);
        }
        if (saveValueNeeded) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if ((this.bits & 0x40000000) == 0 && this.expression != null && TypeBinding.equalsEquals(this.expression.resolvedType, TypeBinding.BOOLEAN) && noAutoCloseables) {
                this.expression.bits |= 0x10;
            }
        }
        currentScope.checkUnclosedCloseables(flowInfo, flowContext, this, currentScope);
        flowContext.recordAbruptExit();
        flowContext.expireNullCheckedFieldInfo();
        return FlowInfo.DEAD_END;
    }

    public static FlowInfo anylizeCloseableReturnExpression(Expression returnExpression, BlockScope scope, long owningTagBits, FlowContext flowContext, FlowInfo flowInfo) {
        boolean returnWithoutOwning = false;
        boolean useOwningAnnotations = scope.compilerOptions().isAnnotationBasedResourceAnalysisEnabled;
        FakedTrackingVariable trackingVariable = FakedTrackingVariable.getCloseTrackingVariable(returnExpression, flowInfo, flowContext, useOwningAnnotations);
        if (trackingVariable != null) {
            boolean delegatingToCaller = true;
            if (useOwningAnnotations) {
                returnWithoutOwning = owningTagBits == 0L;
                boolean bl = delegatingToCaller = (owningTagBits & 0x400000000000000L) == 0L;
            }
            if (scope.methodScope() != trackingVariable.methodScope && delegatingToCaller) {
                trackingVariable.markClosedInNestedMethod();
            }
            if (delegatingToCaller) {
                flowInfo = FakedTrackingVariable.markPassedToOutside(scope, returnExpression, flowInfo, flowContext, true);
            }
        }
        FakedTrackingVariable.cleanUpUnassigned(scope, returnExpression, flowInfo, returnWithoutOwning);
        return flowInfo;
    }

    @Override
    public boolean doesNotCompleteNormally() {
        return true;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        boolean alreadyGeneratedExpression = false;
        if (this.needValueStore()) {
            alreadyGeneratedExpression = true;
            this.expression.generateCode(currentScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(currentScope, codeStream);
        }
        if (this.statementsWithFinallyBlock != null) {
            int i = 0;
            int max = this.statementsWithFinallyBlock.length;
            while (i < max) {
                StatementWithFinallyBlock stmt = this.statementsWithFinallyBlock[i];
                boolean didEscape = stmt.generateFinallyBlock(currentScope, codeStream, this.initStateIndex);
                if (didEscape) {
                    codeStream.recordPositionsFrom(pc, this.sourceStart);
                    StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, i, codeStream);
                    return;
                }
                ++i;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && !alreadyGeneratedExpression) {
            this.expression.generateCode(currentScope, codeStream, true);
            this.generateStoreSaveValueIfNecessary(currentScope, codeStream);
        }
        this.generateReturnBytecode(codeStream);
        if (this.saveValueVariable != null) {
            codeStream.removeVariable(this.saveValueVariable);
        }
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.initStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, -1, codeStream);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        codeStream.generateReturnBytecode(this.expression);
    }

    public void generateStoreSaveValueIfNecessary(Scope scope, CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
            codeStream.addVariable(this.saveValueVariable);
        }
    }

    private boolean needValueStore() {
        return this.expression != null && (this.expression.constant == Constant.NotAConstant || (this.expression.implicitConversion & 0x200) != 0) && !(this.expression instanceof NullLiteral);
    }

    public boolean needValue() {
        return this.saveValueVariable != null || (this.bits & 0x40000000) != 0 || (this.bits & 0x20000000) == 0;
    }

    public void prepareSaveValueLocation(TryStatement targetTryStatement) {
        this.saveValueVariable = targetTryStatement.secretReturnValue;
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        ReturnStatement.printIndent(tab, output).append("return");
        if (this.expression != null) {
            output.append(' ');
            this.expression.printExpression(0, output);
        }
        return output.append(';');
    }

    @Override
    public void resolve(BlockScope scope) {
        TypeBinding methodType;
        LambdaExpression lambda;
        MethodScope methodScope = scope.methodScope();
        MethodBinding methodBinding = null;
        LambdaExpression lambdaExpression = lambda = methodScope.referenceContext instanceof LambdaExpression ? (LambdaExpression)methodScope.referenceContext : null;
        Object object = lambda != null ? lambda.expectedResultType() : (methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (methodType = TypeBinding.VOID));
        if (methodBinding != null && methodBinding.isCompactConstructor()) {
            scope.problemReporter().recordCompactConstructorHasReturnStatement(this);
        }
        if (lambda == null && scope.isInsideEarlyConstructionContext(null, false)) {
            scope.problemReporter().errorReturnInEarlyConstructionContext(this);
        }
        if (this.expression != null) {
            AbstractMethodDeclaration referenceMethod;
            this.expression.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
            this.expression.setExpectedType(methodType);
            if (lambda != null && lambda.argumentsTypeElided() && this.expression instanceof CastExpression) {
                this.expression.bits |= 0x20;
            }
            if ((referenceMethod = methodScope.referenceMethod()) != null && referenceMethod.isCallin() && this.expression instanceof TSuperMessageSend) {
                ((TSuperMessageSend)this.expression).isReturnFromCallinMethod = true;
            }
        }
        if (methodType == TypeBinding.VOID) {
            if (this.expression == null) {
                if (lambda != null) {
                    lambda.returnsExpression(null, TypeBinding.VOID);
                }
                return;
            }
            TypeBinding expressionType = this.expression.resolveType(scope);
            if (lambda != null) {
                lambda.returnsExpression(this.expression, expressionType);
            }
            if (this.implicitReturn && (expressionType == TypeBinding.VOID || this.expression.statementExpression())) {
                return;
            }
            if (expressionType != null) {
                scope.problemReporter().attemptToReturnNonVoidExpression(this, expressionType);
            }
            return;
        }
        if (this.expression == null) {
            if (lambda != null) {
                lambda.returnsExpression(null, methodType);
            }
            if (methodType != null) {
                scope.problemReporter().shouldReturn(methodType, this);
            }
            return;
        }
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (lambda != null) {
            lambda.returnsExpression(this.expression, expressionType);
        }
        if (expressionType == null) {
            return;
        }
        if (expressionType == TypeBinding.VOID) {
            scope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (methodType == null) {
            return;
        }
        if (lambda != null && methodType.isProperType(true) && lambda.updateLocalTypes()) {
            methodType = lambda.expectedResultType();
        }
        if (TypeBinding.notEquals(methodType, expressionType)) {
            scope.compilationUnitScope().recordTypeConversion(methodType, expressionType);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(expressionType, methodType) || expressionType.isCompatibleWith(methodType, scope)) {
            this.expression.computeConversion(scope, methodType, expressionType);
            if (expressionType.needsUncheckedConversion(methodType)) {
                scope.problemReporter().unsafeTypeConversion(this.expression, expressionType, methodType);
            }
            if (this.expression instanceof CastExpression) {
                if ((this.expression.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(scope, methodType, (CastExpression)this.expression);
                } else if (lambda != null && lambda.argumentsTypeElided() && (this.expression.bits & 0x4000) != 0 && TypeBinding.equalsEquals(((CastExpression)this.expression).expression.resolvedType, methodType)) {
                    scope.problemReporter().unnecessaryCast((CastExpression)this.expression);
                }
            }
            return;
        }
        if (this.isBoxingCompatible(expressionType, methodType, this.expression, scope)) {
            TypeBinding realReturn;
            MethodBinding method;
            if (methodScope.referenceContext instanceof AbstractMethodDeclaration && (method = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null && method.isCallin() && !expressionType.isCompatibleWith(realReturn = MethodModel.getReturnType(method))) {
                scope.problemReporter().typeMismatchError(expressionType, realReturn, this.expression, null);
                return;
            }
            this.expression.computeConversion(scope, methodType, expressionType);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(scope, methodType, (CastExpression)this.expression);
            }
            return;
        }
        if ((methodType.tagBits & 0x80L) == 0L) {
            scope.problemReporter().typeMismatchError(expressionType, methodType, this.expression, (ASTNode)this);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expression != null) {
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

