/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.complete;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.codeassist.complete.InvalidCursorLocation;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;

public class CompletionScanner
extends Scanner {
    public char[] completionIdentifier;
    public int cursorLocation;
    public int endOfEmptyToken = -1;
    public int completedIdentifierStart = 0;
    public int completedIdentifierEnd = -1;
    public int unicodeCharSize;
    public static final char[] EmptyCompletionIdentifier = new char[0];

    public CompletionScanner(long sourceLevel) {
        this(sourceLevel, false);
    }

    public CompletionScanner(long sourceLevel, boolean previewEnabled) {
        super(false, false, false, sourceLevel, null, null, true, previewEnabled);
    }

    protected boolean isAtAssistIdentifier() {
        if (this.cursorLocation < this.startPosition && this.currentPosition == this.startPosition) {
            return true;
        }
        return this.cursorLocation + 1 >= this.startPosition && this.cursorLocation < this.currentPosition;
    }

    public char[] getCurrentIdentifierSource() {
        if (this.completionIdentifier == null) {
            if (this.cursorLocation < this.startPosition && this.currentPosition == this.startPosition) {
                this.completedIdentifierStart = this.startPosition;
                this.completedIdentifierEnd = this.completedIdentifierStart - 1;
                this.completionIdentifier = EmptyCompletionIdentifier;
                return EmptyCompletionIdentifier;
            }
            if (this.cursorLocation + 1 >= this.startPosition && this.cursorLocation < this.currentPosition) {
                this.completedIdentifierStart = this.startPosition;
                this.completedIdentifierEnd = this.currentPosition - 1;
                if (this.withoutUnicodePtr != 0) {
                    int length = this.cursorLocation + 1 - this.startPosition - this.unicodeCharSize;
                    this.completionIdentifier = new char[length];
                    System.arraycopy(this.withoutUnicodeBuffer, 1, this.completionIdentifier, 0, length);
                } else {
                    int length = this.cursorLocation + 1 - this.startPosition;
                    this.completionIdentifier = new char[length];
                    System.arraycopy(this.source, this.startPosition, this.completionIdentifier, 0, length);
                }
                return this.completionIdentifier;
            }
        }
        return super.getCurrentIdentifierSource();
    }

    public char[] getCurrentTokenSourceString() {
        if (this.completionIdentifier == null && this.cursorLocation + 1 >= this.startPosition && this.cursorLocation < this.currentPosition) {
            this.completedIdentifierStart = this.startPosition;
            this.completedIdentifierEnd = this.currentPosition - 1;
            if (this.withoutUnicodePtr != 0) {
                int length = this.cursorLocation - this.startPosition - this.unicodeCharSize;
                this.completionIdentifier = new char[length];
                System.arraycopy(this.withoutUnicodeBuffer, 2, this.completionIdentifier, 0, length);
            } else {
                int length = this.cursorLocation - this.startPosition;
                this.completionIdentifier = new char[length];
                System.arraycopy(this.source, this.startPosition + 1, this.completionIdentifier, 0, length);
            }
            return this.completionIdentifier;
        }
        return super.getCurrentTokenSourceString();
    }

    /*
     * Unable to fully structure code
     */
    protected TerminalToken getNextToken0() throws InvalidInputException {
        if (this._dotSeen > 0) {
            --this._dotSeen;
        }
        this.wasAcr = false;
        this.unicodeCharSize = 0;
        if (this.diet) {
            this.jumpOverMethodBody();
            this.diet = false;
            return this.currentPosition > this.eofPosition ? TerminalToken.TokenNameEOF : TerminalToken.TokenNameRBRACE;
        }
        whiteStart = 0;
        try {
            block46: while (true) lbl-1000:
            // 4 sources

            {
                this.withoutUnicodePtr = 0;
                whiteStart = ++this.currentPosition;
                hasWhiteSpaces = false;
                offset = 0;
                do {
                    block165: {
                        this.startPosition = this.currentPosition;
                        checkIfUnicode = false;
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                        }
                        catch (IndexOutOfBoundsException v0) {
                            if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                                --this.currentPosition;
                                this.startPosition = whiteStart;
                                return TerminalToken.TokenNameWHITESPACE;
                            }
                            if (this.currentPosition <= this.eofPosition) break block165;
                            if (this.completionIdentifier == null && this.startPosition == this.cursorLocation + 1) {
                                this.currentPosition = this.startPosition;
                                return TerminalToken.TokenNameIdentifier;
                            }
                            return TerminalToken.TokenNameEOF;
                        }
                    }
                    if (checkIfUnicode) {
                        isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                        offset = 6;
                    } else {
                        offset = 1;
                        if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                            this.pushLineSeparator();
                        }
                        v1 = isWhiteSpace = this.currentCharacter == ' ' || CharOperation.isWhitespace((char)this.currentCharacter) != false;
                    }
                    if (isWhiteSpace) {
                        hasWhiteSpaces = true;
                    }
                    if (whiteStart == this.currentPosition || this.completionIdentifier != null || whiteStart > this.cursorLocation + 1 || this.cursorLocation >= this.startPosition || ScannerHelper.isJavaIdentifierStart((long)this.complianceLevel, (char)this.currentCharacter)) continue;
                    this.currentPosition = this.startPosition;
                    return TerminalToken.TokenNameIdentifier;
                } while (isWhiteSpace);
                if (this.tokenizeWhiteSpace && hasWhiteSpaces) {
                    this.currentPosition -= offset;
                    this.startPosition = whiteStart;
                    return TerminalToken.TokenNameWHITESPACE;
                }
                if (this.currentPosition > this.eofPosition) {
                    if (this.completionIdentifier == null && this.startPosition == this.cursorLocation + 1) {
                        temp = this.eofPosition;
                        this.eofPosition = this.source.length;
                        while (this.getNextCharAsJavaIdentifierPart()) {
                        }
                        this.eofPosition = temp;
                        this.endOfEmptyToken = this.currentPosition - 1;
                        this.currentPosition = this.startPosition;
                        return TerminalToken.TokenNameIdentifier;
                    }
                    this.currentPosition = this.startPosition;
                    return TerminalToken.TokenNameEOF;
                }
                switch (this.currentCharacter) {
                    case '@': {
                        return TerminalToken.TokenNameAT;
                    }
                    case '(': {
                        return TerminalToken.TokenNameLPAREN;
                    }
                    case ')': {
                        return TerminalToken.TokenNameRPAREN;
                    }
                    case '{': {
                        return TerminalToken.TokenNameLBRACE;
                    }
                    case '}': {
                        return TerminalToken.TokenNameRBRACE;
                    }
                    case '[': {
                        return TerminalToken.TokenNameLBRACKET;
                    }
                    case ']': {
                        return TerminalToken.TokenNameRBRACKET;
                    }
                    case ';': {
                        return TerminalToken.TokenNameSEMICOLON;
                    }
                    case ',': {
                        return TerminalToken.TokenNameCOMMA;
                    }
                    case '.': {
                        if (this.startPosition <= this.cursorLocation && this.cursorLocation < this.currentPosition) {
                            return TerminalToken.TokenNameDOT;
                        }
                        if (this.getNextCharAsDigit()) {
                            return this.scanNumber(true);
                        }
                        temp = this.currentPosition;
                        if (this.getNextChar('.')) {
                            if (this.getNextChar('.')) {
                                return TerminalToken.TokenNameELLIPSIS;
                            }
                            this.currentPosition = temp;
                            return TerminalToken.TokenNameDOT;
                        }
                        this._dotSeen = 2;
                        this.currentPosition = temp;
                        return TerminalToken.TokenNameDOT;
                    }
                    case '+': {
                        test = this.getNextChar('+', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNamePLUS_PLUS;
                        }
                        if (test > 0) {
                            return TerminalToken.TokenNamePLUS_EQUAL;
                        }
                        return TerminalToken.TokenNamePLUS;
                    }
                    case '-': {
                        test = this.getNextChar('-', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameMINUS_MINUS;
                        }
                        if (test > 0) {
                            return TerminalToken.TokenNameMINUS_EQUAL;
                        }
                        if (this.getNextChar('>')) {
                            if (this.needBindoutDisambiguation()) {
                                if (this._insideParameterMapping) {
                                    this._bindoutLookahead = new Scanner.BindoutLookahead((Scanner)this);
                                    return this._bindoutLookahead.getNextToken();
                                }
                                this._calloutSeen = true;
                                return TerminalToken.TokenNameBINDOUT;
                            }
                            return TerminalToken.TokenNameARROW;
                        }
                        return TerminalToken.TokenNameMINUS;
                    }
                    case '~': {
                        return TerminalToken.TokenNameTWIDDLE;
                    }
                    case '!': {
                        if (this.getNextChar('=')) {
                            return TerminalToken.TokenNameNOT_EQUAL;
                        }
                        return TerminalToken.TokenNameNOT;
                    }
                    case '*': {
                        if (this.getNextChar('=')) {
                            return TerminalToken.TokenNameMULTIPLY_EQUAL;
                        }
                        return TerminalToken.TokenNameMULTIPLY;
                    }
                    case '%': {
                        if (this.getNextChar('=')) {
                            return TerminalToken.TokenNameREMAINDER_EQUAL;
                        }
                        return TerminalToken.TokenNameREMAINDER;
                    }
                    case '<': {
                        test = this.getNextChar('=', '<');
                        if (test == 0) {
                            return TerminalToken.TokenNameLESS_EQUAL;
                        }
                        if (test > 0) {
                            if (this.getNextChar('=')) {
                                return TerminalToken.TokenNameLEFT_SHIFT_EQUAL;
                            }
                            return TerminalToken.TokenNameLEFT_SHIFT;
                        }
                        if (test < 0 && this._isOTSource && this.getNextChar('-')) {
                            this._callinSeen = true;
                            return TerminalToken.TokenNameBINDIN;
                        }
                        return TerminalToken.TokenNameLESS;
                    }
                    case '>': {
                        if (this.returnOnlyGreater) {
                            return TerminalToken.TokenNameGREATER;
                        }
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return TerminalToken.TokenNameGREATER_EQUAL;
                        }
                        if (test > 0) {
                            test = this.getNextChar('=', '>');
                            if (test == 0) {
                                return TerminalToken.TokenNameRIGHT_SHIFT_EQUAL;
                            }
                            if (test > 0) {
                                if (this.getNextChar('=')) {
                                    return TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL;
                                }
                                return TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT;
                            }
                            return TerminalToken.TokenNameRIGHT_SHIFT;
                        }
                        return TerminalToken.TokenNameGREATER;
                    }
                    case '=': {
                        test = this.getNextChar('=', '>');
                        if (test == 0) {
                            return TerminalToken.TokenNameEQUAL_EQUAL;
                        }
                        if (test > 0) {
                            this._calloutSeen = true;
                            return TerminalToken.TokenNameCALLOUT_OVERRIDE;
                        }
                        return TerminalToken.TokenNameEQUAL;
                    }
                    case '&': {
                        test = this.getNextChar('&', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameAND_AND;
                        }
                        if (test > 0) {
                            return TerminalToken.TokenNameAND_EQUAL;
                        }
                        return TerminalToken.TokenNameAND;
                    }
                    case '|': {
                        test = this.getNextChar('|', '=');
                        if (test == 0) {
                            return TerminalToken.TokenNameOR_OR;
                        }
                        if (test > 0) {
                            return TerminalToken.TokenNameOR_EQUAL;
                        }
                        return TerminalToken.TokenNameOR;
                    }
                    case '^': {
                        if (this.getNextChar('=')) {
                            return TerminalToken.TokenNameXOR_EQUAL;
                        }
                        return TerminalToken.TokenNameXOR;
                    }
                    case '?': {
                        return TerminalToken.TokenNameQUESTION;
                    }
                    case ':': {
                        if (this.getNextChar(':')) {
                            return TerminalToken.TokenNameCOLON_COLON;
                        }
                        return TerminalToken.TokenNameCOLON;
                    }
                    case '\'': {
                        test = this.getNextChar('\n', '\r');
                        if (test == 0) {
                            throw CompletionScanner.invalidCharacter();
                        }
                        if (test > 0) {
                            lookAhead = 0;
                            while (lookAhead < 3) {
                                if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                                if (this.source[this.currentPosition + lookAhead] == '\'') {
                                    this.currentPosition += lookAhead + 1;
                                    break;
                                }
                                ++lookAhead;
                            }
                            throw CompletionScanner.invalidCharacter();
                        }
                        if (this.getNextChar('\'')) {
                            lookAhead = 0;
                            while (lookAhead < 3) {
                                if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                                if (this.source[this.currentPosition + lookAhead] == '\'') {
                                    this.currentPosition += lookAhead + 1;
                                    break;
                                }
                                ++lookAhead;
                            }
                            throw CompletionScanner.invalidCharacter();
                        }
                        if (this.getNextChar('\\')) {
                            if (this.unicodeAsBackSlash) {
                                this.unicodeAsBackSlash = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.unicodeStore();
                                }
                            } else {
                                this.currentCharacter = this.source[this.currentPosition++];
                            }
                            this.scanEscapeCharacter();
                        } else {
                            this.unicodeAsBackSlash = false;
                            checkIfUnicode = false;
                            try {
                                this.currentCharacter = this.source[this.currentPosition++];
                                checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                            }
                            catch (IndexOutOfBoundsException v2) {
                                --this.currentPosition;
                                throw CompletionScanner.invalidCharacter();
                            }
                            if (checkIfUnicode) {
                                this.getNextUnicodeChar();
                            } else if (this.withoutUnicodePtr != 0) {
                                this.unicodeStore();
                            }
                        }
                        if (this.getNextChar('\'')) {
                            return TerminalToken.TokenNameCharacterLiteral;
                        }
                        lookAhead = 0;
                        while (lookAhead < 20) {
                            if (this.currentPosition + lookAhead == this.eofPosition || this.source[this.currentPosition + lookAhead] == '\n') break;
                            if (this.source[this.currentPosition + lookAhead] == '\'') {
                                this.currentPosition += lookAhead + 1;
                                break;
                            }
                            ++lookAhead;
                        }
                        throw CompletionScanner.invalidCharacter();
                    }
                    case '\"': {
                        try {
                            ret = this.scanForStringLiteral();
                            return ret;
                        }
                        catch (InvalidInputException e) {
                            if ("Invalid_Char_In_String".equals(e.getMessage()) != false ? this.startPosition <= this.cursorLocation && this.cursorLocation <= this.currentPosition - 1 : "Unterminated_String".equals(e.getMessage()) != false && this.startPosition <= this.cursorLocation && this.cursorLocation <= this.currentPosition - 1) {
                                return TerminalToken.TokenNameStringLiteral;
                            }
                            throw e;
                        }
                    }
                    case '/': {
                        test = this.findCommentType();
                        if (test != 0 && test != 2) ** GOTO lbl344
                        this.lastCommentLinePosition = this.currentPosition--;
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                c1 = 0;
                                c2 = 0;
                                c3 = 0;
                                c4 = 0;
                                ++this.currentPosition;
                                while (this.source[this.currentPosition] == 'u') {
                                    ++this.currentPosition;
                                }
                                if ((c1 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c4 < 0) {
                                    throw CompletionScanner.invalidUnicodeEscape();
                                }
                                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                            }
                            if (this.currentCharacter != '\\' || this.source[this.currentPosition] == '\\') {
                                // empty if block
                            }
                            isUnicode = false;
                            while (true) {
                                this.lastCommentLinePosition = ++this.currentPosition;
                                isUnicode = false;
                                if (this.currentCharacter == '\r' && this.eofPosition > this.currentPosition) {
                                    if (this.source[this.currentPosition] == '\n') {
                                        ++this.currentPosition;
                                        this.currentCharacter = (char)10;
                                    } else if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                        isUnicode = true;
                                        index = this.currentPosition + 1;
                                        ++index;
                                        while (this.source[index] == 'u') {
                                            ++index;
                                        }
                                        c1 = 0;
                                        c2 = 0;
                                        c3 = 0;
                                        c4 = 0;
                                        if ((c1 = ScannerHelper.getHexadecimalValue((char)this.source[index++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getHexadecimalValue((char)this.source[index++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getHexadecimalValue((char)this.source[index++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getHexadecimalValue((char)this.source[index++])) > 15 || c4 < 0) {
                                            this.currentPosition = index;
                                            throw CompletionScanner.invalidUnicodeEscape();
                                        }
                                        unicodeChar = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                        if (unicodeChar == '\n') {
                                            this.currentPosition = index;
                                            this.currentCharacter = (char)10;
                                        }
                                    }
                                }
                                if (this.currentCharacter == '\n' && (test == 0 || !this.lineBeginsWithMarkdown())) break;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    isUnicode = true;
                                    c1 = 0;
                                    c2 = 0;
                                    c3 = 0;
                                    c4 = 0;
                                    ++this.currentPosition;
                                    while (this.source[this.currentPosition] == 'u') {
                                        ++this.currentPosition;
                                    }
                                    if ((c1 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getHexadecimalValue((char)this.source[this.currentPosition++])) > 15 || c4 < 0) {
                                        throw CompletionScanner.invalidUnicodeEscape();
                                    }
                                    this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                }
                                if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                ++this.currentPosition;
                            }
                            this.recordComment(test == 0 ? TerminalToken.TokenNameCOMMENT_LINE : TerminalToken.TokenNameCOMMENT_MARKDOWN);
                            if (test == 0 && this.startPosition <= this.cursorLocation && this.cursorLocation < this.currentPosition - 1) {
                                throw new InvalidCursorLocation("No Completion Inside Comment");
                            }
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator) {
                                if (isUnicode) {
                                    this.pushUnicodeLineSeparator();
                                } else {
                                    this.pushLineSeparator();
                                }
                            }
                            if (!this.tokenizeComments) ** GOTO lbl-1000
                            return TerminalToken.TokenNameCOMMENT_LINE;
                        }
                        catch (IndexOutOfBoundsException v3) {
                            this.recordComment(TerminalToken.TokenNameCOMMENT_LINE);
                            if (this.taskTags != null) {
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                            }
                            if (!this.tokenizeComments) ** GOTO lbl-1000
                            return TerminalToken.TokenNameCOMMENT_LINE;
                        }
lbl344:
                        // 1 sources

                        if (test == 1) {
                            try {
                                isJavadoc = false;
                                star = false;
                                isUnicode = false;
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                    if (this.withoutUnicodePtr != 0) {
                                        this.unicodeStore();
                                    }
                                }
                                if (this.currentCharacter == '*') {
                                    isJavadoc = true;
                                    star = true;
                                }
                                if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator && !isUnicode) {
                                    this.pushLineSeparator();
                                }
                                isUnicode = false;
                                previous = this.currentPosition;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                if (this.currentCharacter == '/') {
                                    isJavadoc = false;
                                }
                                firstTag = 0;
                                while (this.currentCharacter != '/' || !star) {
                                    if ((this.currentCharacter == '\r' || this.currentCharacter == '\n') && this.recordLineSeparator && !isUnicode) {
                                        this.pushLineSeparator();
                                    }
                                    switch (this.currentCharacter) {
                                        case '*': {
                                            star = true;
                                            break;
                                        }
                                        case '@': {
                                            if (firstTag == 0 && this.isFirstTag()) {
                                                firstTag = previous;
                                            }
                                        }
                                        default: {
                                            star = false;
                                        }
                                    }
                                    previous = this.currentPosition;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                                token = isJavadoc != false ? TerminalToken.TokenNameCOMMENT_JAVADOC : TerminalToken.TokenNameCOMMENT_BLOCK;
                                this.recordComment(token);
                                this.commentTagStarts[this.commentPtr] = firstTag;
                                if (!isJavadoc && this.startPosition <= this.cursorLocation && this.cursorLocation < this.currentPosition - 1) {
                                    throw new InvalidCursorLocation("No Completion Inside Comment");
                                }
                                if (this.taskTags == null) continue block46;
                                this.checkTaskTag(this.startPosition, this.currentPosition);
                                if (!this.tokenizeComments) continue block46;
                                return token;
                            }
                            catch (IndexOutOfBoundsException v4) {
                                --this.currentPosition;
                                throw CompletionScanner.unterminatedComment();
                            }
                        }
                        if (this.getNextChar('=')) {
                            return TerminalToken.TokenNameDIVIDE_EQUAL;
                        }
                        return TerminalToken.TokenNameDIVIDE;
                    }
                    case '\u001a': {
                        if (this.atEnd()) {
                            return TerminalToken.TokenNameEOF;
                        }
                        throw CompletionScanner.invalidEof();
                    }
                }
                break;
            }
            c = this.currentCharacter;
            if (c < '\u0080') {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 64) != 0) {
                    return this.scanIdentifierOrKeyword();
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) != 0) {
                    return this.scanNumber(false);
                }
                return TerminalToken.TokenNameERROR;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.complianceLevel < 0x310000L) {
                    throw CompletionScanner.invalidUnicodeEscape();
                }
                low = (char)this.getNextChar();
                if (low < '\udc00' || low > '\udfff') {
                    throw CompletionScanner.invalidLowSurrogate();
                }
                isJavaIdStart = ScannerHelper.isJavaIdentifierStart((long)this.complianceLevel, (char)c, (char)low);
            } else {
                if (c >= '\udc00' && c <= '\udfff') {
                    if (this.complianceLevel < 0x310000L) {
                        throw CompletionScanner.invalidUnicodeEscape();
                    }
                    throw CompletionScanner.invalidHighSurrogate();
                }
                isJavaIdStart = Character.isJavaIdentifierStart(c);
            }
            if (isJavaIdStart) {
                return this.scanIdentifierOrKeyword();
            }
            if (ScannerHelper.isDigit((char)this.currentCharacter)) {
                return this.scanNumber(false);
            }
            return TerminalToken.TokenNameERROR;
        }
        catch (IndexOutOfBoundsException v5) {
            if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                --this.currentPosition;
                this.startPosition = whiteStart;
                return TerminalToken.TokenNameWHITESPACE;
            }
            if (this.completionIdentifier == null && this.startPosition == this.cursorLocation + 1) {
                this.endOfEmptyToken = this.currentPosition - 1;
                this.currentPosition = this.startPosition;
                return TerminalToken.TokenNameIdentifier;
            }
            return TerminalToken.TokenNameEOF;
        }
    }

    protected TerminalToken getNextNotFakedToken() throws InvalidInputException {
        TerminalToken token;
        boolean fromUnget = false;
        if (this.nextToken != TerminalToken.TokenNameNotAToken) {
            token = this.nextToken;
            this.nextToken = TerminalToken.TokenNameNotAToken;
            fromUnget = true;
        } else {
            token = this.getNextToken();
        }
        if (this.currentPosition == this.startPosition) {
            if (!fromUnget) {
                ++this.currentPosition;
            }
            return TerminalToken.TokenNameInvalid;
        }
        return token;
    }

    public final void getNextUnicodeChar() throws InvalidInputException {
        int temp = this.currentPosition;
        super.getNextUnicodeChar();
        if (this.cursorLocation > temp) {
            this.unicodeCharSize += this.currentPosition - temp;
        }
        if (temp < this.cursorLocation && this.cursorLocation < this.currentPosition - 1) {
            throw new InvalidCursorLocation("No Completion Inside Unicode");
        }
    }

    protected boolean isFirstTag() {
        return this.getNextChar('d') && this.getNextChar('e') && this.getNextChar('p') && this.getNextChar('r') && this.getNextChar('e') && this.getNextChar('c') && this.getNextChar('a') && this.getNextChar('t') && this.getNextChar('e') && this.getNextChar('d');
    }

    public final void jumpOverBlock() {
        this.jumpOverMethodBody();
    }

    public TerminalToken scanIdentifierOrKeyword() {
        TerminalToken id = super.scanIdentifierOrKeyword();
        if (this.startPosition <= this.cursorLocation + 1 && this.cursorLocation < this.currentPosition) {
            if (this.cursorLocation + 1 == this.eofPosition) {
                int temp = this.eofPosition;
                this.eofPosition = this.source.length;
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
                this.eofPosition = temp;
            }
            switch (id) {
                case TokenNamereplace: 
                case TokenNameafter: 
                case TokenNamebefore: {
                    return id;
                }
            }
            return TerminalToken.TokenNameIdentifier;
        }
        return id;
    }

    public TerminalToken scanNumber(boolean dotPrefix) throws InvalidInputException {
        TerminalToken token = super.scanNumber(dotPrefix);
        if (this.startPosition <= this.cursorLocation && this.cursorLocation < this.currentPosition) {
            throw new InvalidCursorLocation("No Completion Inside Number");
        }
        return token;
    }
}

