/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.IAlienScopeTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;
    public boolean isPreparingForLifting = false;
    public boolean isPlaceHolder = false;
    public boolean isGenerated = false;

    public LocalDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.declarationEnd = sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean shouldAnalyseResource;
        if ((flowInfo.tagBits & 1) == 0) {
            this.bits |= 0x40000000;
        }
        if (this.isPlaceHolder) {
            this.binding.useFlag = 1;
        }
        if (this.initialization == null) {
            if (this.binding != null && this.binding.isPatternVariable() && !this.binding.declaration.isUnnamed(currentScope)) {
                this.bits |= 8;
            }
            return flowInfo;
        }
        this.initialization.checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
        UnconditionalFlowInfo preInitInfo = null;
        CompilerOptions compilerOptions = currentScope.compilerOptions();
        boolean bl = shouldAnalyseResource = this.binding != null && flowInfo.reachMode() == 0 && compilerOptions.analyseResourceLeaks && !currentScope.isGeneratedScope() && FakedTrackingVariable.isAnyCloseable(this.initialization.resolvedType);
        if (shouldAnalyseResource) {
            preInitInfo = flowInfo.unconditionalCopy();
            FakedTrackingVariable.preConnectTrackerAcrossAssignment(this, this.binding, this.initialization, flowInfo, compilerOptions.isAnnotationBasedResourceAnalysisEnabled);
        }
        flowInfo = this.initialization.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        if (shouldAnalyseResource) {
            FakedTrackingVariable.handleResourceAssignment(currentScope, preInitInfo, flowInfo, flowContext, this, this.initialization, this.binding);
        } else {
            FakedTrackingVariable.cleanUpAfterAssignment(currentScope, 2, this.initialization);
        }
        int nullStatus = this.initialization.nullStatus(flowInfo, flowContext);
        this.bits = !flowInfo.isDefinitelyAssigned(this.binding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
        flowInfo.markAsDefinitelyAssigned(this.binding);
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            nullStatus = NullAnnotationMatching.checkAssignment(currentScope, flowContext, this.binding, flowInfo, nullStatus, this.initialization, this.initialization.resolvedType);
        }
        if ((this.binding.type.tagBits & 2L) == 0L) {
            flowInfo.markNullStatus(this.binding, nullStatus);
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers &= 0xFFBFFFFF;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        block11: {
            if (this.binding.resolvedPosition != -1) {
                codeStream.addVisibleLocalVariable(this.binding);
            }
            if ((this.bits & -2147483648) == 0) {
                return;
            }
            pc = codeStream.position;
            if (this.initialization == null && !this.binding.isPatternVariable()) break block11;
            if (this.initialization == null) ** GOTO lbl27
            if (this.binding.resolvedPosition < 0) {
                if (this.initialization.constant == Constant.NotAConstant) {
                    this.initialization.generateCode(currentScope, codeStream, false);
                }
            } else {
                if (this.isPreparingForLifting) {
                    i = 0;
                    while (i < 6) {
                        codeStream.nop();
                        ++i;
                    }
                }
                this.initialization.generateCode(currentScope, codeStream, true);
                if (this.isPreparingForLifting) {
                    i = 0;
                    while (i < 3) {
                        codeStream.nop();
                        ++i;
                    }
                }
                if (this.binding.type.isArrayType() && this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
                    codeStream.checkcast(this.binding.type);
                }
lbl27:
                // 4 sources

                codeStream.store(this.binding, false);
                if ((this.bits & 8) != 0) {
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public int getKind() {
        return 4;
    }

    @Override
    public void getAllAnnotationContexts(int targetType, LocalVariableBinding localVariable, List<AnnotationContext> allAnnotationContexts) {
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector(this, targetType, localVariable, allAnnotationContexts);
        this.traverseWithoutInitializer(collector, null);
    }

    @Override
    public void getAllAnnotationContexts(int targetType, int parameterIndex, List<AnnotationContext> allAnnotationContexts) {
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector((AbstractVariableDeclaration)this, targetType, parameterIndex, allAnnotationContexts);
        this.traverse(collector, null);
    }

    public boolean isReceiver() {
        return false;
    }

    public TypeBinding patchType(BlockScope scope, TypeBinding newType) {
        TypeBinding[] mentionedTypeVariables;
        if (TypeBinding.equalsEquals(TypeBinding.NULL, newType)) {
            scope.problemReporter().varLocalInitializedToNull(this);
        } else if (TypeBinding.equalsEquals(TypeBinding.VOID, newType)) {
            scope.problemReporter().varLocalInitializedToVoid(this);
        }
        TypeBinding[] typeBindingArray = mentionedTypeVariables = newType != null ? newType.syntheticTypeVariablesMentioned() : null;
        if (mentionedTypeVariables != null && mentionedTypeVariables.length > 0) {
            newType = newType.upwardsProjection(this.binding.declaringScope, mentionedTypeVariables);
        }
        this.type.resolvedType = newType;
        if (this.binding != null) {
            this.binding.type = newType;
        }
        return this.type.resolvedType;
    }

    @Override
    public void resolve(BlockScope scope) {
        LocalDeclaration.handleNonNullByDefault(scope, this.annotations, this);
        boolean isPatternVariable = (this.bits & 0x800000) != 0;
        boolean isForeachElementVariable = (this.bits & 0x10) != 0;
        boolean varTypedLocal = this.isVarTyped(scope);
        boolean unnamedLocal = this.isUnnamed(scope);
        TypeBinding variableType = null;
        if (this.binding == null) {
            if (varTypedLocal) {
                if ((this.bits & 0x400000) != 0) {
                    scope.problemReporter().varLocalMultipleDeclarators(this);
                }
                if (isPatternVariable) {
                    variableType = this.type.resolvedType;
                }
            } else {
                variableType = this.type == null ? null : this.type.resolveType(scope, true);
            }
            Scope typeScope = scope;
            if (this.type instanceof IAlienScopeTypeReference) {
                typeScope = ((IAlienScopeTypeReference)((Object)this.type)).getAlienScope();
            }
            variableType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(variableType, typeScope, (ASTNode)this);
            if (this.type != null) {
                Binding existingVariable;
                this.bits |= this.type.bits & 0x100000;
                this.checkModifiers();
                if (variableType != null) {
                    if (variableType == TypeBinding.VOID) {
                        scope.problemReporter().variableTypeCannotBeVoid(this);
                        return;
                    }
                    if (variableType.isArrayType() && ((ArrayBinding)variableType).leafComponentType == TypeBinding.VOID) {
                        scope.problemReporter().variableTypeCannotBeVoidArray(this);
                        return;
                    }
                }
                if ((existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this, false)) != null && existingVariable.isValidBinding() && !unnamedLocal) {
                    boolean localExists = existingVariable instanceof LocalVariableBinding;
                    if (localExists && (this.bits & 0x200000) != 0 && scope.isLambdaSubscope() && this.hiddenVariableDepth == 0) {
                        scope.problemReporter().lambdaRedeclaresLocal(this);
                    } else if (localExists && this.hiddenVariableDepth == 0) {
                        if (existingVariable.isPatternVariable()) {
                            scope.problemReporter().illegalRedeclarationOfPatternVar((LocalVariableBinding)existingVariable, this);
                        } else {
                            scope.problemReporter().redefineLocal(this);
                        }
                    } else {
                        scope.problemReporter().localVariableHiding(this, existingVariable, false);
                    }
                }
            }
            if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
                this.modifiers |= 0x4000000;
            }
            this.binding = new LocalVariableBinding(this, varTypedLocal && variableType == null ? scope.getJavaLangObject() : variableType, this.modifiers, false);
            if (isPatternVariable) {
                this.binding.tagBits |= 0x4000L;
            }
            scope.addLocalVariable(this.binding);
            this.binding.setConstant(Constant.NotAConstant);
        } else {
            variableType = this.binding.type;
        }
        boolean resolveAnnotationsEarly = false;
        if (scope.environment().usesNullTypeAnnotations() && !varTypedLocal && variableType != null && variableType.isValidBinding()) {
            boolean bl = resolveAnnotationsEarly = this.initialization instanceof Invocation || this.initialization instanceof ConditionalExpression || this.initialization instanceof SwitchExpression || this.initialization instanceof ArrayInitializer;
        }
        if (resolveAnnotationsEarly) {
            LocalDeclaration.resolveAnnotations(scope, this.annotations, this.binding, true);
            variableType = this.type.resolvedType;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding initializationType;
                if (varTypedLocal) {
                    scope.problemReporter().varLocalCannotBeArrayInitalizers(this);
                    variableType = scope.createArrayType(scope.getJavaLangObject(), 1);
                }
                if ((initializationType = this.initialization.resolveTypeExpecting(scope, variableType)) != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationType;
                    this.initialization.computeConversion(scope, variableType, initializationType);
                }
            } else {
                if (varTypedLocal) {
                    this.binding.useFlag = 3;
                    Expression expression = this.initialization;
                    if (expression instanceof CastExpression) {
                        CastExpression castExpression = (CastExpression)expression;
                        castExpression.setVarTypeDeclaration(true);
                    }
                }
                this.initialization.setExpressionContext(varTypedLocal ? ExpressionContext.VANILLA_CONTEXT : ExpressionContext.ASSIGNMENT_CONTEXT);
                this.initialization.setExpectedType(variableType);
                TypeBinding initializationType = this.initialization.resolveType(scope);
                if (varTypedLocal) {
                    this.binding.useFlag = 0;
                }
                if (variableType == null && !varTypedLocal || initializationType == null && varTypedLocal) {
                    return;
                }
                if (initializationType != null) {
                    initializationType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(initializationType, scope, (ASTNode)this.initialization);
                    if (varTypedLocal) {
                        variableType = this.patchType(scope, this.initialization.resolvedType);
                    }
                    if (TypeBinding.notEquals(variableType, initializationType)) {
                        scope.compilationUnitScope().recordTypeConversion(variableType, initializationType);
                    }
                    if (this.initialization.isConstantValueOfTypeAssignableToType(initializationType, variableType) || initializationType.isCompatibleWith(variableType, scope)) {
                        this.initialization.computeConversion(scope, variableType, initializationType);
                        if (initializationType.needsUncheckedConversion(variableType)) {
                            scope.problemReporter().unsafeTypeConversion(this.initialization, initializationType, variableType);
                        }
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(scope, variableType, (CastExpression)this.initialization);
                        }
                    } else if (this.isBoxingCompatible(initializationType, variableType, this.initialization, scope)) {
                        this.initialization.computeConversion(scope, variableType, initializationType);
                        if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                            CastExpression.checkNeedForAssignedCast(scope, variableType, (CastExpression)this.initialization);
                        }
                    } else if ((variableType.tagBits & 0x80L) == 0L) {
                        scope.problemReporter().typeMismatchError(initializationType, variableType, this.initialization, null);
                    }
                    if (Config.getLoweringPossible() && initializationType.isRoleType()) {
                        ((DependentTypeBinding)initializationType).recheckAmbiguousLowering(variableType, this, scope, null);
                    }
                }
            }
            if (this.binding == Expression.getDirectBinding(this.initialization)) {
                scope.problemReporter().assignmentHasNoEffect(this, this.name);
            }
            this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((variableType.id << 4) + this.initialization.constant.typeID()) : Constant.NotAConstant);
            this.binding.setBestNameFromStat(this.initialization);
        } else if (!isPatternVariable && !isForeachElementVariable) {
            if (varTypedLocal) {
                scope.problemReporter().varLocalWithoutInitizalier(this);
            }
            if (unnamedLocal) {
                scope.problemReporter().unnamedVariableMustHaveInitializer(this);
            }
        }
        if (!resolveAnnotationsEarly) {
            LocalDeclaration.resolveAnnotations(scope, this.annotations, this.binding, true);
        }
        Annotation.isTypeUseCompatible(this.type, scope, this.annotations);
        this.validateNullAnnotations(scope);
    }

    void validateNullAnnotations(BlockScope scope) {
        if (!scope.validateNullAnnotation(this.binding.tagBits, this.type, this.annotations)) {
            this.binding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                int i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    private void traverseWithoutInitializer(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                int i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, scope);
                    ++i;
                }
            }
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public boolean isRecoveredFromLoneIdentifier() {
        return this.name == RecoveryScanner.FAKE_IDENTIFIER && (this.type instanceof SingleTypeReference || this.type instanceof QualifiedTypeReference && !(this.type instanceof ArrayQualifiedTypeReference)) && this.initialization == null && !this.type.isBaseTypeReference();
    }

    @Override
    public LocalVariableBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = (LocalVariableBinding)binding;
    }
}

