/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.OTType;
import org.eclipse.osgi.util.NLS;

public class RoleType
extends OTType
implements IRoleType {
    private IType baseClass;
    private String _baseAnchor;
    private String baseClassName;

    public RoleType(IType correspondingJavaType, IJavaElement parent, int flags, String baseClassName, String baseClassAnchor) {
        super(0x65 | (TypeHelper.isTeam(flags) ? 100 : 0), correspondingJavaType, parent, flags);
        this.baseClassName = baseClassName;
        this._baseAnchor = baseClassAnchor;
    }

    @Override
    public IOTType getTeam() {
        JavaElement p = this.getParent();
        if (p != null && p instanceof IOTType) {
            return (IOTType)((Object)p);
        }
        IType teamType = this.getTeamJavaType();
        if (teamType != null) {
            return OTModelManager.getOTElement(teamType);
        }
        return null;
    }

    @Override
    public IType getTeamJavaType() {
        return ((IType)this.getCorrespondingJavaElement()).getDeclaringType();
    }

    @Override
    public IMethodMapping[] getMethodMappings() {
        return this.getMethodMappings(3);
    }

    @Override
    public IMethodMapping[] getMethodMappings(int type) {
        LinkedList<IMethodMapping> result = new LinkedList<IMethodMapping>();
        if ((type & 1) != 0) {
            this.filterMethodMappings(this.getChildren(), 1, result);
        }
        if ((type & 2) != 0) {
            try {
                this.filterMethodMappings(((IType)this.getCorrespondingJavaElement()).getChildren(), 2, result);
            }
            catch (JavaModelException ex) {
                Util.log((Throwable)((Object)ex), NLS.bind((String)"Retrieving callouts of role class ''{0}'' failed!", (Object[])new Object[]{this.getElementName()}));
            }
        }
        return result.toArray(new IMethodMapping[result.size()]);
    }

    private void filterMethodMappings(IJavaElement[] children, int type, List<IMethodMapping> result) {
        int idx = 0;
        while (idx < children.length) {
            if (children[idx] instanceof IMethodMapping) {
                IMethodMapping mapping = (IMethodMapping)children[idx];
                switch (mapping.getElementType()) {
                    case 102: {
                        if ((type & 1) == 0) break;
                        result.add(mapping);
                        break;
                    }
                    case 103: {
                        if ((type & 2) == 0) break;
                        result.add(mapping);
                        break;
                    }
                    case 104: {
                        if ((type & 2) == 0) break;
                        result.add(mapping);
                    }
                }
            }
            ++idx;
        }
    }

    @Override
    public boolean isRoleFile() {
        return false;
    }

    public void setBaseClass(IType baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    public IType getBaseClass() throws JavaModelException {
        return this.getBaseClass(null);
    }

    private IType getBaseClass(ITypeHierarchy hierarchy) throws JavaModelException {
        if (this.baseClass == null) {
            JavaModelException jex = null;
            try {
                this.baseClass = this.findBaseClass(hierarchy);
            }
            catch (JavaModelException ex) {
                jex = ex;
            }
            catch (Exception ex) {
                Util.log(ex, NLS.bind((String)"Resolving of base class ''{0}'' failed!", (Object[])new Object[]{this.baseClassName}));
            }
            if (this.baseClass == null && (this.baseClassName != null || jex != null)) {
                Status status = new Status(2, "org.eclipse.jdt.core", 0, NLS.bind((String)"Base class for role {0} not found.", (Object[])new Object[]{this.getTypeQualifiedName('.')}), (Throwable)((Object)jex));
                throw new JavaModelException(new CoreException((IStatus)status));
            }
        }
        return this.baseClass;
    }

    @Override
    public String getBaseclassName() {
        if (this._baseAnchor != null) {
            return this._baseAnchor + "." + this.baseClassName;
        }
        return this.baseClassName;
    }

    @Override
    public String getFullBaseclassName() {
        if (this._baseAnchor == null || this._baseAnchor.length() == 0) {
            return this.baseClassName;
        }
        return this.baseClassName + "<@" + this._baseAnchor + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RoleType)) {
            return false;
        }
        RoleType other = (RoleType)obj;
        if (this.baseClassName == null != (other.baseClassName == null)) {
            return false;
        }
        if (this.baseClassName != null && !this.baseClassName.equals(other.baseClassName)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public String toString() {
        return "role " + this.getElementName() + " for type: " + this.getCorrespondingJavaElement().toString();
    }

    private IType findBaseClass(ITypeHierarchy hierarchy) throws JavaModelException {
        if (this.baseClassName == null) {
            return this.findSuperBaseClass(hierarchy);
        }
        if (this._baseAnchor != null) {
            IType[] baseClasses;
            IOTType baseAnchorType = this.resolveBaseAnchor();
            if (baseAnchorType == null) {
                return null;
            }
            String simpleBaseName = this.baseClassName;
            int dotpos = this.baseClassName.lastIndexOf(46);
            if (dotpos != -1) {
                simpleBaseName = this.baseClassName.substring(dotpos + 1);
            }
            if ((baseClasses = baseAnchorType.getRoleTypes(15, simpleBaseName)).length >= 1) {
                return baseClasses[0];
            }
        }
        return this.resolveInType(this, this.baseClassName);
    }

    private IType findSuperBaseClass(ITypeHierarchy hierarchy) throws JavaModelException {
        IType currentType = (IType)this.getCorrespondingJavaElement();
        if (hierarchy == null) {
            hierarchy = currentType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        }
        currentType = hierarchy.getSuperclass(currentType);
        while (currentType != null && OTModelManager.isRole(currentType)) {
            IType baseType = this.getBaseOf(currentType, hierarchy);
            if (baseType != null) {
                return baseType;
            }
            currentType = hierarchy.getSuperclass(currentType);
        }
        return null;
    }

    private IType getBaseOf(IType type, ITypeHierarchy hierarchy) throws JavaModelException {
        if (type != null && type.exists()) {
            RoleType tsuperRole;
            IType tsuperBase;
            IOTType otType = OTModelManager.getOTElement(type);
            if (otType == null) {
                return null;
            }
            if (otType.isRole() && (tsuperBase = (tsuperRole = (RoleType)otType).getBaseClass(hierarchy)) != null) {
                return tsuperBase;
            }
        }
        return null;
    }

    private IOTType resolveBaseAnchor() throws JavaModelException {
        if (this._baseAnchor == null) {
            return null;
        }
        IOTType enclosingTeam = this.getTeam();
        if (enclosingTeam == null || !enclosingTeam.exists()) {
            return null;
        }
        IType currentType = enclosingTeam;
        String anchorField = this._baseAnchor;
        int pos = this._baseAnchor.lastIndexOf(46);
        if (pos > 0) {
            anchorField = this._baseAnchor.substring(pos + 1);
            currentType = this.resolveInType(enclosingTeam, this._baseAnchor.substring(0, pos));
        }
        IType anchorType = null;
        if (anchorField.equals(new String(IOTConstants.BASE))) {
            IOTType currentOTType = OTModelManager.getOTElement(currentType);
            if (currentOTType == null || !currentOTType.isRole()) {
                return null;
            }
            IRoleType enclosingRole = (IRoleType)currentOTType;
            assert (enclosingRole != this);
            anchorType = enclosingRole.getBaseClass();
        } else {
            IField field = currentType.getField(anchorField);
            String fieldType = null;
            if (field.exists()) {
                fieldType = Signature.toString(field.getTypeSignature());
            } else {
                ITypeParameter[] iTypeParameterArray = currentType.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter param = iTypeParameterArray[n2];
                    if (((TypeParameter)param).isValueParameter && param.getElementName().equals(anchorField)) {
                        fieldType = param.getBounds()[0];
                        break;
                    }
                    ++n2;
                }
            }
            if (fieldType != null) {
                anchorType = this.resolveInType(enclosingTeam, fieldType);
            }
        }
        if (anchorType == null || !anchorType.exists()) {
            return null;
        }
        return OTModelManager.getOTElement(anchorType);
    }

    IType resolveInType(IOTType referenceType, String type) throws JavaModelException {
        String[][] qualifiedTypes;
        String[][] stringArray;
        IJavaElement iJavaElement;
        if (type.equals(this.getElementName()) && (iJavaElement = referenceType.getParent()) instanceof IType) {
            IType parentType = (IType)iJavaElement;
            stringArray = parentType.resolveType(type);
        } else {
            stringArray = qualifiedTypes = referenceType.resolveType(type);
        }
        if (qualifiedTypes != null && qualifiedTypes.length == 1) {
            String fqBaseName = Util.concatenateName(qualifiedTypes[0][0], qualifiedTypes[0][1], '.');
            return referenceType.getJavaProject().findType(fqBaseName);
        }
        return null;
    }

    @Override
    public IType[] getTSuperRoles() throws JavaModelException {
        int n;
        ArrayList<IType> tsuperRoles = new ArrayList<IType>();
        IOTType teamType = this.getTeam();
        if (teamType == null) {
            throw new JavaModelException(new JavaModelStatus(4, "Enclosing team not found for " + this.getElementName() + " perhaps this element is not on the build path?"));
        }
        String superteamName = teamType.getSuperclassName();
        if (superteamName != null) {
            if (superteamName.indexOf(46) != -1) {
                IType tsuperRole;
                IType superTeam = this.getJavaProject().findType(superteamName);
                if (superTeam != null && (tsuperRole = superTeam.getType(this.getElementName())) != null && tsuperRole.exists()) {
                    this.flags |= 0x80000;
                    tsuperRoles.add(tsuperRole);
                }
            } else {
                String[][] resolvedSuperTeams = teamType.resolveType(superteamName);
                if (resolvedSuperTeams != null) {
                    String[][] stringArray = resolvedSuperTeams;
                    int n2 = resolvedSuperTeams.length;
                    n = 0;
                    while (n < n2) {
                        String[] resolvedSuperTeam = stringArray[n];
                        this.checkAddTSuperRole(resolvedSuperTeam[0] + "." + resolvedSuperTeam[1], tsuperRoles);
                        ++n;
                    }
                }
            }
        }
        if (teamType.isRole()) {
            IType[] iTypeArray = ((IRoleType)teamType).getTSuperRoles();
            n = iTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IType tsuperTeam = iTypeArray[n3];
                this.checkAddTSuperRole(tsuperTeam.getFullyQualifiedName('.'), tsuperRoles);
                ++n3;
            }
        }
        return tsuperRoles.toArray(new IType[tsuperRoles.size()]);
    }

    private void checkAddTSuperRole(String qualifiedTeamName, ArrayList<IType> tsuperRoles) throws JavaModelException {
        IType tsuperRole = this.getJavaProject().findType(qualifiedTeamName + "." + this.getElementName());
        if (tsuperRole != null) {
            this.flags |= 0x80000;
            tsuperRoles.add(tsuperRole);
        }
    }
}

