/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticOTTargetMethod;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class SyntheticRoleFieldAccess
extends SyntheticOTTargetMethod {
    static final char[] FIELD_GET_NAME = "_fieldget_".toCharArray();
    static final char[] FIELD_GET_PREFIX = CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, FIELD_GET_NAME);
    static final char[] FIELD_SET_NAME = "_fieldset_".toCharArray();
    static final char[] FIELD_SET_PREFIX = CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, FIELD_SET_NAME);
    char[] encodedFieldName;

    public SyntheticRoleFieldAccess(FieldBinding targetField, boolean isReadAccess, SourceTypeBinding declaringClass) {
        super(targetField, isReadAccess, false, declaringClass);
        FieldDeclaration sourceField;
        if (targetField.declaringClass instanceof SourceTypeBinding && ((SourceTypeBinding)targetField.declaringClass).scope != null && (sourceField = targetField.sourceField()) != null) {
            this.sourceStart = sourceField.sourceStart;
            this.retrieveLineNumber(declaringClass);
        }
        this.modifiers &= 0xFFFFFFF7;
        this.selector = CharOperation.concatWith(isReadAccess ? FIELD_GET_PREFIX : FIELD_SET_PREFIX, new char[][]{targetField.declaringClass.sourceName(), targetField.name}, '$');
    }

    public SyntheticRoleFieldAccess(BinaryTypeBinding declaringClass, int modifiers, char[] selector, TypeBinding[] parameters, TypeBinding returnType) {
        super(declaringClass, modifiers, selector, parameters, returnType);
        this.purpose = CharOperation.prefixEquals(FIELD_GET_PREFIX, selector) ? 1 : 2;
    }

    @Override
    protected TypeBinding getReceiverParameterType(FieldBinding targetField, ReferenceBinding declaringSourceType) {
        ReferenceBinding targetDeclaringClass;
        if (!targetField.isStatic() && (targetDeclaringClass = targetField.declaringClass).isRole()) {
            if (!TeamModel.isTeamContainingRole(declaringSourceType, targetDeclaringClass)) {
                throw new InternalCompilerError("synth accessor created in wrong scope");
            }
            targetDeclaringClass = (ReferenceBinding)TeamModel.strengthenRoleType(declaringSourceType, targetDeclaringClass);
            return targetDeclaringClass.getRealType();
        }
        return declaringSourceType.getRealType();
    }

    public FieldBinding resolvedField() {
        VariableBinding variableBinding = this.targetReadField;
        if (variableBinding instanceof FieldBinding) {
            FieldBinding readField = (FieldBinding)variableBinding;
            return readField;
        }
        if (this.targetWriteField != null) {
            return this.targetWriteField;
        }
        char[][] splitName = CharOperation.splitOn('$', this.selector);
        ReferenceBinding roleType = this.declaringClass.getMemberType(splitName[2]);
        FieldBinding field = roleType.getRealClass().getField(splitName[3], true);
        if (!(field != null || (field = roleType.getRealType().getField(splitName[3], true)) != null && field.isStatic())) {
            field = new ProblemFieldBinding(roleType, splitName[3], 1);
        }
        if (CharOperation.equals(FIELD_GET_NAME, splitName[1])) {
            this.targetReadField = field;
            this.purpose = 1;
        } else {
            this.targetWriteField = field;
            this.purpose = 2;
        }
        return field;
    }

    public void resolveTypes() {
        LookupEnvironment env;
        try {
            env = Config.getLookupEnvironment();
        }
        catch (Config.NotConfiguredException e) {
            e.logWarning("Cannot resolve types");
            return;
        }
        int i = 0;
        while (i < this.parameters.length) {
            TypeBinding param = this.parameters[i];
            if (param instanceof UnresolvedReferenceBinding) {
                this.parameters[i] = ((UnresolvedReferenceBinding)param).resolve(env, false);
            }
            ++i;
        }
        if (this.returnType instanceof UnresolvedReferenceBinding) {
            this.returnType = ((UnresolvedReferenceBinding)this.returnType).resolve(env, false);
        }
    }

    public void generateBodyForRead(FieldBinding fieldBinding, CodeStream codeStream) {
        if (fieldBinding.isStatic()) {
            fieldBinding = this.checkAdjustRoleFieldAccess(fieldBinding, codeStream);
            codeStream.fieldAccess((byte)-78, fieldBinding, fieldBinding.declaringClass);
        } else {
            LocalVariableBinding thisArg = this.createArgumentBinding(codeStream, "this".toCharArray(), fieldBinding.declaringClass.enclosingType(), 0);
            char[] argName = this.typeNameToLower(this.parameters[0].sourceName());
            LocalVariableBinding arg1 = this.createArgumentBinding(codeStream, argName, this.parameters[0], 1);
            codeStream.aload_1();
            fieldBinding = this.checkAdjustRoleFieldAccess(fieldBinding, codeStream);
            codeStream.fieldAccess((byte)-76, fieldBinding, fieldBinding.declaringClass);
            if ((codeStream.generateAttributes & 0xC) == 0) {
                return;
            }
            thisArg.recordInitializationEndPC(codeStream.position);
            arg1.recordInitializationEndPC(codeStream.position);
        }
    }

    private char[] typeNameToLower(char[] typeName) {
        int len = typeName.length;
        char[] newName = new char[len];
        System.arraycopy(typeName, 0, newName, 0, len);
        newName[0] = Character.toLowerCase(typeName[0]);
        return newName;
    }

    private LocalVariableBinding createArgumentBinding(CodeStream codeStream, char[] argName, TypeBinding argType, int pos) {
        LocalVariableBinding argBinding = new LocalVariableBinding(argName, argType, 0, true);
        argBinding.resolvedPosition = pos;
        argBinding.declaration = new Argument(argName, 0L, null, 0);
        codeStream.addVisibleLocalVariable(argBinding);
        codeStream.record(argBinding);
        argBinding.recordInitializationStartPC(0);
        return argBinding;
    }

    public void generateBodyForWrite(FieldBinding fieldBinding, CodeStream codeStream) {
        if (fieldBinding.isStatic()) {
            fieldBinding = this.checkAdjustRoleFieldAccess(fieldBinding, codeStream);
            codeStream.load(fieldBinding.type, 1);
            codeStream.fieldAccess((byte)-77, fieldBinding, fieldBinding.declaringClass);
        } else {
            LocalVariableBinding thisArg = this.createArgumentBinding(codeStream, "this".toCharArray(), fieldBinding.declaringClass.enclosingType(), 0);
            char[] argName = this.typeNameToLower(this.parameters[0].sourceName());
            LocalVariableBinding arg1 = this.createArgumentBinding(codeStream, argName, this.parameters[0], 1);
            LocalVariableBinding arg2 = this.createArgumentBinding(codeStream, "value".toCharArray(), this.parameters[1], 2);
            codeStream.aload_1();
            fieldBinding = this.checkAdjustRoleFieldAccess(fieldBinding, codeStream);
            codeStream.load(fieldBinding.type, 2);
            codeStream.fieldAccess((byte)-75, fieldBinding, fieldBinding.declaringClass);
            if ((codeStream.generateAttributes & 0xC) == 0) {
                return;
            }
            thisArg.recordInitializationEndPC(codeStream.position);
            arg1.recordInitializationEndPC(codeStream.position);
            arg2.recordInitializationEndPC(codeStream.position);
        }
    }

    private FieldBinding checkAdjustRoleFieldAccess(FieldBinding fieldBinding, CodeStream codeStream) {
        if (fieldBinding.declaringClass.isRole() && !fieldBinding.declaringClass.isInterface()) {
            ReferenceBinding roleType = fieldBinding.declaringClass;
            roleType = (ReferenceBinding)TeamModel.strengthenRoleType(this.declaringClass, roleType);
            roleType = roleType.getRealClass();
            if (!fieldBinding.isStatic()) {
                codeStream.checkcast(roleType);
            }
            fieldBinding = new FieldBinding(fieldBinding, roleType);
        }
        return fieldBinding;
    }

    @Override
    public byte prepareOrGenerateInvocation(CodeStream codeStream, byte opcode) {
        ReferenceBinding roleType = (ReferenceBinding)this.parameters[0];
        if (roleType instanceof UnresolvedReferenceBinding) {
            try {
                roleType = ((UnresolvedReferenceBinding)roleType).resolve(Config.getLookupEnvironment(), false);
            }
            catch (Config.NotConfiguredException e) {
                e.logWarning("Failed to generate accessor");
                return opcode;
            }
            this.parameters[0] = roleType;
        }
        if (this.purpose == 1 || this.purpose == 3) {
            this.insertOuterAccess(codeStream, roleType);
            codeStream.swap();
            codeStream.invoke((byte)-74, this, this.declaringClass);
        } else {
            TypeBinding targetType = this.targetWriteField.type;
            LocalVariableBinding arg = new LocalVariableBinding("<tmp>".toCharArray(), targetType, 0, false);
            arg.resolvedPosition = codeStream.maxLocals;
            arg.useFlag = 1;
            codeStream.record(arg);
            arg.recordInitializationStartPC(codeStream.position);
            codeStream.store(arg, false);
            this.insertOuterAccess(codeStream, roleType);
            codeStream.swap();
            codeStream.load(arg);
            codeStream.invoke((byte)-74, this, this.declaringClass);
            if (arg.initializationPCs != null) {
                arg.recordInitializationEndPC(codeStream.position);
            }
        }
        return 0;
    }

    private void insertOuterAccess(CodeStream codeStream, ReferenceBinding roleType) {
        codeStream.dup();
        codeStream.invokeGetTeam(roleType);
        codeStream.checkcast(this.declaringClass);
    }

    public static boolean isRoleFieldAccess(int modifiers, char[] selector) {
        if ((modifiers & 0x1000) == 0) {
            return false;
        }
        if (CharOperation.prefixEquals(FIELD_GET_PREFIX, selector)) {
            return true;
        }
        return CharOperation.prefixEquals(FIELD_SET_PREFIX, selector);
    }

    public static ReferenceBinding getTeamOfRoleField(FieldBinding targetField) {
        if (!targetField.declaringClass.isRole()) {
            return null;
        }
        if (targetField.isSynthetic()) {
            return null;
        }
        return targetField.declaringClass.enclosingType();
    }

    public static @Nullable SyntheticMethodBinding getAccessorFor(ReferenceBinding enclosingTeam, FieldBinding targetField, boolean isReadAccess, boolean externalizedReceiver) {
        if (enclosingTeam.isBinaryBinding()) {
            MethodBinding[] methodBindingArray = enclosingTeam.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding method = methodBindingArray[n2];
                if (SyntheticRoleFieldAccess.isAccessFor(method, targetField, isReadAccess)) {
                    return (SyntheticMethodBinding)method;
                }
                ++n2;
            }
            return null;
        }
        SourceTypeBinding outerSrc = (SourceTypeBinding)enclosingTeam;
        return outerSrc.addSyntheticMethod(targetField, isReadAccess, false, externalizedReceiver);
    }

    private static boolean isAccessFor(MethodBinding method, FieldBinding targetField, boolean isReadAccess) {
        if (!(method instanceof SyntheticRoleFieldAccess)) {
            return false;
        }
        SyntheticRoleFieldAccess accessor = (SyntheticRoleFieldAccess)method;
        if (accessor.resolvedField() != targetField) {
            return false;
        }
        return isReadAccess ? accessor.purpose == 1 : accessor.purpose == 2;
    }
}

