/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.launching;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.DebugMessages;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.OTDebugAdaptorPlugin;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.launching.TeamConfig;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OTLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private List<IType> _teamsModel = new ArrayList<IType>();
    private TeamConfig _teamConfig;
    private IProject _project = null;
    static final List<String> EMPTY_LIST = new ArrayList<String>(0);

    public void createControl(Composite parent) {
        this._teamConfig = new TeamConfig(parent, 0, this);
        this.setControl((Control)this._teamConfig);
        this.setMessage(OTDTUIPlugin.getResourceString((String)"TeamConfig.cannot_instantiate_message"));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this._teamsModel.clear();
        List teamHandles = new LinkedList();
        boolean teamsActive = true;
        try {
            teamHandles = configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ATTR", teamHandles);
            teamsActive = configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ACTIVE_ATTR", true);
        }
        catch (CoreException ce) {
            OTDTUIPlugin.logException((String)"Cannot read team configuration", (Throwable)ce);
        }
        this._teamConfig.clearTeamList();
        LinkedList<String> badTeams = new LinkedList<String>();
        for (String teamHandle : teamHandles) {
            IType type = (IType)JavaCore.create((String)teamHandle);
            if (type != null) {
                IOTType otType;
                if (type.exists() && (otType = OTModelManager.getOTElement((IType)type)) != null) {
                    this._teamsModel.add((IType)otType);
                    continue;
                }
                badTeams.add(type.getFullyQualifiedName());
                continue;
            }
            badTeams.add(teamHandle);
        }
        this.reportBadTeams(badTeams);
        this._teamConfig.setActive(teamsActive);
        this._teamConfig.setTeamInput(this._teamsModel);
        this._teamConfig.checkEnablement();
        String projectName = this.getProjectFromConfig(configuration);
        this._project = projectName.length() != 0 ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
    }

    private void reportBadTeams(List<String> badTeams) {
        if (!badTeams.isEmpty()) {
            StringBuffer message = new StringBuffer(OTDTUIPlugin.getResourceString((String)"TeamConfig.not_found_message"));
            for (String badTeam : badTeams) {
                message.append(badTeam + "\n");
            }
            this.setModified();
            this.setErrorMessage(message.toString());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.removeUnavailableTeamsErrorMessage();
        List<String> teamHandles = this.getTeamModelAsHandles();
        try {
            if (configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ACTIVE_ATTR", true) != this._teamConfig.isTeamConfigActive()) {
                configuration.setAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ACTIVE_ATTR", this._teamConfig.isTeamConfigActive());
            }
            if (!configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ATTR", EMPTY_LIST).equals(teamHandles)) {
                configuration.setAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ATTR", teamHandles);
            }
        }
        catch (CoreException ex) {
            OTDebugAdaptorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.debug.adaptor", DebugMessages.OTLaunching_loading_failed_msg, (Throwable)ex));
        }
    }

    private void removeUnavailableTeamsErrorMessage() {
        this.setErrorMessage(null);
        this.getLaunchConfigurationDialog().updateMessage();
    }

    public String getName() {
        return OTDTUIPlugin.getResourceString((String)"TeamConfig.tab_title");
    }

    public Image getImage() {
        return ImageManager.getSharedInstance().get("team_obj.gif");
    }

    public void setModified() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private String getProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            OTDTUIPlugin.logException((String)"Unable to retrieve _project from launch configuration", (Throwable)ce);
        }
        return projectName;
    }

    public IProject getProject() {
        return this._project;
    }

    public List<IType> getTeamsModel() {
        return this._teamsModel;
    }

    private List<String> getTeamModelAsHandles() {
        LinkedList<String> teamHandles = new LinkedList<String>();
        for (IType type : this._teamsModel) {
            teamHandles.add(type.getHandleIdentifier());
        }
        return teamHandles;
    }

    public IRunnableContext getRunnableContext() {
        return this.getLaunchConfigurationDialog();
    }
}

