/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.AccessRightAnnc;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class AccessRightAnncController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        AccessRightAnnc accessRightAnnc = null;
        try {
            accessRightAnnc = (AccessRightAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (accessRightAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (accessRightAnnc.getId() != null && DAOFactory.getApplicationAnncDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + accessRightAnnc.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ApplicationAnncId Conflit"));
        }
        if (accessRightAnnc.getId() == null || accessRightAnnc.getId().isEmpty()) {
            accessRightAnnc.setId(AccessRightAnncController.generateId("AR_", "Annc"));
        }
        if (accessRightAnnc.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute CREATE is Mandatory"));
        }
        if (accessRightAnnc.getLink() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute is Mandatory"));
        }
        if (accessRightAnnc.getExpirationTime() != null && !this.checkExpirationTime(accessRightAnnc.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is Out of Date"));
        }
        accessRightAnnc.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + accessRightAnnc.getId());
        if (accessRightAnnc.getExpirationTime() == null) {
            accessRightAnnc.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(accessRightAnnc.getAccessRightID(), em) == null) {
            accessRightAnnc.setAccessRightID(accessRightID);
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)accessRightAnnc);
        DAOFactory.getAccessRightAnncDAO().create(accessRightAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)accessRightAnnc);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRightAnnc accessRightAnnc = DAOFactory.getAccessRightAnncDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (accessRightAnnc == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(accessRightAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)accessRightAnnc);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRightAnnc accessRightAnnc = DAOFactory.getAccessRightAnncDAO().find(requestIndication.getTargetID(), em);
        if (accessRightAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(accessRightAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        AccessRightAnnc accessRightAnncNew = null;
        try {
            accessRightAnncNew = (AccessRightAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (accessRightAnncNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (accessRightAnncNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ContainerAnncId UPDATE is Not Permitted"));
        }
        if (accessRightAnncNew.getExpirationTime() != null && !this.checkExpirationTime(accessRightAnncNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (accessRightAnncNew.getLink() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute UPDATE is Mandatory"));
        }
        if (accessRightAnncNew.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute UPDATE is Mandatory"));
        }
        if (accessRightAnncNew.getExpirationTime() != null) {
            accessRightAnnc.setExpirationTime(accessRightAnncNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(accessRightAnncNew.getAccessRightID(), em) != null) {
            accessRightAnnc.setAccessRightID(accessRightAnncNew.getAccessRightID());
        }
        accessRightAnnc.setSearchStrings(accessRightAnncNew.getSearchStrings());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)accessRightAnnc);
        DAOFactory.getAccessRightAnncDAO().update(accessRightAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)accessRightAnnc);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRightAnnc accessRightAnnc = DAOFactory.getAccessRightAnncDAO().find(requestIndication.getTargetID(), em);
        if (accessRightAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)accessRightAnnc);
        DAOFactory.getAccessRightAnncDAO().delete(accessRightAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

