/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.rest;

import java.util.List;
import java.util.Map;
import org.eclipse.om2m.commons.resource.Notify;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.utils.XmlMapper;

public class RequestIndication {
    private String method;
    private String protocol;
    private String base;
    private String targetID;
    private String representation;
    private String requestingEntity;
    private Map<String, List<String>> parameters;

    public RequestIndication() {
    }

    public RequestIndication(String method, String targetID, String requestingEntity, String representation) {
        this.method = method;
        this.targetID = targetID;
        this.representation = representation;
        this.requestingEntity = requestingEntity;
    }

    public RequestIndication(String method, String targetID, String requestingEntity, Resource resource) {
        this.method = method;
        this.targetID = targetID;
        this.representation = XmlMapper.getInstance().objectToXml(resource);
        this.requestingEntity = requestingEntity;
    }

    public RequestIndication(String method, String targetID, String requestingEntity) {
        this.method = method;
        this.targetID = targetID;
        this.requestingEntity = requestingEntity;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestingEntity() {
        return this.requestingEntity;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public void setTargetID(String targetID) {
        this.targetID = targetID;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public void setRepresentation(Resource resource) {
        this.representation = XmlMapper.getInstance().objectToXml(resource);
    }

    public void setRepresentation(Notify notify) {
        this.representation = XmlMapper.getInstance().objectToXml(notify);
    }

    public String getUrl() {
        return String.valueOf(this.base) + this.targetID;
    }

    public void setRequestingEntity(String requestingEntity) {
        this.requestingEntity = requestingEntity;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "RequestIndication [method=" + this.method + ", base=" + this.base + ", targetID=" + this.targetID + ", representation=" + this.representation + ", requestingEntity=" + this.requestingEntity + ", protocol=" + this.protocol + "]";
    }
}

