/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.resource;

import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.eclipse.om2m.commons.resource.APoCPath;
import org.eclipse.om2m.commons.resource.APoCPaths;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.Resource;

@Entity(name="APPLICATION")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Application
extends Resource {
    @XmlSchemaType(name="dateTime")
    protected String expirationTime;
    @XmlSchemaType(name="dateTime")
    protected String creationTime;
    @XmlSchemaType(name="dateTime")
    protected String lastModifiedTime;
    @Embedded
    protected AnnounceTo announceTo;
    @XmlSchemaType(name="anyURI")
    protected String aPoC;
    @OneToOne(cascade={CascadeType.ALL})
    protected APoCPaths aPoCPaths;
    @XmlSchemaType(name="anySimpleType")
    @Transient
    protected Object locRequestor;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String containersReference;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String groupsReference;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String accessRightsReference;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String subscriptionsReference;
    @XmlSchemaType(name="anyURI")
    @Transient
    protected String notificationChannelsReference;
    @XmlAttribute(name="appId")
    @XmlSchemaType(name="anyURI")
    protected String appId;

    public Application() {
    }

    public Application(String appId) {
        this.appId = appId;
    }

    public Application(String appId, String aPoCPath) {
        this.appId = appId;
        this.aPoCPaths = new APoCPaths();
        this.aPoCPaths.getAPoCPath().add(new APoCPath(aPoCPath));
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String value) {
        this.expirationTime = value;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String value) {
        this.creationTime = value;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String value) {
        this.lastModifiedTime = value;
    }

    public AnnounceTo getAnnounceTo() {
        return this.announceTo;
    }

    public void setAnnounceTo(AnnounceTo value) {
        this.announceTo = value;
    }

    public String getAPoC() {
        return this.aPoC;
    }

    public void setAPoC(String value) {
        this.aPoC = value;
    }

    public APoCPaths getAPoCPaths() {
        return this.aPoCPaths;
    }

    public void setAPoCPaths(APoCPaths value) {
        this.aPoCPaths = value;
    }

    public Object getLocRequestor() {
        return this.locRequestor;
    }

    public void setLocRequestor(Object value) {
        this.locRequestor = value;
    }

    public String getContainersReference() {
        if (this.containersReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/containers";
        }
        return this.containersReference;
    }

    public void setContainersReference(String value) {
        this.containersReference = value;
    }

    public String getGroupsReference() {
        if (this.groupsReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/groups";
        }
        return this.groupsReference;
    }

    public void setGroupsReference(String value) {
        this.groupsReference = value;
    }

    public String getAccessRightsReference() {
        if (this.accessRightsReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/accessRights";
        }
        return this.accessRightsReference;
    }

    public void setAccessRightsReference(String value) {
        this.accessRightsReference = value;
    }

    public String getSubscriptionsReference() {
        if (this.subscriptionsReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/subscriptions";
        }
        return this.subscriptionsReference;
    }

    public void setSubscriptionsReference(String value) {
        this.subscriptionsReference = value;
    }

    public String getNotificationChannelsReference() {
        if (this.notificationChannelsReference == null && this.uri != null) {
            return String.valueOf(this.uri) + "/notificationChannels";
        }
        return this.subscriptionsReference;
    }

    public void setNotificationChannelsReference(String value) {
        this.notificationChannelsReference = value;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String value) {
        this.appId = value;
    }

    public String toString() {
        return "Application [expirationTime=" + this.expirationTime + ", accessRightID=" + this.accessRightID + ", searchStrings=" + this.searchStrings + ", creationTime=" + this.creationTime + ", lastModifiedTime=" + this.lastModifiedTime + ", announceTo=" + this.announceTo + ", aPoC=" + this.aPoC + ", aPoCPaths=" + this.aPoCPaths + ", locRequestor=" + this.locRequestor + ", containersReference=" + this.containersReference + ", groupsReference=" + this.groupsReference + ", accessRightsReference=" + this.accessRightsReference + ", subscriptionsReference=" + this.subscriptionsReference + ", notificationChannelsReference=" + this.notificationChannelsReference + ", appId=" + this.appId + ", uri=";
    }
}

