/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstances;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;

public class ContentInstancesController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ContentInstances contentInstances = DAOFactory.getContentInstancesDAO().find(requestIndication.getTargetID(), em);
        if (contentInstances == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID().split("/contentInstances")[0], em);
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        em.close();
        if (errorResponse != null) {
            return errorResponse;
        }
        contentInstances.setSubscriptionsReference(String.valueOf(contentInstances.getUri()) + "/subscriptions");
        String xmlContentInstances = XmlMapper.getInstance().objectToXml((Object)contentInstances);
        contentInstances.getContentInstanceCollection().getContentInstance().clear();
        return new ResponseConfirm(StatusCode.STATUS_OK, xmlContentInstances);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implmented"));
    }
}

