/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.APoCPath;
import org.eclipse.om2m.commons.resource.Application;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.ipu.service.IpuService;

public class InterworkingProxyController
extends Controller {
    private static Map<String, IpuService> ipUnits = new HashMap<String, IpuService>();

    public static Map<String, IpuService> getIpUnits() {
        return ipUnits;
    }

    public static void setIpUnits(Map<String, IpuService> ipUnits) {
        InterworkingProxyController.ipUnits = ipUnits;
    }

    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        String sclId = requestIndication.getTargetID().split("/")[0];
        String applicationId = requestIndication.getTargetID().split("/")[2];
        String path = requestIndication.getTargetID().split("/")[3];
        String applicationUri = String.valueOf(sclId) + "/applications" + "/" + applicationId;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(applicationUri, em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(applicationUri) + " does not exist"));
        }
        APoCPath aPoCPath = this.checkAPoCPathExistence(application, path);
        if (aPoCPath == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(path) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(aPoCPath.getAccessRightID(), requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            if (ipUnits.containsKey(aPoCPath.getPath())) {
                return ipUnits.get(aPoCPath.getPath()).doCreate(requestIndication);
            }
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "No IPU found for path " + aPoCPath.getPath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Internal Exception", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "IPU Internal Exception"));
        }
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        String sclId = requestIndication.getTargetID().split("/")[0];
        String applicationId = requestIndication.getTargetID().split("/")[2];
        String path = requestIndication.getTargetID().split("/")[3];
        String applicationUri = String.valueOf(sclId) + "/applications" + "/" + applicationId;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(applicationUri, em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(applicationUri) + " does not exist"));
        }
        APoCPath aPoCPath = this.checkAPoCPathExistence(application, path);
        if (aPoCPath == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(path) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(aPoCPath.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            if (ipUnits.containsKey(aPoCPath.getPath())) {
                return ipUnits.get(aPoCPath.getPath()).doRetrieve(requestIndication);
            }
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "No IPU found for path " + aPoCPath.getPath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Internal Exception", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "IPU Internal Exception"));
        }
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        String sclId = requestIndication.getTargetID().split("/")[0];
        String applicationId = requestIndication.getTargetID().split("/")[2];
        String path = requestIndication.getTargetID().split("/")[3];
        String applicationUri = String.valueOf(sclId) + "/applications" + "/" + applicationId;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(applicationUri, em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(applicationUri) + " does not exist"));
        }
        APoCPath aPoCPath = this.checkAPoCPathExistence(application, path);
        if (aPoCPath == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(path) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(aPoCPath.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            if (ipUnits.containsKey(aPoCPath.getPath())) {
                return ipUnits.get(aPoCPath.getPath()).doUpdate(requestIndication);
            }
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "No IPU found for path " + aPoCPath.getPath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Internal Exception", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "IPU Internal Exception"));
        }
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        String sclId = requestIndication.getTargetID().split("/")[0];
        String applicationId = requestIndication.getTargetID().split("/")[2];
        String path = requestIndication.getTargetID().split("/")[3];
        String applicationUri = String.valueOf(sclId) + "/applications" + "/" + applicationId;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(applicationUri, em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(applicationUri) + " does not exist"));
        }
        APoCPath aPoCPath = this.checkAPoCPathExistence(application, path);
        if (aPoCPath == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(path) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(aPoCPath.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            if (ipUnits.containsKey(aPoCPath.getPath())) {
                return ipUnits.get(aPoCPath.getPath()).doDelete(requestIndication);
            }
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "No IPU found for path " + aPoCPath.getPath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Internal Exception", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "IPU Internal Exception"));
        }
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        String sclId = requestIndication.getTargetID().split("/")[0];
        String applicationId = requestIndication.getTargetID().split("/")[2];
        String path = requestIndication.getTargetID().split("/")[3];
        String applicationUri = String.valueOf(sclId) + "/applications" + "/" + applicationId;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(applicationUri, em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(applicationUri) + " does not exist"));
        }
        APoCPath aPoCPath = this.checkAPoCPathExistence(application, path);
        if (aPoCPath == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(path) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(aPoCPath.getAccessRightID(), requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            if (ipUnits.containsKey(aPoCPath.getPath())) {
                return ipUnits.get(aPoCPath.getPath()).doExecute(requestIndication);
            }
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "No IPU found for path " + aPoCPath.getPath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Internal Exception", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "IPU Internal Exception"));
        }
    }

    public APoCPath checkAPoCPathExistence(Application application, String path) {
        if (application.getAPoCPaths() != null) {
            int i = 0;
            while (i < application.getAPoCPaths().getAPoCPath().size()) {
                if (((APoCPath)application.getAPoCPaths().getAPoCPath().get(i)).getPath().equalsIgnoreCase(path)) {
                    return (APoCPath)application.getAPoCPaths().getAPoCPath().get(i);
                }
                ++i;
            }
        }
        return null;
    }
}

