/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.AttachedDevice;
import org.eclipse.om2m.commons.resource.AttachedDevices;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class AttachedDevicesDAO
extends DAO<AttachedDevices> {
    @Override
    public void create(AttachedDevices resource, EntityManager em) {
    }

    @Override
    public AttachedDevices find(String uri, EntityManager em) {
        AttachedDevices attachedDevices = new AttachedDevices();
        attachedDevices.setUri(uri);
        attachedDevices.getAttachedDeviceCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("ATTACHEDDEVICE", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (AttachedDevice ad : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(ad.getId());
            ref.setValue(ad.getUri());
            attachedDevices.getAttachedDeviceCollection().getNamedReference().add(ref);
        }
        return attachedDevices;
    }

    @Override
    public void update(AttachedDevices resource, EntityManager em) {
    }

    @Override
    public void delete(AttachedDevices resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("ATTACHEDDEVICE", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (AttachedDevice ad : result) {
            ad.setMgmtObjsReference(String.valueOf(ad.getUri()) + "/mgmtObjs");
            ad.setSubscriptionsReference(String.valueOf(ad.getUri()) + "/subscriptions");
            DAOFactory.getAttachedDeviceDAO().delete(ad, em);
        }
    }
}

