/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.datamapping.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.datamapping.service.DataMapperService;

public class Mapper
implements DataMapperService {
    private static Log LOGGER = LogFactory.getLog(Mapper.class);
    private JAXBContext context;
    private String resourcePackage = "org.eclipse.om2m.commons.resource";
    private String mediaType;

    public Mapper(String mediaType) {
        this.mediaType = mediaType;
        try {
            if (this.context == null) {
                if (mediaType.equals("application/json")) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    InputStream iStream = classLoader.getResourceAsStream("json-binding.xml");
                    HashMap<String, InputStream> properties = new HashMap<String, InputStream>();
                    properties.put("eclipselink.oxm.metadata-source", iStream);
                    this.context = JAXBContext.newInstance((String)this.resourcePackage, (ClassLoader)classLoader, properties);
                } else {
                    this.context = JAXBContext.newInstance((String)this.resourcePackage);
                }
            }
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Create JAXBContext error", (Throwable)e);
        }
    }

    public String objToString(Object obj) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            marshaller.setProperty("eclipselink.media-type", (Object)this.mediaType);
            marshaller.setProperty("eclipselink.json.include-root", (Object)true);
            marshaller.marshal(obj, (OutputStream)outputStream);
            return ((Object)outputStream).toString();
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"JAXB marshalling error!", (Throwable)e);
            return null;
        }
    }

    public Object stringToObj(String representation) {
        if (representation.isEmpty()) {
            return null;
        }
        StringReader stringReader = new StringReader(representation);
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)this.mediaType);
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)true);
            return unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"JAXB unmarshalling error!", (Throwable)e);
            return null;
        }
    }

    public String getServiceDataType() {
        return this.mediaType;
    }
}

