/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.redirector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.controller.AEController;
import org.eclipse.om2m.core.interworking.IpeSelector;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class Redirector {
    private static Log LOGGER = LogFactory.getLog(Redirector.class);

    public static ResponsePrimitive retarget(RequestPrimitive request) {
        String remoteCseId = "";
        ResponsePrimitive response = new ResponsePrimitive(request);
        try {
            remoteCseId = "/" + request.getTargetId().split("/")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.debug((Object)"Remote cse not found", (Throwable)e);
            throw new ResourceNotFoundException("Remote cse not found", (Throwable)e);
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        DAO dao = dbs.getDAOFactory().getRemoteCSEbyCseIdDAO();
        RemoteCSEEntity csrEntity = (RemoteCSEEntity)dao.find(transaction, (Object)remoteCseId);
        if (csrEntity != null) {
            LOGGER.info((Object)("RemoteCSE found: " + csrEntity.getRemoteCseId()));
            response = Redirector.sendRedirectorRequest(request, csrEntity, transaction);
        } else if (!Constants.CSE_TYPE.equalsIgnoreCase("in-cse")) {
            LOGGER.info((Object)("Unknow CSE, sending request to registrar CSE: " + Constants.REMOTE_CSE_ID));
            csrEntity = (RemoteCSEEntity)dao.find(transaction, (Object)("/" + Constants.REMOTE_CSE_ID));
            response = Redirector.sendRedirectorRequest(request, csrEntity, transaction);
        } else {
            throw new ResourceNotFoundException("RemoteCse with cseId " + remoteCseId + " has not been found");
        }
        transaction.close();
        return response;
    }

    private static ResponsePrimitive sendRedirectorRequest(RequestPrimitive request, RemoteCSEEntity csrEntity, DBTransaction transaction) {
        if (!csrEntity.isRequestReachability()) {
            throw new Om2mException("Remote Cse is not request reachable", ResponseStatusCode.TARGET_NOT_REACHABLE);
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        String url = "";
        if (!csrEntity.getPointOfAccess().isEmpty()) {
            ResponsePrimitive response;
            boolean done = false;
            int i = 0;
            while (!done & i < csrEntity.getPointOfAccess().size()) {
                url = (String)csrEntity.getPointOfAccess().get(i);
                if (url.endsWith("/")) {
                    LOGGER.debug((Object)("Removing / at the end of poa: " + url));
                    url = url.substring(0, url.length() - 1);
                }
                url = request.getTo().startsWith("//") ? String.valueOf(url) + request.getTo().replaceFirst("//", "/_/") : (request.getTo().startsWith("/") ? String.valueOf(url) + request.getTo().replaceFirst("/", "/~/") : String.valueOf(url) + "/" + request.getTo());
                request.setTo(url);
                response = RestClient.sendRequest(request);
                if (!response.getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                    done = true;
                    if (i > 0) {
                        String poa = (String)csrEntity.getPointOfAccess().get(i);
                        csrEntity.getPointOfAccess().remove(i);
                        csrEntity.getPointOfAccess().add(0, poa);
                        dbs.getDAOFactory().getRemoteCSEDAO().update(transaction, (Object)csrEntity);
                        transaction.commit();
                    }
                    return response;
                }
                ++i;
            }
            response = new ResponsePrimitive(request);
            response.setResponseStatusCode(ResponseStatusCode.TARGET_NOT_REACHABLE);
            response.setContent((Object)"Target is not reachable");
            response.setContentType("text/plain");
            return response;
        }
        throw new Om2mException("The point of access parameter is missing", ResponseStatusCode.TARGET_NOT_REACHABLE);
    }

    public static ResponsePrimitive retargetNotify(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction dbt = dbs.getDbTransaction();
        dbt.open();
        AeEntity ae = (AeEntity)dbs.getDAOFactory().getAeDAO().find(dbt, (Object)request.getTargetId());
        if (ae == null) {
            dbt.close();
            throw new ResourceNotFoundException("AE resource " + request.getTargetId() + " not found.");
        }
        if (!request.getFrom().equals("/" + Constants.CSE_ID)) {
            new AEController().checkACP(ae.getAccessControlPolicies(), request.getFrom(), Operation.NOTIFY);
        }
        if (ae.getPointOfAccess().isEmpty() || !ae.isRequestReachable()) {
            throw new Om2mException("AE has no point of access", ResponseStatusCode.TARGET_NOT_REACHABLE);
        }
        boolean done = false;
        int i = 0;
        while (!done && i < ae.getPointOfAccess().size()) {
            String poa = (String)ae.getPointOfAccess().get(i);
            if (IpeSelector.getInterworkingList().containsKey(poa)) {
                try {
                    LOGGER.info((Object)("Sending notification to IPE: " + poa));
                    response = IpeSelector.getInterworkingList().get(poa).doExecute(request);
                }
                catch (Om2mException om2mE) {
                    LOGGER.info((Object)("Om2m exception caught in Redirector: " + om2mE.getMessage()));
                    throw om2mE;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception caught in IPE execution", (Throwable)e);
                    throw new Om2mException("IPE Internal Error", (Throwable)e, ResponseStatusCode.INTERNAL_SERVER_ERROR);
                }
                done = true;
            } else {
                request.setTo(poa);
                response = RestClient.sendRequest(request);
                if (!response.getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                    done = true;
                    if (i > 0) {
                        ae.getPointOfAccess().remove(i);
                        ae.getPointOfAccess().add(0, poa);
                        dbs.getDAOFactory().getAeDAO().update(dbt, (Object)ae);
                        dbt.commit();
                    }
                }
            }
            ++i;
        }
        dbt.close();
        return response;
    }
}

