/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="GRP")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class GroupEntity
extends AnnounceableSubordinateEntity {
    @Column(name="cr")
    protected String creator;
    @Column(name="mt", nullable=false)
    protected BigInteger memberType;
    @Column(name="mnm")
    protected BigInteger maxNrOfMembers;
    @Column(name="mid")
    protected List<String> memberIDs;
    @Column(name="macp")
    protected List<String> memberAcpIds;
    @Column(name="mtv")
    protected boolean memberTypeValidated;
    @Column(name="csy")
    protected BigInteger consistencyStrategy;
    @Column(name="gn")
    protected String groupName;
    @Column(name="fopt")
    protected String fanOutPoint;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="GRP_SUB_JOIN", joinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="GRP_ACP_JOIN", joinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSB_GRP_JOIN", joinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCseBase;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=AeEntity.class)
    @JoinTable(name="AE_CHGRP_JOIN", joinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")})
    protected AeEntity parentAe;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_GRP_JOIN", joinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentRemoteCse;

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public BigInteger getMemberType() {
        return this.memberType;
    }

    public void setMemberType(BigInteger memberType) {
        this.memberType = memberType;
    }

    public BigInteger getMaxNrOfMembers() {
        return this.maxNrOfMembers;
    }

    public void setMaxNrOfMembers(BigInteger maxNrOfMembers) {
        this.maxNrOfMembers = maxNrOfMembers;
    }

    public List<String> getMemberIDs() {
        if (this.memberIDs == null) {
            this.memberIDs = new ArrayList<String>();
        }
        return this.memberIDs;
    }

    public void setMemberIDs(List<String> memberIDs) {
        this.memberIDs = memberIDs;
    }

    public boolean isMemberTypeValidated() {
        return this.memberTypeValidated;
    }

    public void setMemberTypeValidated(boolean memberTypeValidated) {
        this.memberTypeValidated = memberTypeValidated;
    }

    public BigInteger getConsistencyStrategy() {
        return this.consistencyStrategy;
    }

    public void setConsistencyStrategy(BigInteger consistencyStrategy) {
        this.consistencyStrategy = consistencyStrategy;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getFanOutPoint() {
        return this.fanOutPoint;
    }

    public void setFanOutPoint(String fanOutPoint) {
        this.fanOutPoint = fanOutPoint;
    }

    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    public CSEBaseEntity getParentCseBase() {
        return this.parentCseBase;
    }

    public void setParentCseBase(CSEBaseEntity parentCseBase) {
        this.parentCseBase = parentCseBase;
    }

    public AeEntity getParentAe() {
        return this.parentAe;
    }

    public void setParentAe(AeEntity parentAe) {
        this.parentAe = parentAe;
    }

    public RemoteCSEEntity getParentRemoteCse() {
        return this.parentRemoteCse;
    }

    public void setParentRemoteCse(RemoteCSEEntity parentRemoteCse) {
        this.parentRemoteCse = parentRemoteCse;
    }

    public List<String> getMemberAcpIds() {
        if (this.memberAcpIds == null) {
            this.memberAcpIds = new ArrayList<String>();
        }
        return this.memberAcpIds;
    }

    public void setMemberAcpIds(List<String> memberAcpIds) {
        this.memberAcpIds = memberAcpIds;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }
}

