/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Entity(name="NODE")
public class NodeEntity
extends AnnounceableSubordinateEntity {
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="NOD_ACP_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> linkedAcps;
    @Column(name="ni")
    protected String nodeID;
    @Column(name="hcl")
    protected String hostedCSELink;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CSB_NOD_CH_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCsb;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CSR_NOD_CH_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="NOD_SUB_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> childSubscriptions;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ANI_NOD_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkInfoEntity> childAreaNwkInfoEntities;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="ANDI_NOD_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkDeviceInfoEntity> childAreaNwkDeviceInfoEntities;

    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.linkedAcps == null) {
            this.linkedAcps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.linkedAcps;
    }

    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.linkedAcps = accessControlPolicies;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public String getHostedCSELink() {
        return this.hostedCSELink;
    }

    public void setHostedCSELink(String hostedCSELink) {
        this.hostedCSELink = hostedCSELink;
    }

    public CSEBaseEntity getParentCsb() {
        return this.parentCsb;
    }

    public void setParentCsb(CSEBaseEntity parentCsb) {
        this.parentCsb = parentCsb;
    }

    public CSEBaseEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(CSEBaseEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<SubscriptionEntity> getChildSubscriptions() {
        return this.childSubscriptions;
    }

    public void setChildSubscriptions(List<SubscriptionEntity> childSubscriptions) {
        this.childSubscriptions = childSubscriptions;
    }

    public List<AreaNwkInfoEntity> getChildAreaNwkInfoEntities() {
        if (this.childAreaNwkInfoEntities == null) {
            this.childAreaNwkInfoEntities = new ArrayList<AreaNwkInfoEntity>();
        }
        return this.childAreaNwkInfoEntities;
    }

    public void setChildAreaNwkInfoEntities(List<AreaNwkInfoEntity> childAreaNwkInfoEntities) {
        this.childAreaNwkInfoEntities = childAreaNwkInfoEntities;
    }

    public List<AreaNwkDeviceInfoEntity> getChildAreaNwkDeviceInfoEntities() {
        return this.childAreaNwkDeviceInfoEntities;
    }

    public void setChildAreaNwkDeviceInfoEntities(List<AreaNwkDeviceInfoEntity> childAreaNwkDeviceInfoEntities) {
        this.childAreaNwkDeviceInfoEntities = childAreaNwkDeviceInfoEntities;
    }
}

