/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.RequestEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.CSEBase;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.Request;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.AeMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.RemoteCSEMapper;
import org.eclipse.om2m.core.entitymapper.RequestMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class CseBaseMapper
extends EntityMapper<CSEBaseEntity, CSEBase> {
    @Override
    protected CSEBase createResource() {
        return new CSEBase();
    }

    @Override
    protected void mapAttributes(CSEBaseEntity cseBaseEntity, CSEBase cseBaseResource) {
        cseBaseResource.setNodeLink(cseBaseEntity.getNodeLink());
        cseBaseResource.setCSEID(cseBaseEntity.getCseid());
        cseBaseResource.setCseType(cseBaseEntity.getCseType());
        for (BigInteger ty : cseBaseEntity.getSupportedResourceType()) {
            cseBaseResource.getSupportedResourceType().add(ty);
        }
        for (AccessControlPolicyEntity acp : cseBaseEntity.getAccessControlPolicies()) {
            cseBaseResource.getAccessControlPolicyIDs().add(acp.getResourceID());
        }
        if (!cseBaseEntity.getLabelsEntities().isEmpty()) {
            for (LabelEntity l : cseBaseEntity.getLabelsEntities()) {
                cseBaseResource.getLabels().add(l.getLabel());
            }
        }
        if (!cseBaseEntity.getPointOfAccess().isEmpty()) {
            cseBaseResource.getPointOfAccess().addAll(cseBaseEntity.getPointOfAccess());
        }
    }

    @Override
    protected void mapChildResourceRef(CSEBaseEntity cseBaseEntity, CSEBase cseBaseResource) {
        ChildResourceRef child;
        for (AccessControlPolicyEntity acp : cseBaseEntity.getChildAccessControlPolicies()) {
            child = new ChildResourceRef();
            child.setResourceName(acp.getName());
            child.setType(1);
            child.setValue(acp.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (AeEntity ae : cseBaseEntity.getAes()) {
            child = new ChildResourceRef();
            child.setResourceName(ae.getName());
            child.setType(2);
            child.setValue(ae.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (ContainerEntity cnt : cseBaseEntity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(cnt.getName());
            child.setType(3);
            child.setValue(cnt.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (RemoteCSEEntity csr : cseBaseEntity.getRemoteCses()) {
            child = new ChildResourceRef();
            child.setResourceName(csr.getName());
            child.setType(16);
            child.setValue(csr.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (GroupEntity group : cseBaseEntity.getGroups()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(9);
            child.setValue(group.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (SubscriptionEntity sub : cseBaseEntity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (RequestEntity req : cseBaseEntity.getChildReq()) {
            child = new ChildResourceRef();
            child.setResourceName(req.getName());
            child.setType(17);
            child.setValue(req.getResourceID());
            cseBaseResource.getChildResource().add(child);
        }
        for (NodeEntity nod : cseBaseEntity.getChildNodes()) {
            ChildResourceRef ch = new ChildResourceRef();
            ch.setResourceName(nod.getName());
            ch.setType(14);
            ch.setValue(nod.getResourceID());
            cseBaseResource.getChildResource().add(ch);
        }
    }

    @Override
    protected void mapChildResources(CSEBaseEntity entity, CSEBase resource) {
        for (AccessControlPolicyEntity acp : entity.getChildAccessControlPolicies()) {
            AccessControlPolicy acpRes = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acp, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(acpRes);
        }
        for (AeEntity ae : entity.getAes()) {
            AE aeRes = (AE)new AeMapper().mapEntityToResource(ae, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(aeRes);
        }
        for (ContainerEntity cnt : entity.getChildContainers()) {
            Container cntRes = (Container)new ContainerMapper().mapEntityToResource(cnt, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(cntRes);
        }
        for (RemoteCSEEntity csr : entity.getRemoteCses()) {
            RemoteCSE csrRes = (RemoteCSE)new RemoteCSEMapper().mapEntityToResource(csr, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(csrRes);
        }
        for (GroupEntity group : entity.getGroups()) {
            Group grp = (Group)new GroupMapper().mapEntityToResource(group, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(grp);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(subRes);
        }
        for (RequestEntity req : entity.getChildReq()) {
            Request reqResource = (Request)new RequestMapper().mapEntityToResource(req, ResultContent.ATTRIBUTES);
            resource.getRemoteCSEOrNodeOrAE().add(reqResource);
        }
    }
}

