/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class GroupMapper
extends EntityMapper<GroupEntity, Group> {
    @Override
    protected Group createResource() {
        return new Group();
    }

    @Override
    protected void mapAttributes(GroupEntity entity, Group resource) {
        resource.setConsistencyStrategy(entity.getConsistencyStrategy());
        resource.setExpirationTime(entity.getExpirationTime());
        resource.setCreator(entity.getCreator());
        resource.setCurrentNrOfMembers(BigInteger.valueOf(entity.getMemberIDs().size()));
        resource.setFanOutPoint(String.valueOf(entity.getHierarchicalURI()) + "/" + "fopt");
        resource.setGroupName(resource.getGroupName());
        resource.setMaxNrOfMembers(entity.getMaxNrOfMembers());
        resource.setMemberType(entity.getMemberType());
        resource.setMemberTypeValidated(entity.isMemberTypeValidated());
        for (AccessControlPolicyEntity acpEntity : entity.getAccessControlPolicies()) {
            resource.getAccessControlPolicyIDs().add(acpEntity.getResourceID());
        }
        if (!entity.getAnnouncedAttribute().isEmpty()) {
            resource.getAnnouncedAttribute().addAll(entity.getAnnouncedAttribute());
        }
        if (!entity.getAnnounceTo().isEmpty()) {
            resource.getAnnounceTo().addAll(entity.getAnnounceTo());
        }
        if (!entity.getMemberIDs().isEmpty()) {
            resource.getMemberIDs().addAll(entity.getMemberIDs());
        }
        if (!entity.getMemberAcpIds().isEmpty()) {
            resource.getMembersAccessControlPolicyIDs().addAll(entity.getMemberAcpIds());
        }
    }

    @Override
    protected void mapChildResourceRef(GroupEntity entity, Group resource) {
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            ChildResourceRef ref = new ChildResourceRef();
            ref.setResourceName(sub.getName());
            ref.setType(sub.getResourceType());
            ref.setValue(sub.getResourceID());
            resource.getChildResource().add(ref);
        }
    }

    @Override
    protected void mapChildResources(GroupEntity entity, Group resource) {
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            resource.getSubscription().add(subRes);
        }
    }
}

