/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.util;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ConsistencyStrategy;
import org.eclipse.om2m.commons.constants.MemberType;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.MemberNonFoundException;
import org.eclipse.om2m.commons.exceptions.MemberTypeInconsistentException;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class GroupUtil {
    private static final Log LOGGER = LogFactory.getLog(GroupUtil.class);

    private GroupUtil() {
    }

    public static void validateGroupMember(GroupEntity group) throws MemberNonFoundException, MemberTypeInconsistentException {
        if (!group.isMemberTypeValidated() && !group.getMemberType().equals(MemberType.MIXED)) {
            LOGGER.info((Object)("Validating the memberType of " + group.getHierarchicalURI()));
            DBService dbs = PersistenceService.getInstance().getDbService();
            DBTransaction transaction = dbs.getDbTransaction();
            transaction.open();
            ArrayList<String> result = new ArrayList<String>();
            for (String memberUri : group.getMemberIDs()) {
                String nonHierarchicalUri = UriMapper.getNonHierarchicalUri(memberUri);
                if (nonHierarchicalUri == null) {
                    transaction.close();
                    throw new MemberNonFoundException("Member not found: " + memberUri);
                }
                DAO<?> dao = Patterns.getDAO(nonHierarchicalUri, dbs);
                if (dao == null) {
                    transaction.close();
                    throw new MemberNonFoundException("Member not found: " + memberUri);
                }
                ResourceEntity entity = (ResourceEntity)dao.find(transaction, (Object)nonHierarchicalUri);
                if (entity == null) {
                    transaction.close();
                    throw new MemberNonFoundException("Member not found: " + memberUri);
                }
                result.add(memberUri);
                if (entity.getResourceType().equals(group.getMemberType())) continue;
                if (group.getConsistencyStrategy().equals(ConsistencyStrategy.ABANDON_GROUP)) {
                    transaction.close();
                    throw new MemberTypeInconsistentException("MemberType is inconsistent and consistency strategy is set to ABANDON_GROUP");
                }
                if (group.getConsistencyStrategy().equals(ConsistencyStrategy.ABANDON_MEMBER)) {
                    LOGGER.info((Object)("Member deleted: " + memberUri));
                    result.remove(memberUri);
                    continue;
                }
                LOGGER.info((Object)"Changing the memberType to MIXED");
                group.setMemberType(MemberType.MIXED);
                break;
            }
            if (result.isEmpty()) {
                throw new BadRequestException("All member IDs are incorrect (according to the provided type)");
            }
            group.setMemberIDs(result);
            group.setMemberTypeValidated(true);
            transaction.close();
        }
    }
}

