/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import java.util.Arrays;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.RunModeFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class RunModeModuleTest
extends AbstractModuleTest {
    private String moduleUrl = null;

    public RunModeModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
        try {
            this.moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            // empty catch block
        }
    }

    public TestReport testGetOperationMode() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".getOperationMode");
        if (this.moduleUrl == null) {
            report.setState(TestReport.State.KO);
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer for module " + this.getModule().getName() + " : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        RunModeFlexContainer retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
        CustomAttribute operationModeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.operationMode.getShortName());
        if (operationModeCA == null) {
            report.setErrorMessage("operationMode customAttribute does not exist");
            report.setState(TestReport.State.KO);
            return report;
        }
        List<String> operationModeFromFlexContainer = RunModeModuleTest.getListFromStringArray(operationModeCA.getCustomAttributeValue());
        ArrayDataPoint operationModeDP = (ArrayDataPoint)this.getModule().getDataPoint(DatapointType.operationMode.getShortName());
        List operationModeFromDP = null;
        try {
            operationModeFromDP = (List)operationModeDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to get operationMode value from Datapoint");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(operationModeFromFlexContainer, operationModeFromDP, report, DatapointType.operationMode.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetOperationMode() {
        List supportedModesFromDP;
        TestReport report = new TestReport("test " + this.getModule().getName() + ".setOperationMode");
        if (this.moduleUrl == null) {
            report.setState(TestReport.State.KO);
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            return report;
        }
        ArrayDataPoint supportedModesDP = (ArrayDataPoint)this.getModule().getDataPoint(DatapointType.supportedModes.getShortName());
        try {
            supportedModesFromDP = (List)supportedModesDP.getValue();
        }
        catch (AccessException | DataPointException e1) {
            report.setErrorMessage("unable to retrieve value of supportedModes Datapoint: " + e1.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        ArrayDataPoint operationModeDP = (ArrayDataPoint)this.getModule().getDataPoint(DatapointType.operationMode.getShortName());
        List currentOperationModeValue = null;
        try {
            currentOperationModeValue = (List)operationModeDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setState(TestReport.State.KO);
            report.setErrorMessage("unable to retrieve current value of operationMode datapoint");
            return report;
        }
        String newOperationModeValue = "";
        for (String supportedMode : supportedModesFromDP) {
            if (currentOperationModeValue.contains(supportedMode)) continue;
            newOperationModeValue = String.valueOf(newOperationModeValue) + supportedMode;
            break;
        }
        newOperationModeValue = String.valueOf(newOperationModeValue);
        RunModeFlexContainer toBeUpdated = new RunModeFlexContainer();
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setCustomAttributeName(DatapointType.operationMode.getShortName());
        customAttribute.setCustomAttributeValue(newOperationModeValue.toString());
        toBeUpdated.getCustomAttributes().add(customAttribute);
        ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update FlexContainer for module " + this.getModule().getName() + " : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), this.moduleUrl);
        RunModeFlexContainer retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
        CustomAttribute operationModeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.operationMode.getShortName());
        String operationModeFromFlexContainer = operationModeCA.getCustomAttributeValue();
        if (!this.checkObject(newOperationModeValue, operationModeFromFlexContainer = operationModeFromFlexContainer.substring(1, operationModeFromFlexContainer.length() - 1), report, DatapointType.operationMode.getShortName())) {
            return report;
        }
        String newOperationModeWrongValue = "unknownValue_" + System.currentTimeMillis();
        toBeUpdated = new RunModeFlexContainer();
        customAttribute.setCustomAttributeName(DatapointType.operationMode.getShortName());
        customAttribute.setCustomAttributeValue(newOperationModeWrongValue);
        toBeUpdated.getCustomAttributes().add(customAttribute);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("expected KO on UPDATE request as operationMode value is wrong");
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), this.moduleUrl);
        retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
        operationModeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.operationMode.getShortName());
        operationModeFromFlexContainer = operationModeCA.getCustomAttributeValue();
        if (!this.checkObject(newOperationModeValue, operationModeFromFlexContainer = operationModeFromFlexContainer.substring(1, operationModeFromFlexContainer.length() - 1), report, DatapointType.operationMode.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testGetSupportedModes() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".getSupportedModes");
        if (this.moduleUrl == null) {
            report.setState(TestReport.State.KO);
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer of module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        RunModeFlexContainer retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
        CustomAttribute supportedModesCA = retrievedFlexContainer.getCustomAttribute(DatapointType.supportedModes.getShortName());
        if (supportedModesCA == null) {
            report.setErrorMessage("supportedModes customAttribute does not exist");
            report.setState(TestReport.State.KO);
            return report;
        }
        List<String> supportedModesListFromFlexContainer = RunModeModuleTest.getListFromStringArray(supportedModesCA.getCustomAttributeValue());
        ArrayDataPoint supportedModesDP = (ArrayDataPoint)this.getModule().getDataPoint(DatapointType.supportedModes.getShortName());
        List supportedModesListFromDP = null;
        try {
            supportedModesListFromDP = (List)supportedModesDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve supportedModes Datapoint value: " + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (supportedModesListFromDP.size() != supportedModesListFromFlexContainer.size()) {
            report.setErrorMessage("supportedModes size from Datapoint different from the list from flexContainer");
            report.setState(TestReport.State.KO);
            return report;
        }
        for (String s : supportedModesListFromDP) {
            if (supportedModesListFromFlexContainer.contains(s)) continue;
            report.setErrorMessage(String.valueOf(s) + " mode is not in FlexContainer list");
            report.setState(TestReport.State.KO);
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetSupportedModes() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".setSupportedModes");
        if (this.moduleUrl == null) {
            report.setState(TestReport.State.KO);
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            return report;
        }
        CustomAttribute supportedModesCA = new CustomAttribute();
        supportedModesCA.setCustomAttributeName(DatapointType.supportedModes.getShortName());
        supportedModesCA.setCustomAttributeValue("mode2,mode3,mode6,mode7");
        RunModeFlexContainer toBeUpdated = new RunModeFlexContainer();
        toBeUpdated.getCustomAttributes().add(supportedModesCA);
        ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update supportedModes customAttribute:" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        ArrayDataPoint supportedModesDP = (ArrayDataPoint)this.getModule().getDataPoint(DatapointType.supportedModes.getShortName());
        List supportedModesFromDP = null;
        try {
            supportedModesFromDP = (List)supportedModesDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve supportedModes value from datapoint:" + e.getMessage());
            report.setException((Exception)e);
            report.setState(TestReport.State.KO);
            return report;
        }
        String[] supportedModesValueFromFlexContainer_array = supportedModesCA.getCustomAttributeValue().split(",");
        List<String> supportedModesValueFromFlexContainer_list = Arrays.asList(supportedModesValueFromFlexContainer_array);
        if (!this.checkObject(supportedModesValueFromFlexContainer_list, supportedModesFromDP, report, DatapointType.supportedModes.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

