/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.utils.AcpUtils;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class AccessControlPolicyController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childAcps = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseBase = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseBase.getAccessControlPolicies();
            childAcps = cseBase.getChildAccessControlPolicies();
            subscriptions = cseBase.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            acpsToCheck = ae.getAccessControlPolicies();
            childAcps = ae.getChildAccessControlPolicies();
            subscriptions = ae.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
            childAcps = csr.getChildAcps();
            subscriptions = csr.getSubscriptions();
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AccessControlPolicy creation");
        }
        AccessControlPolicy acp = null;
        try {
            acp = request.getRequestContentType().equals("application/obj") ? (AccessControlPolicy)request.getContent() : (AccessControlPolicy)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (acp == null) {
            throw new BadRequestException("Error in provided content");
        }
        AccessControlPolicyEntity acpEntity = new AccessControlPolicyEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)acp, (ResourceEntity)acpEntity);
        if (acp.getPrivileges() == null) {
            throw new BadRequestException("Prilileges is Mandatory");
        }
        if (acp.getSelfPrivileges() == null) {
            throw new BadRequestException("SelfPrivileges is Mandatory");
        }
        String generatedId = AccessControlPolicyController.generateId();
        if (acp.getName() != null) {
            if (!Patterns.checkResourceName(acp.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            acpEntity.setName(acp.getName());
        } else {
            acpEntity.setName("acp_" + generatedId);
        }
        acpEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + acpEntity.getName());
        acpEntity.setResourceID("/" + Constants.CSE_ID + "/" + "acp" + Constants.PREFIX_SEPERATOR + generatedId);
        if (!UriMapper.addNewUri(acpEntity.getHierarchicalURI(), acpEntity.getResourceID(), 1)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        acpEntity.setCreationTime(Util.DateUtil.now());
        acpEntity.setLastModifiedTime(Util.DateUtil.now());
        acpEntity.setParentID(parentEntity.getResourceID());
        acpEntity.setResourceType(1);
        switch (parentEntity.getResourceType().intValue()) {
            case 2: {
                acpEntity.setParentAE((AeEntity)parentEntity);
                break;
            }
            case 16: {
                acpEntity.setParentCsr((RemoteCSEEntity)parentEntity);
                break;
            }
            case 5: {
                acpEntity.setParentCse((CSEBaseEntity)parentEntity);
            }
        }
        if (acp.getExpirationTime() != null) {
            acpEntity.setExpirationTime(acp.getExpirationTime());
        }
        acpEntity.getAnnounceTo().addAll(acp.getAnnounceTo());
        acpEntity.getAnnouncedAttribute().addAll(acp.getAnnouncedAttribute());
        acpEntity.setPrivileges(AcpUtils.getACREntityFromSetOfArcs((SetOfAcrs)acp.getPrivileges()));
        acpEntity.setSelfPrivileges(AcpUtils.getACREntityFromSetOfArcs((SetOfAcrs)acp.getSelfPrivileges()));
        this.dbs.getDAOFactory().getAccessControlPolicyDAO().create(this.transaction, (Object)acpEntity);
        AccessControlPolicyEntity acpDB = (AccessControlPolicyEntity)this.dbs.getDAOFactory().getAccessControlPolicyDAO().find(this.transaction, (Object)acpEntity.getResourceID());
        childAcps.add(acpDB);
        dao.update(this.transaction, (Object)parentEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)acpDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)acpDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AccessControlPolicyEntity acpEntity = (AccessControlPolicyEntity)this.dbs.getDAOFactory().getAccessControlPolicyDAO().find(this.transaction, (Object)request.getTargetId());
        if (acpEntity == null) {
            throw new ResourceNotFoundException("Resource " + request.getTargetId() + " not found.");
        }
        this.checkSelfACP(acpEntity, request.getFrom(), Operation.RETRIEVE);
        AccessControlPolicy acpResource = EntityMapperFactory.getAcpMapper().mapEntityToResource(acpEntity, request);
        response.setContent((Object)acpResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        List rules;
        ResponsePrimitive response = new ResponsePrimitive(request);
        AccessControlPolicyEntity acpEntity = (AccessControlPolicyEntity)this.dbs.getDAOFactory().getAccessControlPolicyDAO().find(this.transaction, (Object)request.getTargetId());
        if (acpEntity == null) {
            throw new ResourceNotFoundException("Resource " + request.getTargetId() + " not found.");
        }
        this.transaction.lock((Object)acpEntity);
        this.checkSelfACP(acpEntity, request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for ACP update");
        }
        AccessControlPolicy acp = null;
        try {
            acp = request.getRequestContentType().equals("application/obj") ? (AccessControlPolicy)request.getContent() : (AccessControlPolicy)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (acp == null) {
            throw new BadRequestException("Error in provided content");
        }
        AccessControlPolicy modifiedAttributes = new AccessControlPolicy();
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)acp);
        if (acp.getExpirationTime() != null) {
            acpEntity.setExpirationTime(acp.getExpirationTime());
            modifiedAttributes.setExpirationTime(acp.getExpirationTime());
        }
        if (!acp.getLabels().isEmpty()) {
            acpEntity.setLabelsEntitiesFromSring(acp.getLabels());
            modifiedAttributes.getLabels().addAll(acp.getLabels());
        }
        if (!acp.getAnnounceTo().isEmpty()) {
            acpEntity.getAnnounceTo().clear();
            acpEntity.getAnnounceTo().addAll(acp.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(acp.getAnnounceTo());
        }
        if (!acp.getAnnouncedAttribute().isEmpty()) {
            acpEntity.getAnnouncedAttribute().clear();
            acpEntity.getAnnouncedAttribute().addAll(acp.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(acp.getAnnouncedAttribute());
        }
        if (acp.getPrivileges() != null) {
            rules = AcpUtils.getACREntityFromSetOfArcs((SetOfAcrs)acp.getPrivileges());
            acpEntity.getPrivileges().clear();
            acpEntity.getPrivileges().addAll(rules);
            modifiedAttributes.setPrivileges(acp.getPrivileges());
        }
        if (acp.getSelfPrivileges() != null) {
            rules = AcpUtils.getACREntityFromSetOfArcs((SetOfAcrs)acp.getSelfPrivileges());
            acpEntity.getSelfPrivileges().clear();
            acpEntity.getSelfPrivileges().addAll(rules);
            modifiedAttributes.setSelfPrivileges(acp.getSelfPrivileges());
        }
        acpEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(acpEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getAccessControlPolicyDAO().update(this.transaction, (Object)acpEntity);
        this.transaction.commit();
        Notifier.notify(acpEntity.getChildSubscriptions(), (ResourceEntity)acpEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AccessControlPolicyEntity acpEntity = (AccessControlPolicyEntity)this.dbs.getDAOFactory().getAccessControlPolicyDAO().find(this.transaction, (Object)request.getTargetId());
        if (acpEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)acpEntity);
        for (AeEntity ae : acpEntity.getLinkedAes()) {
            if (ae.getGeneratedAcp() == null || !ae.getGeneratedAcp().getResourceID().equals(acpEntity.getResourceID())) continue;
            throw new BadRequestException("Delete the linked ae(s) to avoid acp inconsistency.");
        }
        this.checkSelfACP(acpEntity, request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(acpEntity.getHierarchicalURI());
        Notifier.notifyDeletion(acpEntity.getChildSubscriptions(), (ResourceEntity)acpEntity);
        this.dbs.getDAOFactory().getAccessControlPolicyDAO().delete(this.transaction, (Object)acpEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

