/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.EnumDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.WaterValve;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.LiquidLevel;
import org.osgi.framework.ServiceRegistration;

public class MockedWaterValve
extends WaterValve
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;

    public MockedWaterValve(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.addModule(new org.eclipse.om2m.sdt.home.modules.LiquidLevel("waterLevel_" + id, domain, new LiquidLevel((EnumDataPoint)new EnumDataPoint<Integer>((Identifiers)DatapointType.liquidLevel){
            private Integer openLevel;
            {
                this.openLevel = 1;
            }

            public void doSetValue(Integer value) throws DataPointException {
                this.openLevel = value;
                Activator.logger.info("openLevel set " + value);
            }

            public Integer doGetValue() throws DataPointException {
                return this.openLevel;
            }
        })));
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

