/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.dal;

import java.awt.EventQueue;
import java.math.BigInteger;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.obix.Contract;
import org.eclipse.om2m.commons.obix.Obj;
import org.eclipse.om2m.commons.obix.Op;
import org.eclipse.om2m.commons.obix.Str;
import org.eclipse.om2m.commons.obix.Uri;
import org.eclipse.om2m.commons.obix.io.ObixEncoder;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.ipe.dal.Activator;
import org.eclipse.om2m.ipe.dal.FunctionEventHandler;
import org.eclipse.om2m.ipe.dal.InterworkingServiceImpl;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.dal.Function;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class FunctionServiceTracker
extends ServiceTracker<Object, Object> {
    private static Log LOGGER = LogFactory.getLog(FunctionServiceTracker.class);
    private String deviceResourceName = "";
    public static final String DESC = "DESCRIPTOR";
    public static final String LATEST = "la";

    public FunctionServiceTracker(String deviceUid, String deviceResourceName) throws InvalidSyntaxException {
        super(Activator.getContext(), Activator.getContext().createFilter("(&(objectClass=" + Function.class.getName().toString() + ")(" + "dal.function.device.UID" + "=" + deviceUid + "))"), null);
        this.deviceResourceName = deviceResourceName;
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        LOGGER.info((Object)"Function service removed");
    }

    public Object addingService(ServiceReference<Object> reference) {
        LOGGER.info((Object)"Function service discovered");
        final Function func = (Function)this.context.getService(reference);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FunctionServiceTracker.this.createFunctionResource(func);
            }
        });
        return func;
    }

    private void createFunctionResource(Function func) {
        String funcUid = (String)func.getServiceProperty("dal.function.UID");
        String resourceName = funcUid.replace(':', '_');
        String resourceId = "";
        Container container = new Container();
        container.setMaxNrOfInstances(BigInteger.valueOf(10L));
        container.setName(resourceName);
        ResponsePrimitive response = InterworkingServiceImpl.createResource(String.valueOf(InterworkingServiceImpl.CSE_PREFIX) + "/" + this.deviceResourceName, (Resource)container, 3);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            resourceId = response.getLocation();
        } else if (response.getResponseStatusCode().equals(ResponseStatusCode.CONFLICT)) {
            DBTransaction dbTransaction = Activator.getDBService().getDbTransaction();
            dbTransaction.open();
            ContainerEntity dbContainer = (ContainerEntity)Activator.getDBService().getDAOFactory().getContainerByResourceNameDAO().find(dbTransaction, (Object)resourceName);
            dbTransaction.close();
            resourceId = dbContainer.getResourceID();
        }
        if (!resourceId.isEmpty()) {
            InterworkingServiceImpl.addFunction(resourceName, func);
            container = new Container();
            container.setMaxNrOfInstances(BigInteger.valueOf(10L));
            container.setName(DESC);
            response = InterworkingServiceImpl.createResource(resourceId, (Resource)container, 3);
            String descResourceId = "";
            if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
                descResourceId = response.getLocation();
            } else if (response.getResponseStatusCode().equals(ResponseStatusCode.CONFLICT)) {
                DBTransaction dbTransaction = Activator.getDBService().getDbTransaction();
                dbTransaction.open();
                ContainerEntity dbContainer = (ContainerEntity)Activator.getDBService().getDAOFactory().getDescContainerByParentDAO().find(dbTransaction, (Object)resourceId);
                dbTransaction.close();
                descResourceId = dbContainer.getResourceID();
            }
            if (!descResourceId.isEmpty()) {
                ContentInstance contentInstance = new ContentInstance();
                contentInstance.setContent(this.getFunctionDescContent(func, resourceName, resourceId));
                contentInstance.setContentInfo("application/obix");
                contentInstance.setName(DESC);
                InterworkingServiceImpl.createResource(descResourceId, (Resource)contentInstance, 4);
            }
            Hashtable<String, String> dict = new Hashtable<String, String>();
            ((Dictionary)dict).put("event.topics", "org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED");
            ((Dictionary)dict).put("event.filter", "(dal.function.UID=" + funcUid + ")");
            FunctionEventHandler newFuncEventHandler = new FunctionEventHandler(funcUid, resourceId);
            ServiceRegistration register = Activator.getContext().registerService(EventHandler.class.getName(), (Object)newFuncEventHandler, dict);
            if (register == null) {
                LOGGER.error((Object)String.format("Event handler (%s) register failed!", funcUid));
            }
        }
    }

    private String getFunctionDescContent(Function func, String resourceName, String resourceId) {
        String[] operNames;
        int n;
        Obj obj = new Obj();
        obj.add((Object)new Str("dal.function.UID", (String)func.getServiceProperty("dal.function.UID")));
        obj.add((Object)new Str("dal.function.type", (String)func.getServiceProperty("dal.function.type")));
        obj.add((Object)new Str("dal.function.version", (String)func.getServiceProperty("dal.function.version")));
        obj.add((Object)new Str("dal.function.description", (String)func.getServiceProperty("dal.function.description")));
        Op opLa = new Op();
        opLa.setName("getState");
        opLa.setHref(new Uri(String.valueOf(InterworkingServiceImpl.CSE_PREFIX) + "/" + this.deviceResourceName + "/" + resourceName + "/" + LATEST));
        opLa.setIs(new Contract("retrieve"));
        opLa.setIn(new Contract("obix:Nil"));
        opLa.setOut(new Contract("obix:Nil"));
        obj.add((Object)opLa);
        String[] propNames = (String[])func.getServiceProperty("dal.function.property.names");
        if (propNames != null) {
            String[] stringArray = propNames;
            n = propNames.length;
            int n2 = 0;
            while (n2 < n) {
                String propName = stringArray[n2];
                Map propMetadata = func.getPropertyMetadata(propName).getMetadata(null);
                Integer access = (Integer)propMetadata.get("access");
                if ((access & 1) != 0) {
                    String getPropOpName = "get" + propName.replace(propName.substring(0, 1), propName.substring(0, 1).toUpperCase());
                    Op getPropOp = new Op();
                    getPropOp.setName(getPropOpName);
                    getPropOp.setHref(new Uri(String.valueOf(InterworkingServiceImpl.CSE_PREFIX) + "/" + this.deviceResourceName + "?function=" + resourceName + "&op=" + getPropOpName));
                    getPropOp.setIs(new Contract("execute"));
                    getPropOp.setIn(new Contract("obix:Nil"));
                    getPropOp.setOut(new Contract("obix:Nil"));
                    obj.add((Object)getPropOp);
                }
                if ((access & 2) != 0) {
                    String setPropOpName = "set" + propName.replace(propName.substring(0, 1), propName.substring(0, 1).toUpperCase());
                    Op setPropOp = new Op();
                    setPropOp.setName(setPropOpName);
                    setPropOp.setHref(new Uri(String.valueOf(InterworkingServiceImpl.CSE_PREFIX) + "/" + this.deviceResourceName + "?function=" + resourceName + "&op=" + setPropOpName));
                    setPropOp.setIs(new Contract("execute"));
                    setPropOp.setIn(new Contract("obix:Nil"));
                    setPropOp.setOut(new Contract("obix:Nil"));
                    setPropOp.setWritable(Boolean.valueOf(true));
                    obj.add((Object)setPropOp);
                }
                ++n2;
            }
        }
        if ((operNames = (String[])func.getServiceProperty("dal.function.operation.names")) != null) {
            String[] stringArray = operNames;
            int n3 = operNames.length;
            n = 0;
            while (n < n3) {
                String operName = stringArray[n];
                Op opState = new Op();
                opState.setName(operName);
                opState.setHref(new Uri(String.valueOf(InterworkingServiceImpl.CSE_PREFIX) + "/" + this.deviceResourceName + "?function=" + resourceName + "&op=" + operName));
                opState.setIs(new Contract("execute"));
                opState.setIn(new Contract("obix:Nil"));
                opState.setOut(new Contract("obix:Nil"));
                obj.add((Object)opState);
                ++n;
            }
        }
        return ObixEncoder.toString((Obj)obj);
    }
}

