/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.notifier;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.resource.Notification;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.core.thread.CoreExecutor;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class Notifier {
    private static Log LOGGER = LogFactory.getLog(Notifier.class);

    public static void notify(List<SubscriptionEntity> listSubscription, ResourceEntity resource, int resourceStatus) {
        Notifier.notify(listSubscription, resource, null, resourceStatus);
    }

    public static void notify(List<SubscriptionEntity> listSubscription, ResourceEntity resource, Resource modifiedOnlyResource, int resourceStatus) {
        if (listSubscription != null) {
            for (SubscriptionEntity sub : listSubscription) {
                NotificationWorker worker = new NotificationWorker(sub, resourceStatus, resource, modifiedOnlyResource);
                CoreExecutor.postThread(worker);
            }
        }
    }

    public static void notifyDeletion(List<SubscriptionEntity> listSubs, ResourceEntity resourceDeleted) {
        List<SubscriptionEntity> parentSubscriptions = Notifier.getParentSubscriptions(resourceDeleted);
        if (parentSubscriptions != null) {
            Notifier.notify(parentSubscriptions, resourceDeleted, 2);
        }
        if (listSubs != null) {
            Notifier.notify(listSubs, resourceDeleted, 4);
        }
    }

    public static void performVerificationRequest(RequestPrimitive request, SubscriptionEntity subscriptionEntity) {
        String notificationPayloadContentType = subscriptionEntity.getNotificationPayloadContentType();
        for (String uri : subscriptionEntity.getNotificationURI()) {
            if (uri.equals(request.getFrom())) continue;
            Notification notification = new Notification();
            notification.setCreator(subscriptionEntity.getCreator());
            notification.setVerificationRequest(Boolean.valueOf(true));
            notification.setSubscriptionReference(subscriptionEntity.getHierarchicalURI());
            notification.setSubscriptionDeletion(Boolean.valueOf(false));
            RequestPrimitive notifRequest = new RequestPrimitive();
            if (!"application/obj".equals(notificationPayloadContentType)) {
                notifRequest.setContent((Object)DataMapperSelector.getDataMapperList().get(notificationPayloadContentType).objToString((Object)notification));
            } else {
                notifRequest.setContent((Object)notification);
            }
            notifRequest.setFrom("/" + Constants.CSE_ID);
            notifRequest.setTo(uri);
            notifRequest.setOperation(Operation.NOTIFY);
            notifRequest.setRequestContentType(notificationPayloadContentType);
            notifRequest.setReturnContentType(notificationPayloadContentType);
            ResponsePrimitive resp = Notifier.notify(notifRequest, uri);
            if (resp.getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                throw new Om2mException("Error during the verification request", ResponseStatusCode.SUBSCRIPTION_VERIFICATION_INITIATION_FAILED);
            }
            if (!resp.getResponseStatusCode().equals(ResponseStatusCode.SUBSCRIPTION_CREATOR_HAS_NO_PRIVILEGE) && !resp.getResponseStatusCode().equals(ResponseStatusCode.SUBSCRIPTION_HOST_HAS_NO_PRIVILEGE)) continue;
            throw new Om2mException(resp.getResponseStatusCode());
        }
    }

    public static ResponsePrimitive notify(RequestPrimitive request, String contact) {
        LOGGER.info((Object)("Sending notify request to: " + contact));
        if (contact.matches(".*://.*")) {
            request.setTo(contact);
            return RestClient.sendRequest(request);
        }
        request.setTo(contact);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        LOGGER.info((Object)"Sending notify request...");
        return new Router().doRequest(request);
    }

    private static List<SubscriptionEntity> getParentSubscriptions(ResourceEntity resourceDeleted) {
        ArrayList<SubscriptionEntity> result;
        String[] ids = resourceDeleted.getHierarchicalURI().split("/");
        String parentHierarchicalId = resourceDeleted.getHierarchicalURI().replace("/" + ids[ids.length - 1], "");
        String parentId = UriMapper.getNonHierarchicalUri(parentHierarchicalId);
        DBService dbs = PersistenceService.getInstance().getDbService();
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(parentId, dbs);
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        ResourceEntity parentEntity = (ResourceEntity)dao.find(transaction, (Object)parentId);
        switch (parentEntity.getResourceType().intValue()) {
            case 1: {
                AccessControlPolicyEntity acp = (AccessControlPolicyEntity)parentEntity;
                result = acp.getChildSubscriptions();
                break;
            }
            case 2: {
                AeEntity ae = (AeEntity)parentEntity;
                result = ae.getSubscriptions();
                break;
            }
            case 3: {
                ContainerEntity cnt = (ContainerEntity)parentEntity;
                result = cnt.getSubscriptions();
                break;
            }
            case 5: {
                CSEBaseEntity csb = (CSEBaseEntity)parentEntity;
                result = csb.getSubscriptions();
                break;
            }
            case 9: {
                GroupEntity group = (GroupEntity)parentEntity;
                result = group.getSubscriptions();
                break;
            }
            case 16: {
                RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
                result = csr.getSubscriptions();
                break;
            }
            case 18: {
                ScheduleEntity schedule = (ScheduleEntity)parentEntity;
                result = schedule.getSubscriptions();
                break;
            }
            default: {
                result = new ArrayList();
            }
        }
        transaction.close();
        return result;
    }

    private static void deleteSubscription(String resourceId) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction dbTransaction = dbs.getDbTransaction();
        dbTransaction.open();
        SubscriptionEntity subscriptionEntityToBeDeleted = (SubscriptionEntity)dbs.getDAOFactory().getSubsciptionDAO().find(dbTransaction, (Object)resourceId);
        dbs.getDAOFactory().getSubsciptionDAO().delete(dbTransaction, (Object)subscriptionEntityToBeDeleted);
        dbTransaction.commit();
        dbTransaction.close();
    }

    private static void updateSubscription(String resourceId, Integer nbOfFailedNotification) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction dbTransaction = dbs.getDbTransaction();
        dbTransaction.open();
        SubscriptionEntity subscriptionEntityToBeUpdated = (SubscriptionEntity)dbs.getDAOFactory().getSubsciptionDAO().find(dbTransaction, (Object)resourceId);
        subscriptionEntityToBeUpdated.setNbOfFailedNotifications(nbOfFailedNotification);
        dbs.getDAOFactory().getSubsciptionDAO().update(dbTransaction, (Object)subscriptionEntityToBeUpdated);
        dbTransaction.commit();
        dbTransaction.close();
    }

    static class NotificationWorker
    implements Runnable {
        private int resourceStatus;
        private SubscriptionEntity sub;
        private ResourceEntity resource;
        private Resource modifiedOnlyResource;

        public NotificationWorker(SubscriptionEntity sub, int resourceStatus, ResourceEntity resource, Resource modifiedOnlyResource) {
            this.resourceStatus = resourceStatus;
            this.sub = sub;
            this.resource = resource;
            this.modifiedOnlyResource = modifiedOnlyResource;
        }

        @Override
        public void run() {
            final Integer NB_OF_FAILED_NOTIFS_BEFORE_DELETION = Integer.valueOf(System.getProperty("org.eclipse.om2m.subscriptions.nbOfFailedNotificationsBeforeDeletion", "5"));
            final RequestPrimitive request = new RequestPrimitive();
            Notification notification = new Notification();
            Notification.NotificationEvent notifEvent = new Notification.NotificationEvent();
            notification.setNotificationEvent(notifEvent);
            notifEvent.setResourceStatus(BigInteger.valueOf(this.resourceStatus));
            notification.setCreator(this.sub.getCreator());
            request.setOperation(Operation.NOTIFY);
            request.setFrom("/" + Constants.CSE_ID);
            if (this.resourceStatus == 4) {
                notification.setSubscriptionDeletion(Boolean.valueOf(true));
            } else {
                notification.setSubscriptionDeletion(Boolean.valueOf(false));
            }
            notification.setSubscriptionReference(this.sub.getResourceID());
            if (this.sub.getNotificationContentType() != null) {
                Object serializableResource;
                Notification.NotificationEvent.Representation representation;
                EntityMapper mapper = this.resource.getResourceType().equals(13) ? EntityMapperFactory.getMapperForMgmtObj((MgmtObjEntity)this.resource) : EntityMapperFactory.getMapperFromResourceType(this.resource.getResourceType().intValue());
                if (this.sub.getNotificationContentType().equals(NotificationContentType.MODIFIED_ATTRIBUTES)) {
                    representation = new Notification.NotificationEvent.Representation();
                    if (this.modifiedOnlyResource != null) {
                        representation.setResource(this.modifiedOnlyResource);
                    } else {
                        serializableResource = mapper.mapEntityToResource(this.resource, ResultContent.ATTRIBUTES, 0, 0);
                        representation.setResource(serializableResource);
                    }
                    notification.getNotificationEvent().setRepresentation(representation);
                    request.setRequestContentType(this.sub.getNotificationPayloadContentType());
                } else if (this.sub.getNotificationContentType().equals(NotificationContentType.WHOLE_RESOURCE)) {
                    serializableResource = mapper.mapEntityToResource(this.resource, ResultContent.ATTRIBUTES, 0, 0);
                    representation = new Notification.NotificationEvent.Representation();
                    representation.setResource(serializableResource);
                    notification.getNotificationEvent().setRepresentation(representation);
                    request.setRequestContentType(this.sub.getNotificationPayloadContentType());
                }
            }
            request.setContent((Object)DataMapperSelector.getDataMapperList().get(this.sub.getNotificationPayloadContentType()).objToString((Object)notification));
            for (final String uri : this.sub.getNotificationURI()) {
                CoreExecutor.postThread(new Runnable(){

                    @Override
                    public void run() {
                        ResponsePrimitive response = Notifier.notify(request, uri);
                        if (ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                            Notifier.updateSubscription(NotificationWorker.this.sub.getResourceID(), 0);
                            LOGGER.debug((Object)("notify OK for subscription " + NotificationWorker.this.sub.getResourceID()));
                        } else {
                            Integer nbOfFailed = NotificationWorker.this.sub.getNbOfFailedNotifications();
                            if (nbOfFailed == null) {
                                nbOfFailed = 0;
                            }
                            if (nbOfFailed > NB_OF_FAILED_NOTIFS_BEFORE_DELETION) {
                                Notifier.deleteSubscription(NotificationWorker.this.sub.getResourceID());
                                LOGGER.error((Object)("Reach the limit of failed notifs --> delete subscription " + NotificationWorker.this.sub.getResourceID()));
                            } else {
                                Notifier.updateSubscription(NotificationWorker.this.sub.getResourceID(), nbOfFailed + 1);
                                LOGGER.warn((Object)("unable to notify, increase failed notifs(" + nbOfFailed + ") for subscription " + NotificationWorker.this.sub.getResourceID()));
                            }
                        }
                    }
                });
            }
        }
    }
}

