/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;

public class Utils {
    private static Log Logger = LogFactory.getLog(Utils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String sendGetRequest(String gwPath, String apiName) throws HueException, UnknownHueGatewayException {
        String string;
        HttpURLConnection conn = null;
        try {
            conn = Utils.createConnection(gwPath, apiName);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new HueException("Hue Light Gateway GET failed, HTTP error code : \n\t" + conn.getResponseCode());
            }
            string = Utils.read(conn);
        }
        catch (Exception e) {
            try {
                if (e.getClass().equals(ConnectException.class)) throw new UnknownHueGatewayException("");
                if (e.getClass().equals(UnknownHostException.class)) throw new UnknownHueGatewayException("");
                if (!e.getClass().equals(SocketTimeoutException.class)) throw new HueException("Exception on send GET request : \n\t" + e.toString());
                throw new UnknownHueGatewayException("");
            }
            catch (Throwable throwable) {
                try {
                    conn.disconnect();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            conn.disconnect();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String sendPutRequest(String gwPath, String apiName, String jsonString) throws HueException, UnknownHueGatewayException {
        String string;
        HttpURLConnection conn = null;
        try {
            conn = Utils.createConnection(gwPath, apiName);
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Content-Type", "application/json");
            OutputStream os = conn.getOutputStream();
            os.write(jsonString.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new HueException("Hue Light Gateway PUT failed, HTTP error code : \n\t" + conn.getResponseCode());
            }
            string = Utils.read(conn);
        }
        catch (IOException e) {
            try {
                Logger.warn((Object)"", (Throwable)e);
                if (e.getClass().equals(ConnectException.class)) throw new UnknownHueGatewayException("");
                if (e.getClass().equals(UnknownHostException.class)) throw new UnknownHueGatewayException("");
                if (!e.getClass().equals(SocketTimeoutException.class)) throw new HueException("Exception on send PUT request : \n\t" + e.toString());
                throw new UnknownHueGatewayException("");
            }
            catch (Throwable throwable) {
                try {
                    conn.disconnect();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            conn.disconnect();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String sendPostRequest(String gwPath, String apiName, String jsonString) throws HueException, UnknownHueGatewayException {
        String string;
        HttpURLConnection conn = null;
        try {
            conn = Utils.createConnection(gwPath, apiName);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            OutputStream os = conn.getOutputStream();
            os.write(jsonString.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new HueException("Hue Light Gateway POST failed, HTTP error code : " + conn.getResponseCode() + ", response body: " + conn.getResponseMessage());
            }
            string = Utils.read(conn);
        }
        catch (IOException e) {
            try {
                Logger.warn((Object)"", (Throwable)e);
                if (e.getClass().equals(ConnectException.class)) throw new UnknownHueGatewayException("");
                if (e.getClass().equals(UnknownHostException.class)) throw new UnknownHueGatewayException("");
                if (!e.getClass().equals(SocketTimeoutException.class)) throw new HueException("Exception on send POST request : \n\t" + e.toString());
                throw new UnknownHueGatewayException("");
            }
            catch (Throwable throwable) {
                try {
                    conn.disconnect();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            conn.disconnect();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    private static final HttpURLConnection createConnection(String path, String api) throws MalformedURLException, IOException {
        String url = "http://" + path.trim() + "/" + api.trim();
        return (HttpURLConnection)new URL(url).openConnection();
    }

    private static final String read(HttpURLConnection conn) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }
}

