/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.RunStateFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class RunStateFlexContainerTest
extends FlexContainerTestSuite {
    public RunStateFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "RunStateFlexContainerTest";
    }

    public void testCreateAndRetrieveRunStateFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunStateFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunStateFlexContainer flexContainer = new RunStateFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setShortName("opeMe");
        operationModeCustomAttribute.setValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setShortName("supMs");
        supportedModesCustomAttribute.setValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        RunStateFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "unable to create RunStateFlexContainer :" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (RunStateFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "name are differents (expected:" + flexContainerName + ", found:" + createdFlexContainer.getName() + ")", null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "creator are differents (expected:" + flexContainer.getCreator() + ", found:" + createdFlexContainer.getCreator() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "customAttributes are differents (expected:" + flexContainer.getCustomAttributes() + ", found:" + createdFlexContainer.getCustomAttributes() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "containerDefinition are differents (expected:" + flexContainer.getContainerDefinition() + ", found:" + createdFlexContainer.getContainerDefinition() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "ontologyRef are differents (expected:" + flexContainer.getOntologyRef() + ", found:" + createdFlexContainer.getOntologyRef() + ")", e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "unable to retrieve RunStateFlexContainer (expected:" + ResponseStatusCode.OK + ", found:" + response.getResponseStatusCode() + ")", null);
        } else {
            RunStateFlexContainer retrievedFlexContainer = (RunStateFlexContainer)response.getContent();
            try {
                this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
            }
            catch (Exception e) {
                this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.KO, "flexContainers are differents:" + e.getMessage(), e);
            }
        }
        this.createTestReport("testCreateAndRetrieveRunStateFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateRunStateFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunStateFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunStateFlexContainer flexContainer = new RunStateFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setShortName("opeMe");
        operationModeCustomAttribute.setValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setShortName("supMs");
        supportedModesCustomAttribute.setValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "unable to create RunStateFlexContainer :" + response.getContent(), null);
            return;
        }
        RunStateFlexContainer toBeUpdated = new RunStateFlexContainer();
        CustomAttribute operationModeToBeUpdated = new CustomAttribute();
        operationModeToBeUpdated.setValue("OFF");
        operationModeToBeUpdated.setShortName("opeMe");
        toBeUpdated.getCustomAttributes().add(operationModeToBeUpdated);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        RunStateFlexContainer updatedFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "unable to update RunStateFlexContainer (expected " + ResponseStatusCode.UPDATED + ", received: " + response.getResponseStatusCode() + ")", null);
            return;
        }
        updatedFlexContainer = (RunStateFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "expecting 1 custom attribute, found " + updatedFlexContainer.getCustomAttributes().size(), null);
            return;
        }
        if (!updatedFlexContainer.getCustomAttribute("opeMe").getValue().equals("OFF")) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "invalid operationMode customAttribute value (expected: OFF, received: " + updatedFlexContainer.getCustomAttribute("opeMe").getValue() + ")", null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "unable to retrieve RunStateFlexContainer (expected " + ResponseStatusCode.OK + ", received: " + response.getResponseStatusCode() + ")", null);
            return;
        }
        RunStateFlexContainer retrievedFlexContainer = (RunStateFlexContainer)response.getContent();
        if (retrievedFlexContainer.getCustomAttributes().size() != 2) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "expecting 2 custom attribute, found " + updatedFlexContainer.getCustomAttributes().size(), null);
            return;
        }
        if (!retrievedFlexContainer.getCustomAttribute("opeMe").getValue().equals("OFF")) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "invalid operationMode customAttribute value (expected: OFF, received: " + retrievedFlexContainer.getCustomAttribute("opeMe").getValue() + ")", null);
            return;
        }
        if (!retrievedFlexContainer.getCustomAttribute("supMs").getValue().equals("ON,OFF,UNKNOWN")) {
            this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.KO, "invalid supportedModes customAttribute value (expected: ON,OFF,UNKNOWN, received: " + retrievedFlexContainer.getCustomAttribute("supMs").getValue() + ")", null);
            return;
        }
        this.createTestReport("testUpdateRunStateFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteRunStateFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunStateFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunStateFlexContainer flexContainer = new RunStateFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setShortName("opeMe");
        operationModeCustomAttribute.setValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setShortName("supMs");
        supportedModesCustomAttribute.setValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteRunStateFlexContainer", TestReport.Status.KO, "unable to create RunStateFlexContainer :" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteRunStateFlexContainer", TestReport.Status.KO, "unable to delete RunStateFlexContainer :" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteRunStateFlexContainer", TestReport.Status.KO, "expected errorCode:" + ResponseStatusCode.NOT_FOUND + ", found:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteRunStateFlexContainer", TestReport.Status.OK, null, null);
    }
}

