/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.DeviceSmartElectricMeterFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class SmartElectricMeterFlexContainerTest
extends FlexContainerTestSuite {
    public SmartElectricMeterFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "SmartElectricMeterFlexContainerTest";
    }

    public void testCreateAndRetrieveSmartElectricMeterFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "SmartElectricMeterFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceSmartElectricMeterFlexContainer flexContainer = new DeviceSmartElectricMeterFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setShortName("pDSNm");
        serialNumberCA.setValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setShortName("proLn");
        locationCA.setValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setShortName("prDMr");
        deviceManufacturerCA.setValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setShortName("proPl");
        protocolCA.setValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setShortName("pDMNe");
        deviceModelCA.setValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        CustomAttribute measuringScopeCA = new CustomAttribute();
        measuringScopeCA.setShortName("meaSe");
        measuringScopeCA.setValue("Room");
        flexContainer.getCustomAttributes().add(measuringScopeCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        DeviceSmartElectricMeterFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.KO, "unable to create SmartElectricMeter FlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (DeviceSmartElectricMeterFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.KO, "invalid name.Expecting: " + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.KO, "unable to retrieve SmartElectricMeter FlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceSmartElectricMeterFlexContainer retrievedFlexContainer = (DeviceSmartElectricMeterFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveSmartElectricMeterFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteSmartElectricMeterFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "SmartElectricMeterFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceSmartElectricMeterFlexContainer flexContainer = new DeviceSmartElectricMeterFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setShortName("pDSNm");
        serialNumberCA.setValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setShortName("proLn");
        locationCA.setValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setShortName("prDMr");
        deviceManufacturerCA.setValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setShortName("proPl");
        protocolCA.setValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setShortName("pDMNe");
        deviceModelCA.setValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        CustomAttribute measuringScopeCA = new CustomAttribute();
        measuringScopeCA.setShortName("meaSe");
        measuringScopeCA.setValue("Room");
        flexContainer.getCustomAttributes().add(measuringScopeCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteSmartElectricMeterFlexContainer", TestReport.Status.KO, "unable to create SmartElectricMeter FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteSmartElectricMeterFlexContainer", TestReport.Status.KO, "unable to delete SmartElectricMeter FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteSmartElectricMeterFlexContainer", TestReport.Status.KO, "Expecting:" + ResponseStatusCode.NOT_FOUND + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteSmartElectricMeterFlexContainer", TestReport.Status.OK, null, null);
    }
}

