/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Anemometer
extends Module {
    private FloatDataPoint speed;

    public Anemometer(String name, Domain domain, FloatDataPoint speed) {
        super(name, domain, (Identifiers)ModuleType.anemometer);
        if (speed == null || !speed.getShortName().equals(DatapointType.speed.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong speed datapoint: " + speed);
        }
        this.speed = speed;
        this.speed.setWritable(false);
        this.speed.setDoc("The unit of measure of the speed is \"dB2\".");
        this.addDataPoint((DataPoint)this.speed);
    }

    public Anemometer(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.loudness.getShortName()));
    }

    public float getSpeed() throws DataPointException, AccessException {
        return ((Float)this.speed.getValue()).floatValue();
    }
}

