/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.DeviceFloodDetectorFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class FloodDetectorFlexContainerTest
extends FlexContainerTestSuite {
    public FloodDetectorFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "FloodDetectorFlexContainerTest";
    }

    public void testCreateAndRetrieveFloodDetectorFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "FloodDetectorFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceFloodDetectorFlexContainer flexContainer = new DeviceFloodDetectorFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setShortName("pDSNm");
        serialNumberCA.setValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setShortName("proLn");
        locationCA.setValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setShortName("prDMr");
        deviceManufacturerCA.setValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setShortName("proPl");
        protocolCA.setValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setShortName("pDMNe");
        deviceModelCA.setValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        DeviceFloodDetectorFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.KO, "unable to create FloodDetector FlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (DeviceFloodDetectorFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.KO, "invalid name.Expecting: " + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.KO, "unable to retrieve FloodDetector FlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceFloodDetectorFlexContainer retrievedFlexContainer = (DeviceFloodDetectorFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveFloodDetectorFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteFloodDetectorFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "FloodDetectorFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceFloodDetectorFlexContainer flexContainer = new DeviceFloodDetectorFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setShortName("pDSNm");
        serialNumberCA.setValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setShortName("proLn");
        locationCA.setValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setShortName("prDMr");
        deviceManufacturerCA.setValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setShortName("proPl");
        protocolCA.setValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setShortName("pDMNe");
        deviceModelCA.setValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteFloodDetectorFlexContainer", TestReport.Status.KO, "unable to create FloodDetector FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteFloodDetectorFlexContainer", TestReport.Status.KO, "unable to delete FloodDetector FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteFloodDetectorFlexContainer", TestReport.Status.KO, "Expecting:" + ResponseStatusCode.NOT_FOUND + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteFloodDetectorFlexContainer", TestReport.Status.OK, null, null);
    }
}

