/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.DeviceLightFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class LightFlexContainerTest
extends FlexContainerTestSuite {
    public LightFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "LightFlexContainerTest";
    }

    public void testCreateAndRetrieveLightFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "LightFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceLightFlexContainer flexContainer = new DeviceLightFlexContainer();
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("Orange");
        CustomAttribute illuminanceLevelCustomAttribute = new CustomAttribute();
        illuminanceLevelCustomAttribute.setShortName("illuminanceLevel");
        illuminanceLevelCustomAttribute.setValue("90");
        flexContainer.getCustomAttributes().add(illuminanceLevelCustomAttribute);
        CustomAttribute illuminanceStepLevelCustomAttribute = new CustomAttribute();
        illuminanceStepLevelCustomAttribute.setShortName("illuminanceStepLevel");
        illuminanceStepLevelCustomAttribute.setValue("1");
        flexContainer.getCustomAttributes().add(illuminanceStepLevelCustomAttribute);
        CustomAttribute modeCustomAttribute = new CustomAttribute();
        modeCustomAttribute.setShortName("mode");
        modeCustomAttribute.setValue("normal");
        flexContainer.getCustomAttributes().add(modeCustomAttribute);
        CustomAttribute rgbColorSettingCustomAttribute = new CustomAttribute();
        rgbColorSettingCustomAttribute.setShortName("rgbColorSetting");
        rgbColorSettingCustomAttribute.setValue(new Integer(0x222222).toString());
        flexContainer.getCustomAttributes().add(rgbColorSettingCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, flexContainerName);
        DeviceLightFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "unable to create LightFlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (DeviceLightFlexContainer)response.getContent();
        if (!createdFlexContainer.getName().equals(flexContainerName)) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "wrong name. Expecting:" + flexContainerName + ", found: " + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "wrong OntologyRef: " + e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "wrong ContainerDefinition: " + e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "wrong OntologyRef: " + e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "wrong CustomAttribute: " + e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, "unable to retrieve LightFlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceLightFlexContainer retrievedFlexContainer = (DeviceLightFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveLightFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteLightFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "LightFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceLightFlexContainer flexContainer = new DeviceLightFlexContainer();
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("Orange");
        CustomAttribute illuminanceLevelCustomAttribute = new CustomAttribute();
        illuminanceLevelCustomAttribute.setShortName("illuminanceLevel");
        illuminanceLevelCustomAttribute.setValue("90");
        flexContainer.getCustomAttributes().add(illuminanceLevelCustomAttribute);
        CustomAttribute illuminanceStepLevelCustomAttribute = new CustomAttribute();
        illuminanceStepLevelCustomAttribute.setShortName("illuminanceStepLevel");
        illuminanceStepLevelCustomAttribute.setValue("1");
        flexContainer.getCustomAttributes().add(illuminanceStepLevelCustomAttribute);
        CustomAttribute modeCustomAttribute = new CustomAttribute();
        modeCustomAttribute.setShortName("mode");
        modeCustomAttribute.setValue("normal");
        flexContainer.getCustomAttributes().add(modeCustomAttribute);
        CustomAttribute rgbColorSettingCustomAttribute = new CustomAttribute();
        rgbColorSettingCustomAttribute.setShortName("rgbColorSetting");
        rgbColorSettingCustomAttribute.setValue(new Integer(0x222222).toString());
        flexContainer.getCustomAttributes().add(rgbColorSettingCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, flexContainerName);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteLightFlexContainer", TestReport.Status.KO, "unable to create LightFlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteLightFlexContainer", TestReport.Status.KO, "unable to delete LightFlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteLightFlexContainer", TestReport.Status.KO, "expecting:" + ResponseStatusCode.NOT_FOUND + ", received: " + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteLightFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateLightFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "LightFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceLightFlexContainer flexContainer = new DeviceLightFlexContainer();
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("Orange");
        CustomAttribute illuminanceLevelCustomAttribute = new CustomAttribute();
        illuminanceLevelCustomAttribute.setShortName("illuminanceLevel");
        illuminanceLevelCustomAttribute.setValue("90");
        flexContainer.getCustomAttributes().add(illuminanceLevelCustomAttribute);
        CustomAttribute illuminanceStepLevelCustomAttribute = new CustomAttribute();
        illuminanceStepLevelCustomAttribute.setShortName("illuminanceStepLevel");
        illuminanceStepLevelCustomAttribute.setValue("1");
        flexContainer.getCustomAttributes().add(illuminanceStepLevelCustomAttribute);
        CustomAttribute modeCustomAttribute = new CustomAttribute();
        modeCustomAttribute.setShortName("mode");
        modeCustomAttribute.setValue("normal");
        flexContainer.getCustomAttributes().add(modeCustomAttribute);
        CustomAttribute rgbColorSettingCustomAttribute = new CustomAttribute();
        rgbColorSettingCustomAttribute.setShortName("rgbColorSetting");
        rgbColorSettingCustomAttribute.setValue(new Integer(0x222222).toString());
        flexContainer.getCustomAttributes().add(rgbColorSettingCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, flexContainerName);
        DeviceLightFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, "unable to create LightFlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (DeviceLightFlexContainer)response.getContent();
        DeviceLightFlexContainer toBeUpdated = new DeviceLightFlexContainer();
        CustomAttribute illuminanceToBeUpdated = new CustomAttribute();
        illuminanceToBeUpdated.setShortName("illuminanceLevel");
        illuminanceToBeUpdated.setValue("85");
        toBeUpdated.getCustomAttributes().add(illuminanceToBeUpdated);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, "unable to update LightFlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceLightFlexContainer updatedFlexContainer = (DeviceLightFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, "expecting 1 CustomAttribute, found " + updatedFlexContainer.getCustomAttributes().size() + " CustomAttribute", null);
            return;
        }
        if (!updatedFlexContainer.getCustomAttribute("illuminanceLevel").getValue().equals(illuminanceToBeUpdated.getValue())) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, "wrong illuminanceLevel CustomAttribute value, expecting: " + illuminanceToBeUpdated.getValue() + ", found: " + updatedFlexContainer.getCustomAttribute("illuminanceLevel").getValue(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, "unable to retrieve LightFlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceLightFlexContainer retrievedFlexContainer = (DeviceLightFlexContainer)response.getContent();
        createdFlexContainer.getCustomAttribute("illuminanceLevel").setValue("85");
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testUpdateLightFlexContainer", TestReport.Status.OK, null, null);
    }
}

