/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.sdt.home.monitoring.authentication.service.AuthenticationService;
import org.eclipse.om2m.sdt.home.monitoring.servlet.AuthenticationServiceServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.CredentialsServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.HomeServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.InCseContextServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.LoginServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.LogoutServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.MyHttpContext;
import org.eclipse.om2m.sdt.home.monitoring.util.AeRegistration;
import org.eclipse.om2m.sdt.home.monitoring.util.ResourceDiscovery;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

@Component(name="home.monitoring.application", immediate=true, enabled=true)
public class Activator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    public String globalContext = System.getProperty("org.eclipse.om2m.globalContext", "");
    public static String uiContext = "";
    public static String sep = "/";
    private ServiceRegistration<InterworkingService> sr;
    private HttpService httpService;
    private CseService sclService;
    private List<AuthenticationService> authenticationServices = new ArrayList<AuthenticationService>();

    @Activate
    protected void activate(ComponentContext componentContext) {
        if (uiContext.equals("/")) {
            sep = "";
        }
        AeRegistration.getInstance().setCseService(this.sclService);
        AeRegistration.getInstance().createAe();
        this.sr = componentContext.getBundleContext().registerService(InterworkingService.class, (Object)AeRegistration.getInstance(), null);
        ResourceDiscovery.initCseService(this.sclService);
        try {
            LOGGER.info((Object)("Register test " + uiContext + sep + "Home_Monitoring_Application http context"));
            MyHttpContext httpContext = new MyHttpContext(this.httpService.createDefaultHttpContext());
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application", (Servlet)new HomeServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/authentication_servlet", (Servlet)new AuthenticationServiceServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/in-cse/context", (Servlet)new InCseContextServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/login", (Servlet)new LoginServlet(this), null, (HttpContext)httpContext);
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/cred", (Servlet)new CredentialsServlet(), null, (HttpContext)httpContext);
            this.httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/logout", (Servlet)new LogoutServlet(), null, (HttpContext)httpContext);
            this.httpService.registerResources(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/webapps", String.valueOf(uiContext) + sep + "webapps", (HttpContext)httpContext);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error registring webapp servlet", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister(String.valueOf(uiContext) + sep + "Home_Monitoring_Application");
        this.sr.unregister();
        AeRegistration.getInstance().deleteAe();
        AeRegistration.getInstance().setCseService(null);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unbindHttpService")
    protected void bindHttpService(HttpService pHttpService) {
        this.httpService = pHttpService;
    }

    protected void unbindHttpService(HttpService pHttpService) {
        this.httpService = null;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unbindCseService")
    protected void bindCseService(CseService pCseService) {
        this.sclService = pCseService;
    }

    protected void unbindCseService(CseService pCseService) {
        this.sclService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbindAuthenticationService")
    protected void bindAuthenticationService(AuthenticationService authenticationService) {
        List<AuthenticationService> list = this.authenticationServices;
        synchronized (list) {
            this.authenticationServices.add(authenticationService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindAuthenticationService(AuthenticationService authenticationService) {
        List<AuthenticationService> list = this.authenticationServices;
        synchronized (list) {
            this.authenticationServices.remove(authenticationService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuthenticationService> getAuthenticationServices() {
        ArrayList<AuthenticationService> toBeReturned = new ArrayList<AuthenticationService>();
        List<AuthenticationService> list = this.authenticationServices;
        synchronized (list) {
            toBeReturned.addAll(this.authenticationServices);
        }
        return toBeReturned;
    }
}

