/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class AbstractAlarmSensor
extends Module {
    private BooleanDataPoint alarm;

    public AbstractAlarmSensor(String name, Domain domain, BooleanDataPoint alarm, ModuleType type) {
        this(name, domain, alarm, type, "True = Sensed, False = Not Sensed");
    }

    public AbstractAlarmSensor(String name, Domain domain, BooleanDataPoint alarm, ModuleType type, String doc) {
        super(name, domain, (Identifiers)type);
        if (alarm == null || !alarm.getShortName().equals(DatapointType.alarm.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong alarm datapoint: " + alarm);
        }
        this.alarm = alarm;
        this.alarm.setWritable(false);
        this.alarm.setDoc(doc);
        this.addDataPoint((DataPoint)this.alarm);
    }

    public boolean getAlarm() throws DataPointException, AccessException {
        return (Boolean)this.alarm.getValue();
    }
}

