/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Credentials
extends Module {
    private StringDataPoint loginName;
    private StringDataPoint password;
    private StringDataPoint token;

    public Credentials(String name, Domain domain) {
        super(name, domain, (Identifiers)ModuleType.credentials);
    }

    public Credentials(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain);
        StringDataPoint dp = (StringDataPoint)dps.get(DatapointType.loginName.getShortName());
        if (dp != null) {
            this.setLoginName(dp);
        }
        if ((dp = (StringDataPoint)dps.get(DatapointType.password.getShortName())) != null) {
            this.setPassword(dp);
        }
        if ((dp = (StringDataPoint)dps.get(DatapointType.token.getShortName())) != null) {
            this.setToken(dp);
        }
    }

    public void setLoginName(StringDataPoint dp) {
        this.loginName = dp;
        this.loginName.setOptional(true);
        this.loginName.setReadable(false);
        this.loginName.setWritable(true);
        this.loginName.setDoc("The user\u2019s login name.");
        this.addDataPoint((DataPoint)this.loginName);
    }

    public void setLoginName(String s) throws DataPointException, AccessException {
        if (this.loginName == null) {
            throw new DataPointException("Not implemented");
        }
        this.loginName.setValue((Object)s);
    }

    public void setPassword(StringDataPoint dp) {
        this.password = dp;
        this.password.setOptional(true);
        this.password.setReadable(false);
        this.password.setWritable(true);
        this.password.setDoc("The user\u2019s password.");
        this.addDataPoint((DataPoint)this.password);
    }

    public void setPassword(String s) throws DataPointException, AccessException {
        if (this.password == null) {
            throw new DataPointException("Not implemented");
        }
        this.password.setValue((Object)s);
    }

    public void setToken(StringDataPoint dp) {
        this.token = dp;
        this.token.setOptional(true);
        this.token.setReadable(false);
        this.token.setWritable(true);
        this.token.setDoc("An authentication token, for example an OAuth token.");
        this.addDataPoint((DataPoint)this.token);
    }

    public void setToken(String s) throws DataPointException, AccessException {
        if (this.token == null) {
            throw new DataPointException("Not implemented");
        }
        this.token.setValue((Object)s);
    }
}

