/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Date;
import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.datapoints.TimeDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Timer
extends Module {
    private IntegerDataPoint referenceTimer;
    private IntegerDataPoint targetTimeToStart;
    private IntegerDataPoint targetTimeToStop;
    private IntegerDataPoint estimatedTimeToEnd;
    private IntegerDataPoint runningTime;
    private IntegerDataPoint targetDuration;
    private TimeDataPoint absoluteStartTime;
    private TimeDataPoint absoluteStopTime;

    public Timer(String name, Domain domain) {
        super(name, domain, (Identifiers)ModuleType.timer);
    }

    public Timer(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain);
        IntegerDataPoint targetDuration;
        IntegerDataPoint runningTime;
        IntegerDataPoint estimatedTimeToEnd;
        IntegerDataPoint targetTimeToStop;
        IntegerDataPoint targetTimeToStart;
        IntegerDataPoint referenceTimer = (IntegerDataPoint)dps.get(DatapointType.referenceTimer.getShortName());
        if (referenceTimer != null) {
            this.setReferenceTimer(referenceTimer);
        }
        if ((targetTimeToStart = (IntegerDataPoint)dps.get(DatapointType.targetTimeToStart.getShortName())) != null) {
            this.setTargetTimeToStart(targetTimeToStart);
        }
        if ((targetTimeToStop = (IntegerDataPoint)dps.get(DatapointType.targetTimeToStop.getShortName())) != null) {
            this.setTargetTimeToStop(targetTimeToStop);
        }
        if ((estimatedTimeToEnd = (IntegerDataPoint)dps.get(DatapointType.estimatedTimeToEnd.getShortName())) != null) {
            this.setEstimatedTimeToEnd(estimatedTimeToEnd);
        }
        if ((runningTime = (IntegerDataPoint)dps.get(DatapointType.runningTime.getShortName())) != null) {
            this.setRunningTime(runningTime);
        }
        if ((targetDuration = (IntegerDataPoint)dps.get(DatapointType.targetDuration.getShortName())) != null) {
            this.setTargetDuration(targetDuration);
        }
    }

    public void setReferenceTimer(IntegerDataPoint dp) {
        this.referenceTimer = dp;
        this.referenceTimer.setOptional(true);
        this.referenceTimer.setWritable(false);
        this.referenceTimer.setDoc("...");
        this.addDataPoint((DataPoint)this.referenceTimer);
    }

    public int getReferenceTimer() throws DataPointException, AccessException {
        if (this.referenceTimer == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.referenceTimer.getValue();
    }

    public void setTargetTimeToStart(IntegerDataPoint dp) {
        this.targetTimeToStart = dp;
        this.targetTimeToStart.setOptional(true);
        this.targetTimeToStart.setDoc("...");
        this.addDataPoint((DataPoint)this.targetTimeToStart);
    }

    public int getTargetTimeToStart() throws DataPointException, AccessException {
        if (this.targetTimeToStart == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.targetTimeToStart.getValue();
    }

    public void setTargetTimeToStart(int b) throws DataPointException, AccessException {
        if (this.targetTimeToStart == null) {
            throw new DataPointException("Not implemented");
        }
        this.targetTimeToStart.setValue((Object)b);
    }

    public void setTargetTimeToStop(IntegerDataPoint dp) {
        this.targetTimeToStop = dp;
        this.targetTimeToStop.setOptional(true);
        this.targetTimeToStop.setDoc("...");
        this.addDataPoint((DataPoint)this.targetTimeToStop);
    }

    public int getTargetTimeToStop() throws DataPointException, AccessException {
        if (this.targetTimeToStop == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.targetTimeToStop.getValue();
    }

    public void setTargetTimeToStop(int b) throws DataPointException, AccessException {
        if (this.targetTimeToStop == null) {
            throw new DataPointException("Not implemented");
        }
        this.targetTimeToStop.setValue((Object)b);
    }

    public void setEstimatedTimeToEnd(IntegerDataPoint dp) {
        this.estimatedTimeToEnd = dp;
        this.estimatedTimeToEnd.setOptional(true);
        this.estimatedTimeToEnd.setWritable(false);
        this.estimatedTimeToEnd.setDoc("...");
        this.addDataPoint((DataPoint)this.estimatedTimeToEnd);
    }

    public int getEstimatedTimeToEnd() throws DataPointException, AccessException {
        if (this.estimatedTimeToEnd == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.estimatedTimeToEnd.getValue();
    }

    public void setRunningTime(IntegerDataPoint dp) {
        this.runningTime = dp;
        this.runningTime.setOptional(true);
        this.runningTime.setWritable(false);
        this.runningTime.setDoc("...");
        this.addDataPoint((DataPoint)this.runningTime);
    }

    public int getRunningTime() throws DataPointException, AccessException {
        if (this.runningTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.runningTime.getValue();
    }

    public void setTargetDuration(IntegerDataPoint dp) {
        this.targetDuration = dp;
        this.targetDuration.setOptional(true);
        this.targetDuration.setWritable(false);
        this.targetDuration.setDoc("...");
        this.addDataPoint((DataPoint)this.targetDuration);
    }

    public int getTargetDuration() throws DataPointException, AccessException {
        if (this.targetDuration == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.targetDuration.getValue();
    }

    public void setAbsoluteStartTime(TimeDataPoint dp) {
        this.absoluteStartTime = dp;
        this.absoluteStartTime.setOptional(true);
        this.absoluteStartTime.setDoc("...");
        this.addDataPoint((DataPoint)this.absoluteStartTime);
    }

    public Date getAbsoluteStartTime() throws DataPointException, AccessException {
        if (this.absoluteStartTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Date)this.absoluteStartTime.getValue();
    }

    public void setAbsoluteStartTime(long b) throws DataPointException, AccessException {
        if (this.absoluteStartTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStartTime.setValue(b);
    }

    public void setAbsoluteStartTime(Date d) throws DataPointException, AccessException {
        if (this.absoluteStartTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStartTime.setValue((Object)d);
    }

    public void setAbsoluteStartTime(String d) throws DataPointException, AccessException {
        if (this.absoluteStartTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStartTime.setValue(d);
    }

    public void setAbsoluteStopTime(TimeDataPoint dp) {
        this.absoluteStopTime = dp;
        this.absoluteStopTime.setOptional(true);
        this.absoluteStopTime.setDoc("...");
        this.addDataPoint((DataPoint)this.absoluteStopTime);
    }

    public Date getAbsoluteStopTime() throws DataPointException, AccessException {
        if (this.absoluteStopTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Date)this.absoluteStopTime.getValue();
    }

    public void setAbsoluteStopTime(long b) throws DataPointException, AccessException {
        if (this.absoluteStopTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStopTime.setValue(b);
    }

    public void setAbsoluteStopTime(Date d) throws DataPointException, AccessException {
        if (this.absoluteStopTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStopTime.setValue((Object)d);
    }

    public void setAbsoluteStopTime(String d) throws DataPointException, AccessException {
        if (this.absoluteStopTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.absoluteStopTime.setValue(d);
    }
}

