/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.om2m.commons.constants.DiscoveryResultType;
import org.eclipse.om2m.commons.constants.FilterUsage;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.entities.UriMapperEntity;
import org.eclipse.om2m.commons.exceptions.AccessDeniedException;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.OperationNotAllowed;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.DynAuthTokenReqInfo;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.URIList;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.persistence.service.DAO;

public class DiscoveryController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        throw new OperationNotAllowed("Delete of Discovery is not allowed");
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Root resource not found for discovery");
        }
        ResourceEntity resourceEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        response = new ResponsePrimitive(request);
        FilterCriteria filter = request.getFilterCriteria();
        if (filter.getFilterUsage().equals(FilterUsage.EVENT_NOTIFICATION_CRITERIA)) {
            throw new NotImplementedException("Event notification criteria is not implemented");
        }
        if (filter.getFilterUsage().intValue() > FilterUsage.EVENT_NOTIFICATION_CRITERIA.intValue()) {
            throw new BadRequestException("Incorrect FilterUsage value (fu)");
        }
        if (request.getDiscoveryResultType() == null) {
            request.setDiscoveryResultType(DiscoveryResultType.HIERARCHICAL);
        }
        if (request.getDiscoveryResultType().equals(DiscoveryResultType.CSEID_AND_RESOURCEID)) {
            throw new NotImplementedException();
        }
        if (request.getDiscoveryResultType().intValue() > DiscoveryResultType.CSEID_AND_RESOURCEID.intValue()) {
            throw new BadRequestException("Incorrect discovery result type provided");
        }
        List<UriMapperEntity> childUris = new ArrayList();
        if (!filter.getLabels().isEmpty()) {
            HashSet<UriMapperEntity> allFoundUriEntities = new HashSet<UriMapperEntity>();
            int limit = filter.getLimit() != null ? filter.getLimit().intValue() : -1;
            block2: for (String label : filter.getLabels()) {
                LabelEntity labelEntity = (LabelEntity)this.dbs.getDAOFactory().getLabelDAO().find(this.transaction, (Object)label);
                if (labelEntity == null) continue;
                List<ResourceEntity> allFoundResources = this.stackLabelResources(labelEntity, filter.getResourceType(), resourceEntity.getHierarchicalURI());
                for (ResourceEntity resEntity : allFoundResources) {
                    UriMapperEntity uriEntity = new UriMapperEntity();
                    uriEntity.setHierarchicalUri(resEntity.getHierarchicalURI());
                    uriEntity.setNonHierarchicalUri(resEntity.getResourceID());
                    uriEntity.setResourceType(resEntity.getResourceType());
                    allFoundUriEntities.add(uriEntity);
                    if (limit != -1 && allFoundUriEntities.size() == limit) continue block2;
                }
            }
            childUris.addAll(allFoundUriEntities);
        } else {
            childUris = this.dbs.getDBUtilManager().getComplexFindUtil().getChildUrisDis(request.getTo(), filter);
        }
        URIList uriList = new URIList();
        uriList.getListOfUri();
        DynAuthTokenReqInfo tokenReqInfo = null;
        for (UriMapperEntity uriEntity : childUris) {
            LOGGER.debug((Object)("check URI " + uriEntity.getHierarchicalUri()));
            if (filter.getLimit() != null && uriList.getListOfUri().size() == filter.getLimit().intValue()) break;
            DAO<?> currentDao = patterns.getDAO(uriEntity.getNonHierarchicalUri(), this.dbs);
            ResourceEntity currentResourceEntity = (ResourceEntity)currentDao.find(this.transaction, (Object)uriEntity.getNonHierarchicalUri());
            if (currentResourceEntity == null) continue;
            List<AccessControlPolicyEntity> acps = this.getAcpsFromEntity(currentResourceEntity);
            try {
                this.checkPermissions(request, currentResourceEntity, acps);
                if (request.getDiscoveryResultType().equals(DiscoveryResultType.HIERARCHICAL)) {
                    if (uriList.getListOfUri().contains(uriEntity.getHierarchicalUri())) continue;
                    uriList.getListOfUri().add(uriEntity.getHierarchicalUri());
                    continue;
                }
                if (uriList.getListOfUri().contains(uriEntity.getNonHierarchicalUri())) continue;
                uriList.getListOfUri().add(uriEntity.getNonHierarchicalUri());
            }
            catch (AccessDeniedException e) {
                LOGGER.warn((Object)("Access denied for " + currentResourceEntity + ": " + e.getMessage()));
                if (tokenReqInfo != null) {
                    if (e.getDynAuthTokenReqInfo() == null) continue;
                    tokenReqInfo.getDasInfo().addAll(e.getDynAuthTokenReqInfo().getDasInfo());
                    continue;
                }
                tokenReqInfo = e.getDynAuthTokenReqInfo();
            }
        }
        LOGGER.debug((Object)("checked URIs " + uriList.getListOfUri()));
        if (uriList.getListOfUri().isEmpty() && tokenReqInfo != null) {
            throw new AccessDeniedException(tokenReqInfo);
        }
        response.setContent((Object)uriList);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        throw new OperationNotAllowed("Update of Discovery is not allowed");
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        throw new OperationNotAllowed("Delete of Discovery is not allowed");
    }

    private List<AccessControlPolicyEntity> getAcpsFromEntity(ResourceEntity resourceEntity) {
        int ty = resourceEntity.getResourceType().intValue();
        switch (ty) {
            case 1: {
                return Arrays.asList((AccessControlPolicyEntity)resourceEntity);
            }
            case 2: {
                return ((AeEntity)resourceEntity).getAccessControlPolicies();
            }
            case 10002: {
                return ((AeAnncEntity)resourceEntity).getAccessControlPolicies();
            }
            case 34: {
                return ((DynamicAuthorizationConsultationEntity)resourceEntity).getAccessControlPolicies();
            }
            case 3: {
                return ((ContainerEntity)resourceEntity).getAccessControlPolicies();
            }
            case 4: {
                return ((ContentInstanceEntity)resourceEntity).getAcpListFromParent();
            }
            case 9: {
                return ((GroupEntity)resourceEntity).getAccessControlPolicies();
            }
            case 16: {
                return ((RemoteCSEEntity)resourceEntity).getAccessControlPolicies();
            }
            case 5: {
                return ((CSEBaseEntity)resourceEntity).getAccessControlPolicies();
            }
            case 23: {
                return ((SubscriptionEntity)resourceEntity).getAccessControlPolicies();
            }
            case 28: {
                return ((FlexContainerEntity)resourceEntity).getAccessControlPolicies();
            }
            case 10028: {
                return ((FlexContainerAnncEntity)resourceEntity).getAccessControlPolicies();
            }
            case 14: {
                return ((NodeEntity)resourceEntity).getAccessControlPolicies();
            }
            case 10014: {
                return ((NodeAnncEntity)resourceEntity).getAccessControlPolicies();
            }
            case 13: {
                return ((MgmtObjEntity)resourceEntity).getAccessControlPolicies();
            }
            case 10013: {
                return ((MgmtObjAnncEntity)resourceEntity).getAccessControlPolicies();
            }
        }
        return null;
    }

    private List<ResourceEntity> stackLabelResources(LabelEntity labelEntity, BigInteger rty, String baseUri) {
        ArrayList<ResourceEntity> result = new ArrayList<ResourceEntity>();
        if (rty != null) {
            switch (rty.intValue()) {
                case 2: {
                    result.addAll(labelEntity.getLinkedAe());
                    break;
                }
                case 10002: {
                    result.addAll(labelEntity.getLinkedAeA());
                    break;
                }
                case 4: {
                    result.addAll(labelEntity.getLinkedCin());
                    break;
                }
                case 3: {
                    result.addAll(labelEntity.getLinkedCnt());
                    break;
                }
                case 9: {
                    result.addAll(labelEntity.getLinkedGroup());
                    break;
                }
                case 16: {
                    result.addAll(labelEntity.getLinkedCsr());
                    break;
                }
                case 5: {
                    result.addAll(labelEntity.getLinkedCsb());
                    break;
                }
                case 28: {
                    result.addAll(labelEntity.getLinkedFcnt());
                    break;
                }
                case 10028: {
                    result.addAll(labelEntity.getLinkedFcntA());
                    break;
                }
                case 1: {
                    result.addAll(labelEntity.getLinkedACP());
                    break;
                }
                case 14: {
                    result.addAll(labelEntity.getLinkedNodes());
                    break;
                }
                case 10014: {
                    result.addAll(labelEntity.getLinkedNodesA());
                    break;
                }
                case 13: {
                    result.addAll(labelEntity.getLinkedAni());
                    result.addAll(labelEntity.getLinkedAndi());
                    result.addAll(labelEntity.getLinkedDvi());
                    break;
                }
                case 10013: {
                    result.addAll(labelEntity.getLinkedAniA());
                    result.addAll(labelEntity.getLinkedAndiA());
                    result.addAll(labelEntity.getLinkedDviA());
                    break;
                }
                case 23: {
                    result.addAll(labelEntity.getLinkedSub());
                    break;
                }
            }
        } else {
            result.addAll(labelEntity.getLinkedAe());
            result.addAll(labelEntity.getLinkedAeA());
            result.addAll(labelEntity.getLinkedCin());
            result.addAll(labelEntity.getLinkedCnt());
            result.addAll(labelEntity.getLinkedGroup());
            result.addAll(labelEntity.getLinkedCsr());
            result.addAll(labelEntity.getLinkedCsb());
            result.addAll(labelEntity.getLinkedFcnt());
            result.addAll(labelEntity.getLinkedFcntA());
            result.addAll(labelEntity.getLinkedACP());
            result.addAll(labelEntity.getLinkedNodes());
            result.addAll(labelEntity.getLinkedNodesA());
            result.addAll(labelEntity.getLinkedAni());
            result.addAll(labelEntity.getLinkedAniA());
            result.addAll(labelEntity.getLinkedAndi());
            result.addAll(labelEntity.getLinkedAndiA());
            result.addAll(labelEntity.getLinkedDvi());
            result.addAll(labelEntity.getLinkedDviA());
            result.addAll(labelEntity.getLinkedSub());
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ResourceEntity re = (ResourceEntity)it.next();
            if (re.getHierarchicalURI().startsWith(baseUri)) continue;
            it.remove();
        }
        return result;
    }
}

