/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Kettle;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedBinarySwitch;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedFaultDetection;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedTemperature;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.LiquidLevel;
import org.osgi.framework.ServiceRegistration;

public class MockedKettle
extends Kettle
implements MockedDevice {
    private static final int MIN = 15;
    private static final int MAX = 35;
    private List<ServiceRegistration> serviceRegistrations;
    private float temp;
    private Temperature temperature;
    private boolean running;
    private int delta;

    public MockedKettle(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.addModule(new MockedFaultDetection("faultDetection_" + id, domain));
        this.addModule(new MockedBinarySwitch("binarySwitch_" + id, domain));
        this.temperature = new MockedTemperature("temperature_" + id, domain, new FloatDataPoint((Identifiers)DatapointType.currentTemperature){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedKettle.this.temp);
            }
        });
        this.addModule(this.temperature);
        this.addModule(new org.eclipse.om2m.sdt.home.modules.LiquidLevel("LiquidLevel_" + this.getId(), domain, new LiquidLevel(){

            public LiquidLevel.Values doGetValue() throws DataPointException {
                return LiquidLevel.Values.values()[(int)(Math.random() * 5.0)];
            }
        }));
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

