/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.http;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.Attribute;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;

public class RestHttpClient
implements RestClientService {
    private static Log LOGGER = LogFactory.getLog(RestHttpClient.class);
    private static String protocol = "http";

    public String getProtocol() {
        return protocol;
    }

    public ResponsePrimitive sendRequest(RequestPrimitive requestPrimitive) {
        LOGGER.info((Object)("Sending request: " + requestPrimitive));
        CloseableHttpClient httpClient = HttpClientBuilder.create().disableAutomaticRetries().useSystemProperties().build();
        ResponsePrimitive responsePrimitive = new ResponsePrimitive(requestPrimitive);
        HttpPost method = null;
        String url = requestPrimitive.getTo();
        if (!url.startsWith(protocol)) {
            url = url.startsWith("://") ? String.valueOf(protocol) + url : (url.startsWith("//") ? String.valueOf(protocol) + ":" + url : String.valueOf(protocol) + "://" + url);
        }
        Map<String, List<String>> parameters = this.getParameters(requestPrimitive);
        parameters.putAll(requestPrimitive.getQueryStrings());
        if (!parameters.isEmpty()) {
            String queryString = "";
            for (String parameter : parameters.keySet()) {
                for (String string : parameters.get(parameter)) {
                    queryString = String.valueOf(queryString) + "&" + parameter + "=" + string;
                }
            }
            queryString = queryString.replaceFirst("&", "?");
            LOGGER.info((Object)("Query string generated: " + queryString));
            url = String.valueOf(url) + queryString;
        }
        try {
            BigInteger operation = requestPrimitive.getOperation();
            if (operation != null) {
                if (operation.equals(Operation.CREATE)) {
                    method = new HttpPost(url);
                    if (requestPrimitive.getContent() != null) {
                        method.setEntity((HttpEntity)new StringEntity((String)requestPrimitive.getContent()));
                    }
                } else if (operation.equals(Operation.RETRIEVE)) {
                    method = new HttpGet(url);
                } else if (operation.equals(Operation.UPDATE)) {
                    method = new HttpPut(url);
                    if (requestPrimitive.getContent() != null) {
                        ((HttpPut)method).setEntity((HttpEntity)new StringEntity((String)requestPrimitive.getContent()));
                    }
                } else if (operation.equals(Operation.DELETE)) {
                    method = new HttpDelete(url);
                } else if (operation.equals(Operation.NOTIFY)) {
                    method = new HttpPost(url);
                    if (requestPrimitive.getContent() != null) {
                        method.setEntity((HttpEntity)new StringEntity((String)requestPrimitive.getContent()));
                    }
                }
            } else {
                return null;
            }
            try {
                method.addHeader("Accept", requestPrimitive.getReturnContentType());
                String contentTypeHeader = requestPrimitive.getRequestContentType();
                if (requestPrimitive.getRequestIdentifier() != null) {
                    method.addHeader("X-M2M-RI", requestPrimitive.getRequestIdentifier());
                }
                if (requestPrimitive.getFrom() != null) {
                    method.addHeader("X-M2M-Origin", requestPrimitive.getFrom());
                }
                if (!requestPrimitive.getHttpHeaders().isEmpty()) {
                    for (String httpHeaderKey : requestPrimitive.getHttpHeaders().keySet()) {
                        method.addHeader(httpHeaderKey, (String)requestPrimitive.getHttpHeaders().get(httpHeaderKey));
                    }
                }
                if (requestPrimitive.getResourceType() != null) {
                    contentTypeHeader = String.valueOf(contentTypeHeader) + ";ty=" + requestPrimitive.getResourceType().toString();
                }
                method.addHeader("Content-Type", contentTypeHeader);
                if (requestPrimitive.getResponseTypeInfo() != null) {
                    String uris = "";
                    for (String string : requestPrimitive.getResponseTypeInfo().getNotificationURI()) {
                        uris = String.valueOf(uris) + "&" + string;
                    }
                    uris = uris.replaceFirst("&", "");
                    method.addHeader("X-M2M-RTU", uris);
                }
                LOGGER.info((Object)("Request to be send: " + method.toString()));
                String headers = "";
                Header[] headerArray = method.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    headers = String.valueOf(headers) + header.toString() + "\n";
                    ++n2;
                }
                LOGGER.info((Object)("Headers:\n" + headers));
                CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)method);
                int statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
                if (closeableHttpResponse.getFirstHeader("X-M2M-RSC") != null) {
                    responsePrimitive.setResponseStatusCode(new BigInteger(closeableHttpResponse.getFirstHeader("X-M2M-RSC").getValue()));
                } else {
                    responsePrimitive.setResponseStatusCode(this.getResponseStatusCode((HttpResponse)closeableHttpResponse, statusCode));
                }
                if (statusCode != 204 && closeableHttpResponse.getEntity() != null) {
                    responsePrimitive.setContent((Object)Util.convertStreamToString((InputStream)closeableHttpResponse.getEntity().getContent()));
                    if (closeableHttpResponse.getFirstHeader("Content-Type") != null) {
                        responsePrimitive.setContentType(closeableHttpResponse.getFirstHeader("Content-Type").getValue());
                    }
                }
                if (statusCode == 201) {
                    String contentHeader = "";
                    Header[] headerArray2 = closeableHttpResponse.getHeaders("Content-Location");
                    int n3 = headerArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Header header = headerArray2[n4];
                        contentHeader = String.valueOf(contentHeader) + header.getValue();
                        ++n4;
                    }
                    responsePrimitive.setLocation(contentHeader);
                }
                LOGGER.info((Object)("Http Client response: " + responsePrimitive));
            }
            catch (HttpHostConnectException httpHostConnectException) {
                LOGGER.info((Object)("Target is not reachable: " + requestPrimitive.getTo()));
                responsePrimitive.setResponseStatusCode(ResponseStatusCode.TARGET_NOT_REACHABLE);
                responsePrimitive.setContent((Object)("Target is not reachable: " + requestPrimitive.getTo()));
                responsePrimitive.setContentType("text/plain");
            }
            catch (IOException e) {
                LOGGER.error((Object)(String.valueOf(url) + " not found"), (Throwable)e);
                responsePrimitive.setResponseStatusCode(ResponseStatusCode.TARGET_NOT_REACHABLE);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                LOGGER.trace((Object)"Fail closing the http client", (Throwable)e);
            }
        }
        return responsePrimitive;
    }

    private Map<String, List<String>> getParameters(RequestPrimitive request) {
        ArrayList<String> list;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (request.getResultContent() != null) {
            list = new ArrayList<String>();
            list.add(request.getResultContent().toString());
            map.put("rcn", list);
        }
        if (request.getDiscoveryResultType() != null) {
            list = new ArrayList();
            list.add(request.getDiscoveryResultType().toString());
            map.put("drt", list);
        }
        if (request.getFilterCriteria() != null) {
            FilterCriteria filter = request.getFilterCriteria();
            if (!filter.getAttribute().isEmpty()) {
                for (Attribute att : filter.getAttribute()) {
                    list = new ArrayList();
                    list.add(att.getValue().toString());
                    map.put(att.getName(), list);
                }
            }
            if (!filter.getContentType().isEmpty()) {
                list = new ArrayList();
                list.addAll(filter.getContentType());
                map.put("cty", list);
            }
            if (filter.getCreatedAfter() != null) {
                list = new ArrayList();
                list.add(filter.getCreatedAfter());
                map.put("cra", list);
            }
            if (filter.getCreatedBefore() != null) {
                list = new ArrayList();
                list.add(filter.getCreatedBefore());
                map.put("crb", list);
            }
            if (filter.getExpireAfter() != null) {
                list = new ArrayList();
                list.add(filter.getExpireAfter());
                map.put("exa", list);
            }
            if (filter.getExpireBefore() != null) {
                list = new ArrayList();
                list.add(filter.getExpireBefore());
                map.put("exb", list);
            }
            if (filter.getFilterUsage() != null) {
                list = new ArrayList();
                list.add(filter.getFilterUsage().toString());
                map.put("fu", list);
            }
            if (!filter.getLabels().isEmpty()) {
                list = new ArrayList();
                list.addAll(filter.getLabels());
                map.put("lbl", list);
            }
            if (filter.getLimit() != null) {
                list = new ArrayList();
                list.add(filter.getLimit().toString());
                map.put("lim", list);
            }
            if (filter.getModifiedSince() != null) {
                list = new ArrayList();
                list.add(filter.getModifiedSince());
                map.put("ms", list);
            }
            if (filter.getResourceType() != null) {
                list = new ArrayList();
                list.add(filter.getResourceType().toString());
                map.put("ty", list);
            }
            if (filter.getSizeAbove() != null) {
                list = new ArrayList();
                list.add(filter.getSizeAbove().toString());
                map.put("sza", list);
            }
            if (filter.getSizeBelow() != null) {
                list = new ArrayList();
                list.add(filter.getSizeBelow().toString());
                map.put("szb", list);
            }
            if (filter.getStateTagBigger() != null) {
                list = new ArrayList();
                list.add(filter.getStateTagBigger().toString());
                map.put("stb", list);
            }
            if (filter.getStateTagSmaller() != null) {
                list = new ArrayList();
                list.add(filter.getStateTagSmaller().toString());
                map.put("sts", list);
            }
            if (filter.getUnmodifiedSince() != null) {
                list = new ArrayList();
                list.add(filter.getUnmodifiedSince());
                map.put("us", list);
            }
        }
        return map;
    }

    private BigInteger getResponseStatusCode(HttpResponse response, int statusCode) {
        if (response.getHeaders("X-M2M-RSC") != null && response.getHeaders("X-M2M-RSC").length > 0) {
            return new BigInteger(response.getHeaders("X-M2M-RSC")[0].getValue());
        }
        switch (statusCode) {
            case 200: {
                return ResponseStatusCode.OK;
            }
            case 202: {
                return ResponseStatusCode.ACCEPTED;
            }
            case 201: {
                return ResponseStatusCode.CREATED;
            }
            case 204: {
                return ResponseStatusCode.DELETED;
            }
            case 400: {
                return ResponseStatusCode.BAD_REQUEST;
            }
            case 403: {
                return ResponseStatusCode.ACCESS_DENIED;
            }
            case 404: {
                return ResponseStatusCode.NOT_FOUND;
            }
            case 405: {
                return ResponseStatusCode.OPERATION_NOT_ALLOWED;
            }
            case 409: {
                return ResponseStatusCode.CONFLICT;
            }
            case 500: {
                return ResponseStatusCode.INTERNAL_SERVER_ERROR;
            }
            case 501: {
                return ResponseStatusCode.NOT_IMPLEMENTED;
            }
            case 503: {
                return ResponseStatusCode.SERVICE_UNAVAILABLE;
            }
        }
        return ResponseStatusCode.INTERNAL_SERVER_ERROR;
    }

    private static String getQueryFromParams(Map<String, List<String>> params) {
        List<Object> values = new ArrayList();
        if (params != null) {
            String query = "?";
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                values = params.get(name);
                int i = 0;
                while (i < values.size()) {
                    query = String.valueOf(query) + name + "=" + (String)values.get(i) + "&";
                    ++i;
                }
            }
            return query;
        }
        return null;
    }
}

