/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.flexcontainerspec.ToggleFlexContainerAnnc;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_FlexContainerAnnc
extends AbstractDASServiceTest {
    public DASServiceTest_FlexContainerAnnc(CseService pCseService) {
        super("DasServiceTest_FlexContainerAnnc", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS(this.getDasAE().getResourceID());
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        RemoteCSE remoteCse = this.createRemoteCse();
        if (remoteCse == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a RemoteCse");
            return;
        }
        AEAnnc aeAnnc = this.createAeAnnc(remoteCse.getResourceID());
        if (aeAnnc == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a AeAnnc");
            return;
        }
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        BinarySwitchFlexContainerAnnc createdFlexContainerAnnc = this.createFlexContainerAnnc(aeAnnc.getResourceID(), dacis);
        if (createdFlexContainerAnnc == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create FlexContainerAnnc");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(createdFlexContainerAnnc.getResourceID(), "nom:password");
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainerAnnc, expecting " + ResponseStatusCode.OK + ", found =" + response.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainerAnnc.getResourceID(), "nom:password", Operation.RETRIEVE)) {
            return;
        }
        this.clearCalls();
        BinarySwitchFlexContainerAnnc toBeUpdated = new BinarySwitchFlexContainerAnnc();
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setCustomAttributeName("powSe");
        customAttribute.setCustomAttributeValue("true");
        createdFlexContainerAnnc.getCustomAttributes().add(customAttribute);
        RequestPrimitive updateRequest = new RequestPrimitive();
        updateRequest.setFrom("nom:prenom");
        updateRequest.setTo(createdFlexContainerAnnc.getResourceID());
        updateRequest.setOperation(Operation.UPDATE);
        updateRequest.setRequestContentType("application/obj");
        updateRequest.setReturnContentType("application/obj");
        updateRequest.setContent((Object)toBeUpdated);
        ResponsePrimitive updateResponse = this.getCseService().doRequest(updateRequest);
        if (updateResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("updateFlexContainerAnnc response is null");
            return;
        }
        if (!ResponseStatusCode.UPDATED.equals(updateResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to update FlexContainerAnnc, expecting " + ResponseStatusCode.UPDATED + ", found " + updateResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainerAnnc.getResourceID(), "nom:prenom", Operation.UPDATE)) {
            return;
        }
        this.clearCalls();
        ToggleFlexContainerAnnc flexContainerAnncChildToBeCreated = new ToggleFlexContainerAnnc();
        flexContainerAnncChildToBeCreated.setLink("/link" + UUID.randomUUID());
        flexContainerAnncChildToBeCreated.setName("FlexContainer_" + UUID.randomUUID());
        RequestPrimitive createChildRequest = new RequestPrimitive();
        createChildRequest.setContent((Object)flexContainerAnncChildToBeCreated);
        createChildRequest.setRequestContentType("application/obj");
        createChildRequest.setReturnContentType("application/obj");
        createChildRequest.setResourceType(10028);
        createChildRequest.setFrom("nana:nono");
        createChildRequest.setTo(createdFlexContainerAnnc.getResourceID());
        createChildRequest.setOperation(Operation.CREATE);
        ResponsePrimitive createChildResponse = this.getCseService().doRequest(createChildRequest);
        if (createChildResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("create child response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createChildResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a child FlexContainerAnnc, expecting " + ResponseStatusCode.CREATED + ", found " + createChildResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainerAnnc.getResourceID(), "nana:nono", Operation.CREATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setTo(createdFlexContainerAnnc.getResourceID());
        deleteRequest.setFrom("toto:tata");
        deleteRequest.setOperation(Operation.DELETE);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (deleteResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("deleteFlexContainerAnnc response is null");
            return;
        }
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete FlexContainerAnnc, expecting " + ResponseStatusCode.DELETED + ", found " + deleteResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdFlexContainerAnnc.getResourceID(), "toto:tata", Operation.DELETE)) {
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.setState(Test.State.OK);
    }
}

