/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.RequestEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.CSEBase;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.Request;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.AeMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.DynamicAuthorizationConsultationMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.FlexContainerMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.NodeMapper;
import org.eclipse.om2m.core.entitymapper.RemoteCSEMapper;
import org.eclipse.om2m.core.entitymapper.RequestMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class CseBaseMapper
extends EntityMapper<CSEBaseEntity, CSEBase> {
    @Override
    protected CSEBase createResource() {
        return new CSEBase();
    }

    @Override
    protected void mapAttributes(CSEBaseEntity cseBaseEntity, CSEBase cseBaseResource, int level, int offset) {
        if (level < 0) {
            return;
        }
        cseBaseResource.setNodeLink(cseBaseEntity.getNodeLink());
        cseBaseResource.setCSEID(cseBaseEntity.getCseid());
        cseBaseResource.setCseType(cseBaseEntity.getCseType());
        for (BigInteger ty : cseBaseEntity.getSupportedResourceType()) {
            cseBaseResource.getSupportedResourceType().add(ty);
        }
        for (AccessControlPolicyEntity acp : cseBaseEntity.getAccessControlPolicies()) {
            cseBaseResource.getAccessControlPolicyIDs().add(acp.getResourceID());
        }
        List dacis = cseBaseResource.getDynamicAuthorizationConsultationIDs();
        for (DynamicAuthorizationConsultationEntity dace : cseBaseEntity.getDynamicAuthorizationConsultations()) {
            dacis.add(dace.getResourceID());
        }
        if (!cseBaseEntity.getLabelsEntities().isEmpty()) {
            for (LabelEntity l : cseBaseEntity.getLabelsEntities()) {
                cseBaseResource.getLabels().add(l.getLabel());
            }
        }
        if (!cseBaseEntity.getPointOfAccess().isEmpty()) {
            cseBaseResource.getPointOfAccess().addAll(cseBaseEntity.getPointOfAccess());
        }
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(CSEBaseEntity cseBaseEntity, int level, int offset) {
        ChildResourceRef ch;
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (AccessControlPolicyEntity acp : cseBaseEntity.getChildAccessControlPolicies()) {
            child = new ChildResourceRef();
            child.setResourceName(acp.getName());
            child.setType(1);
            child.setValue(acp.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AcpMapper().getChildResourceRef(acp, level - 1, offset - 1));
        }
        for (AeEntity ae : cseBaseEntity.getAes()) {
            child = new ChildResourceRef();
            child.setResourceName(ae.getName());
            child.setType(2);
            child.setValue(ae.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AeMapper().getChildResourceRef(ae, level - 1, offset - 1));
        }
        for (ContainerEntity cnt : cseBaseEntity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(cnt.getName());
            child.setType(3);
            child.setValue(cnt.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContainerMapper().getChildResourceRef(cnt, level - 1, offset - 1));
        }
        for (FlexContainerEntity fcnt : cseBaseEntity.getChildFlexContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(fcnt.getName());
            child.setType(28);
            child.setValue(fcnt.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerMapper().getChildResourceRef(fcnt, level - 1, offset - 1));
        }
        for (RemoteCSEEntity csr : cseBaseEntity.getRemoteCses()) {
            child = new ChildResourceRef();
            child.setResourceName(csr.getName());
            child.setType(16);
            child.setValue(csr.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new RemoteCSEMapper().getChildResourceRef(csr, level - 1, offset - 1));
        }
        for (GroupEntity group : cseBaseEntity.getGroups()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(9);
            child.setValue(group.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new GroupMapper().getChildResourceRef(group, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : cseBaseEntity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (RequestEntity req : cseBaseEntity.getChildReq()) {
            child = new ChildResourceRef();
            child.setResourceName(req.getName());
            child.setType(17);
            child.setValue(req.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new RequestMapper().getChildResourceRef(req, level - 1, offset - 1));
        }
        for (NodeEntity nod : cseBaseEntity.getChildNodes()) {
            ch = new ChildResourceRef();
            ch.setResourceName(nod.getName());
            ch.setType(14);
            ch.setValue(nod.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new NodeMapper().getChildResourceRef(nod, level - 1, offset - 1));
        }
        for (DynamicAuthorizationConsultationEntity dace : cseBaseEntity.getChildDynamicAuthorizationConsultation()) {
            ch = new ChildResourceRef();
            ch.setResourceName(dace.getName());
            ch.setType(34);
            ch.setValue(dace.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new DynamicAuthorizationConsultationMapper().getChildResourceRef(dace, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(CSEBaseEntity cseBaseEntity, CSEBase cseBaseResource, int level, int offset) {
        cseBaseResource.getChildResource().addAll(this.getChildResourceRef(cseBaseEntity, level, offset));
    }

    @Override
    protected void mapChildResources(CSEBaseEntity entity, CSEBase resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (AccessControlPolicyEntity acp : entity.getChildAccessControlPolicies()) {
            AccessControlPolicy acpRes = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acp, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(acpRes);
        }
        for (AeEntity ae : entity.getAes()) {
            AE aeRes = (AE)new AeMapper().mapEntityToResource(ae, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(aeRes);
        }
        for (ContainerEntity cnt : entity.getChildContainers()) {
            Container cntRes = (Container)new ContainerMapper().mapEntityToResource(cnt, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(cntRes);
        }
        for (FlexContainerEntity fcnt : entity.getChildFlexContainers()) {
            AbstractFlexContainer fcntRes = (AbstractFlexContainer)new FlexContainerMapper().mapEntityToResource(fcnt, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(fcntRes);
        }
        for (RemoteCSEEntity csr : entity.getRemoteCses()) {
            RemoteCSE csrRes = (RemoteCSE)new RemoteCSEMapper().mapEntityToResource(csr, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(csrRes);
        }
        for (GroupEntity group : entity.getGroups()) {
            Group grp = (Group)new GroupMapper().mapEntityToResource(group, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(grp);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(subRes);
        }
        for (NodeEntity node : entity.getChildNodes()) {
            Node nodeRes = (Node)new NodeMapper().mapEntityToResource(node, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(nodeRes);
        }
        for (RequestEntity req : entity.getChildReq()) {
            Request reqResource = (Request)new RequestMapper().mapEntityToResource(req, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(reqResource);
        }
        for (DynamicAuthorizationConsultationEntity daceEntity : entity.getChildDynamicAuthorizationConsultation()) {
            DynamicAuthorizationConsultation dace = (DynamicAuthorizationConsultation)new DynamicAuthorizationConsultationMapper().mapEntityToResource(daceEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getRemoteCSEOrNodeOrAE().add(dace);
        }
    }
}

