/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class IURIEditorInputAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{IPathEditorInput.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (IPathEditorInput.class.equals((Object)adapterType) && adaptableObject instanceof IURIEditorInput) {
            try {
                IFileStore fileStore = EFS.getStore((URI)((IURIEditorInput)adaptableObject).getURI());
                if (fileStore.getFileSystem() == EFS.getLocalFileSystem()) {
                    return new PathEditorInputAdapter(fileStore);
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static class PathEditorInputAdapter
    extends FileStoreEditorInput
    implements IPathEditorInput {
        public PathEditorInputAdapter(IFileStore fileStore) {
            super(fileStore);
        }

        public IPath getPath() {
            return URIUtil.toPath((URI)this.getURI());
        }
    }
}

