/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.ui.AgentManagerDialog;
import org.eclipse.oomph.p2.internal.ui.P2ContentProvider;
import org.eclipse.oomph.p2.internal.ui.P2LabelProvider;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.provider.CatalogSelectionItemProvider;
import org.eclipse.oomph.setup.provider.IndexItemProvider;
import org.eclipse.oomph.setup.provider.InstallationItemProvider;
import org.eclipse.oomph.setup.provider.ProductCatalogItemProvider;
import org.eclipse.oomph.setup.provider.ProductItemProvider;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.PersistentButton;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ProductPage
extends SetupWizardPage {
    private static final boolean SHOW_BUNDLE_POOL_UI = PropertiesUtil.getProperty((String)"oomph.p2.pool") == null;
    private static final Product NO_PRODUCT = ProductPage.createNoProduct();
    private ComposedAdapterFactory adapterFactory;
    private CatalogSelector catalogSelector;
    private TreeViewer productViewer;
    private Label idLabel;
    private Text idText;
    private Label nameLabel;
    private Text nameText;
    private Label versionLabel;
    private ComboViewer versionComboViewer;
    private Button poolButton;
    private ComboViewer poolComboViewer;
    private Button managePoolsButton;
    private BundlePool currentBundlePool;
    private boolean currentBundlePoolChanging;

    public ProductPage() {
        super("ProductPage");
        this.setTitle("Product");
        this.setDescription("Select the product and choose the version you want to install.");
    }

    protected Control createUI(Composite parent) {
        this.adapterFactory = new ComposedAdapterFactory((AdapterFactory)this.getAdapterFactory());
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ItemProviderAdapterFactory());
        BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        ResourceSet resourceSet = this.getResourceSet();
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, null, resourceSet)));
        final CatalogManager catalogManager = this.getCatalogManager();
        this.catalogSelector = new CatalogSelector(catalogManager, true);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginBottom = 5;
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)mainLayout);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        Composite filterComposite = new Composite(mainComposite, 0);
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout filterPlaceholderLayout = new GridLayout();
        filterPlaceholderLayout.marginWidth = 0;
        filterPlaceholderLayout.marginHeight = 0;
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)filterPlaceholderLayout);
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText("Collapse All");
        collapseAllButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("collapse-all"));
        AccessUtil.setKey((Widget)collapseAllButton, (Object)"collapse");
        ToolItem refreshButton = new ToolItem(filterToolBar, 0);
        refreshButton.setToolTipText("Refresh");
        refreshButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("refresh"));
        AccessUtil.setKey((Widget)refreshButton, (Object)"refresh");
        ToolItem catalogsButton = new ToolItem(filterToolBar, 4);
        catalogsButton.setToolTipText("Select Catalogs");
        catalogsButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("catalogs"));
        this.catalogSelector.configure(catalogsButton);
        AccessUtil.setKey((Widget)catalogsButton, (Object)"catalogs");
        FilteredTree filteredTree = new FilteredTree(mainComposite, 2048, new PatternFilter(), true);
        Control filterControl = filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        AccessUtil.setKey((Widget)filteredTree.getFilterControl(), (Object)"filter");
        this.addHelpCallout((Control)filteredTree.getViewer().getTree(), 1);
        this.productViewer = filteredTree.getViewer();
        this.productViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.productViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                ProductPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Object[] elements;
                        if (ProductPage.this.productViewer.getExpandedElements().length == 0 && (elements = this.getElements(ProductPage.this.productViewer.getInput())).length > 0) {
                            EMap defaultProductVersions;
                            ProductPage.this.productViewer.expandToLevel(elements[0], 1);
                            if (ProductPage.this.productViewer.getSelection().isEmpty() && !(defaultProductVersions = catalogManager.getSelection().getDefaultProductVersions()).isEmpty()) {
                                Product defaultProduct = (Product)((Map.Entry)defaultProductVersions.get(0)).getKey();
                                viewer.setSelection((ISelection)new StructuredSelection((Object)defaultProduct), true);
                            }
                        }
                    }
                });
            }
        });
        Tree productTree = this.productViewer.getTree();
        productTree.setLayoutData((Object)new GridData(1808));
        CatalogSelection selection = catalogManager.getSelection();
        this.productViewer.setInput((Object)selection);
        GridLayout installationPaneLayout = new GridLayout(2, false);
        installationPaneLayout.marginTop = 5;
        installationPaneLayout.marginWidth = 0;
        installationPaneLayout.marginHeight = 0;
        Composite installationPane = new Composite(mainComposite, 0);
        installationPane.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        installationPane.setLayout((Layout)installationPaneLayout);
        this.idLabel = new Label(installationPane, 0);
        this.idLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.idLabel.setText("Product ID:");
        AccessUtil.setKey((Widget)this.idLabel, (Object)"productID");
        this.idText = new Text(installationPane, 8);
        this.idText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameLabel = new Label(installationPane, 0);
        this.nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameLabel.setText("Product Name:");
        AccessUtil.setKey((Widget)this.nameLabel, (Object)"productName");
        this.nameText = new Text(installationPane, 8);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.versionLabel = new Label(installationPane, 0);
        this.versionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.versionLabel.setText("Product Version:");
        AccessUtil.setKey((Widget)this.versionLabel, (Object)"productVersion");
        this.versionComboViewer = new ComboViewer(installationPane, 8);
        this.versionComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.versionComboViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object != NO_PRODUCT) {
                    return ((Product)object).getVersions().toArray();
                }
                return super.getElements(object);
            }
        });
        Combo versionCombo = this.versionComboViewer.getCombo();
        versionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        AccessUtil.setKey((Widget)versionCombo, (Object)"versionChoice");
        if (SHOW_BUNDLE_POOL_UI) {
            this.initBundlePool();
            this.poolButton = new PersistentButton(installationPane, 32, true, (PersistentButton.Persistence)new PersistentButton.DialogSettingsPersistence(this.getDialogSettings(), "useBundlePool"));
            AccessUtil.setKey((Widget)this.poolButton, (Object)"pools");
            this.poolButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.poolButton.setText("Bundle Pool:");
            this.poolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ProductPage.this.poolButton.getSelection()) {
                        IStructuredSelection selection = (IStructuredSelection)ProductPage.this.poolComboViewer.getSelection();
                        BundlePool pool = (BundlePool)selection.getFirstElement();
                        if (pool != null) {
                            ProductPage.this.setCurrentBundlePool(pool);
                        } else {
                            ProductPage.this.initBundlePool();
                        }
                    } else {
                        ProductPage.this.setCurrentBundlePool(null);
                    }
                    ProductPage.this.updateInstallationPane(false);
                }
            });
            GridLayout poolLayout = new GridLayout(2, false);
            poolLayout.marginWidth = 0;
            poolLayout.marginHeight = 0;
            Composite poolComposite = new Composite(installationPane, 0);
            poolComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            poolComposite.setLayout((Layout)poolLayout);
            P2LabelProvider labelProvider = new P2LabelProvider();
            labelProvider.setAbsolutePools(true);
            this.poolComboViewer = new ComboViewer(poolComposite, 8);
            this.poolComboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.poolComboViewer.setContentProvider((IContentProvider)new P2ContentProvider.AllBundlePools());
            this.poolComboViewer.setInput((Object)P2Util.getAgentManager());
            this.poolComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection;
                    BundlePool pool;
                    if (ProductPage.this.currentBundlePoolChanging) {
                        return;
                    }
                    if (ProductPage.this.poolButton.getSelection() && (pool = (BundlePool)(selection = (IStructuredSelection)ProductPage.this.poolComboViewer.getSelection()).getFirstElement()) != ProductPage.this.currentBundlePool) {
                        ProductPage.this.setCurrentBundlePool(pool);
                        ProductPage.this.updateInstallationPane(false);
                    }
                }
            });
            Combo poolCombo = this.poolComboViewer.getCombo();
            poolCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            AccessUtil.setKey((Widget)poolCombo, (Object)"poolChoice");
            this.managePoolsButton = new Button(poolComposite, 8);
            this.managePoolsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.managePoolsButton.setText("Manage Bundle Pools...");
            this.managePoolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProductPage.this.manageBundlePools();
                }
            });
            AccessUtil.setKey((Widget)this.managePoolsButton, (Object)"managePools");
        }
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductPage.this.productViewer.collapseAll();
            }
        });
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductPage.this.getWizard().reloadIndex();
            }
        });
        this.productViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProductPage.this.productViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Product) {
                    if (ProductPage.this.isPageComplete()) {
                        ProductPage.this.advanceToNextPage();
                    }
                    return;
                }
                boolean expanded = ProductPage.this.productViewer.getExpandedState(element);
                ProductPage.this.productViewer.setExpandedState(element, !expanded);
            }
        });
        this.productViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProductPage.this.updateInstallationPane(false);
            }
        });
        this.versionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProductVersion version = ProductPage.this.getSelectedProductVersion();
                if (version != null) {
                    ProductPage.this.saveProductVersionSelection(version);
                }
            }
        });
        this.updateInstallationPane(true);
        return mainComposite;
    }

    public void leavePage(boolean forward) {
        if (forward) {
            ProductVersion productVersion = this.getSelectedProductVersion();
            this.getWizard().setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet(), (ProductVersion)productVersion));
        }
    }

    private void updateInstallationPane(boolean initial) {
        Product product = this.getSelectedProduct();
        if (product == null) {
            product = NO_PRODUCT;
        }
        this.idText.setText(ProductPage.safe(product.getName()));
        this.nameText.setText(ProductPage.safe(product.getLabel()));
        this.versionComboViewer.setInput((Object)product);
        ProductVersion version = (ProductVersion)this.catalogSelector.getCatalogManager().getSelection().getDefaultProductVersions().get((Object)product);
        if (version == null) {
            ProductVersion firstReleasedProductVersion = null;
            ProductVersion latestProductVersion = null;
            ProductVersion latestReleasedProductVersion = null;
            for (ProductVersion productVersion : product.getVersions()) {
                String versionName = productVersion.getName();
                if ("latest.released".equals(versionName)) {
                    latestReleasedProductVersion = productVersion;
                    continue;
                }
                if ("latest".equals(versionName)) {
                    latestProductVersion = productVersion;
                    continue;
                }
                if (firstReleasedProductVersion != null) continue;
                firstReleasedProductVersion = productVersion;
            }
            version = latestReleasedProductVersion != null ? latestReleasedProductVersion : (firstReleasedProductVersion != null ? firstReleasedProductVersion : latestProductVersion);
            if (version != null) {
                this.saveProductVersionSelection(version);
            }
        }
        if (version != null) {
            this.versionComboViewer.setSelection((ISelection)new StructuredSelection((Object)version));
        }
        boolean productSelected = product != NO_PRODUCT;
        String error = productSelected ? null : "Select a product from the catalogs and choose the product version.";
        this.idLabel.setEnabled(productSelected);
        this.idText.setEnabled(productSelected);
        this.nameLabel.setEnabled(productSelected);
        this.nameText.setEnabled(productSelected);
        this.versionLabel.setEnabled(productSelected);
        this.versionComboViewer.getControl().setEnabled(productSelected);
        if (this.poolButton != null) {
            this.poolButton.setEnabled(productSelected);
            boolean poolNeeded = productSelected && this.poolButton.getSelection();
            this.poolComboViewer.getControl().setEnabled(poolNeeded);
            this.managePoolsButton.setEnabled(poolNeeded);
            this.currentBundlePoolChanging = true;
            if (poolNeeded) {
                if (this.currentBundlePool != null) {
                    this.poolComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentBundlePool));
                } else {
                    if (error == null) {
                        error = "Select a bundle pool or disable the use of a bundle pool.";
                    }
                    this.poolComboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            } else {
                this.poolComboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.currentBundlePoolChanging = false;
        }
        if (!initial) {
            this.setErrorMessage(error);
            this.setPageComplete(error == null);
        }
    }

    private void setCurrentBundlePool(BundlePool pool) {
        if (pool != null) {
            P2Util.getAgentManager().setDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName(), pool);
            System.setProperty("oomph.p2.pool", pool.getLocation().getAbsolutePath());
        } else {
            System.clearProperty("oomph.p2.pool");
        }
        this.currentBundlePool = pool;
    }

    private void initBundlePool() {
        BundlePool pool = P2Util.getAgentManager().getDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName());
        this.setCurrentBundlePool(pool);
    }

    private void manageBundlePools() {
        AgentManagerDialog dialog = new AgentManagerDialog(this.getShell()){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            }

            protected void elementChanged(Object element) {
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(element instanceof BundlePool);
                }
            }
        };
        IStructuredSelection selection = (IStructuredSelection)this.poolComboViewer.getSelection();
        BundlePool pool = (BundlePool)selection.getFirstElement();
        if (pool != null) {
            dialog.setSelectedElement((Object)pool);
        }
        int result = dialog.open();
        this.poolComboViewer.refresh();
        if (result == 0) {
            pool = (BundlePool)dialog.getSelectedElement();
            this.poolComboViewer.setSelection((ISelection)(pool == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)pool)));
        }
    }

    private Product getSelectedProduct() {
        IStructuredSelection selection = (IStructuredSelection)this.productViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof Product) {
            return (Product)element;
        }
        return null;
    }

    private ProductVersion getSelectedProductVersion() {
        IStructuredSelection selection = (IStructuredSelection)this.versionComboViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ProductVersion) {
            return (ProductVersion)element;
        }
        return null;
    }

    private void saveProductVersionSelection(ProductVersion version) {
        CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        EMap defaultProductVersions = catalogManager.getSelection().getDefaultProductVersions();
        Product product = version.getProduct();
        defaultProductVersions.put((Object)product, (Object)version);
        defaultProductVersions.move(0, defaultProductVersions.indexOfKey((Object)product));
        catalogManager.saveSelection();
    }

    public void dispose() {
        super.dispose();
        this.adapterFactory.dispose();
    }

    private static Product createNoProduct() {
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName("<no product selected>");
        product.setLabel(product.getName());
        return product;
    }

    private static String safe(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static final class ItemProviderAdapterFactory
    extends SetupItemProviderAdapterFactory
    implements SetupPackage.Literals {
        private ItemProviderAdapterFactory() {
        }

        public Adapter createCatalogSelectionAdapter() {
            if (this.catalogSelectionItemProvider == null) {
                this.catalogSelectionItemProvider = new CatalogSelectionItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(CATALOG_SELECTION__PRODUCT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.catalogSelectionItemProvider;
        }

        public Adapter createIndexAdapter() {
            if (this.indexItemProvider == null) {
                this.indexItemProvider = new IndexItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INDEX__PRODUCT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.indexItemProvider;
        }

        public Adapter createProductCatalogAdapter() {
            if (this.productCatalogItemProvider == null) {
                this.productCatalogItemProvider = new ProductCatalogItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(PRODUCT_CATALOG__PRODUCTS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.productCatalogItemProvider;
        }

        public Adapter createProductAdapter() {
            if (this.productItemProvider == null) {
                this.productItemProvider = new ProductItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.productItemProvider;
        }

        public Adapter createInstallationAdapter() {
            if (this.installationItemProvider == null) {
                this.installationItemProvider = new InstallationItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INSTALLATION__PRODUCT_VERSION);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.installationItemProvider;
        }
    }
}

