/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.ui.StorageConfigurationComposite;

public class SynchronizerPreferencePage
extends AbstractPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SynchronizerPreferencePage";
    private final PageHandler pageHandler = SynchronizerManager.Availability.AVAILABLE ? new StorageHandler() : new DisabledHandler();

    protected Control doCreateContents(Composite parent) {
        return this.pageHandler.createContents(parent);
    }

    protected void performDefaults() {
        this.pageHandler.performDefaults();
        super.performDefaults();
    }

    protected void performApply() {
        this.pageHandler.performApply();
        super.performApply();
    }

    public boolean performOk() {
        this.pageHandler.performOk();
        return super.performOk();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.pageHandler.updateButtons();
    }

    private class DisabledHandler
    extends PageHandler {
        private DisabledHandler() {
        }

        public Control createContents(Composite parent) {
            Text text = new Text(parent, 8);
            text.setText("User storage support has not been installed.");
            return text;
        }

        public void updateButtons() {
            SynchronizerPreferencePage.this.getApplyButton().setEnabled(false);
            SynchronizerPreferencePage.this.getDefaultsButton().setEnabled(false);
        }
    }

    private abstract class PageHandler {
        private PageHandler() {
        }

        public abstract Control createContents(Composite var1);

        public void updateButtons() {
        }

        public void performOk() {
        }

        public void performApply() {
        }

        public void performDefaults() {
        }
    }

    private class StorageHandler
    extends PageHandler {
        private Button enableButton;
        private StorageConfigurationComposite storageConfigurationComposite;
        private Button syncButton;
        private Button deleteButton;
        private boolean initialEnabled = SynchronizerManager.INSTANCE.isSyncEnabled();

        public Control createContents(Composite parent) {
            IStorage storage = SynchronizerManager.INSTANCE.getStorage();
            IStorageService service = storage.getService();
            boolean showServices = StorageConfigurationComposite.isShowServices();
            GridLayout layout = new GridLayout(showServices ? 2 : 1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)layout);
            if (service == null && !showServices) {
                Label label = new Label(main, 0);
                label.setText("No service available.");
            } else {
                this.enableButton = new Button(main, 32);
                this.enableButton.setText("Synchronize with" + (showServices ? ":" : " " + service.getServiceLabel()));
                this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StorageHandler.this.updateEnablement();
                    }
                });
                if (showServices) {
                    this.storageConfigurationComposite = new StorageConfigurationComposite(main, 0, storage){

                        protected StructuredViewer createViewer(Composite parent) {
                            TableComboViewer viewer = new TableComboViewer(parent, 2056);
                            TableCombo tableCombo = viewer.getTableCombo();
                            tableCombo.defineColumns(2);
                            tableCombo.setToolTipText("Select the service to synchronize with");
                            return viewer;
                        }
                    };
                }
                this.syncButton = new Button(main, 8);
                this.syncButton.setText("Synchronize Now...");
                this.syncButton.setLayoutData((Object)new GridData(16384, 4, false, false, layout.numColumns, 1));
                this.syncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StorageHandler.this.performApply();
                        final Shell shell = SynchronizerPreferencePage.this.getShell();
                        UIUtil.asyncExec((Control)shell, (Runnable)new Runnable(){

                            public void run() {
                                try {
                                    Object data = shell.getData();
                                    if (data instanceof PreferenceDialog) {
                                        PreferenceDialog preferenceDialog = (PreferenceDialog)data;
                                        ReflectUtil.invokeMethod((String)"okPressed", (Object)preferenceDialog);
                                    }
                                }
                                catch (Throwable ex) {
                                    SetupUIPlugin.INSTANCE.log(ex);
                                }
                            }
                        });
                        UIUtil.asyncExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                try {
                                    Shell shell = SetupPropertyTester.getHandlingShell();
                                    if (shell != null) {
                                        shell.setVisible(true);
                                    } else {
                                        SynchronizerManager.Impact impact = SynchronizerManager.INSTANCE.performFullSynchronization();
                                        if (impact != null && impact.hasLocalImpact()) {
                                            SetupWizard.Updater.perform(false);
                                        }
                                    }
                                }
                                catch (Throwable ex) {
                                    SetupUIPlugin.INSTANCE.log(ex);
                                }
                            }
                        });
                    }
                });
                PreferenceLinkArea credentialsLink = new PreferenceLinkArea(main, 0, "org.eclipse.userstorage.ui.PreferencePage", "See <a>''User Storage Service''</a> for credentials.", (IWorkbenchPreferenceContainer)SynchronizerPreferencePage.this.getContainer(), null);
                credentialsLink.getControl().setLayoutData((Object)new GridData(16384, 4, false, false, layout.numColumns, 1));
                this.enableButton.setSelection(this.initialEnabled);
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        StorageHandler.this.updateEnablement();
                    }
                });
            }
            return main;
        }

        public void performDefaults() {
            if (this.enableButton != null) {
                this.enableButton.setSelection(this.initialEnabled);
                this.updateEnablement();
            }
            if (this.storageConfigurationComposite != null) {
                this.storageConfigurationComposite.performDefaults();
            }
        }

        public void performApply() {
            if (this.enableButton != null) {
                this.updateEnablement();
            }
        }

        public void performOk() {
            if (this.enableButton != null) {
                if (this.storageConfigurationComposite != null) {
                    this.storageConfigurationComposite.performApply();
                }
                this.initialEnabled = this.enableButton.getSelection();
                SynchronizerManager.INSTANCE.setSyncEnabled(this.initialEnabled);
            }
        }

        private boolean needsApply() {
            block4: {
                if (this.enableButton == null || this.enableButton.getSelection() == this.initialEnabled) break block4;
                return true;
            }
            try {
                if (this.storageConfigurationComposite != null) {
                    return this.storageConfigurationComposite.isDirty();
                }
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            return false;
        }

        private void updateEnablement() {
            Button applyButton;
            boolean enabled;
            boolean bl = enabled = this.enableButton != null ? this.enableButton.getSelection() : false;
            if (this.storageConfigurationComposite != null) {
                this.storageConfigurationComposite.setEnabled(enabled);
            }
            if (this.syncButton != null) {
                this.syncButton.setEnabled(enabled);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(enabled);
            }
            boolean needsApply = this.needsApply();
            Button defaultsButton = SynchronizerPreferencePage.this.getDefaultsButton();
            if (defaultsButton != null) {
                defaultsButton.setEnabled(needsApply);
            }
            if ((applyButton = SynchronizerPreferencePage.this.getApplyButton()) != null) {
                applyButton.setEnabled(needsApply);
            }
        }
    }
}

