/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.lang.reflect.Method;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.oomph.base.provider.BaseEditPlugin;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.ToggleCommandHandler;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.osgi.framework.BundleContext;

public final class UIPlugin
extends OomphUIPlugin {
    public static final UIPlugin INSTANCE = new UIPlugin();
    private static final Method OPEN_RECORDER_METHOD;
    private static Implementation plugin;

    static {
        Method openRecorderMethod = null;
        if (PropertiesUtil.isProperty((String)"org.eclipse.swtbot.generator.enable")) {
            try {
                Class<?> startupRecorderClass = ((Object)((Object)INSTANCE)).getClass().getClassLoader().loadClass("org.eclipse.swtbot.generator.ui.StartupRecorder");
                openRecorderMethod = ReflectUtil.getMethod(startupRecorderClass, (String)"openRecorder", (Class[])new Class[]{String.class});
            }
            catch (Throwable throwable) {}
        }
        OPEN_RECORDER_METHOD = openRecorderMethod;
    }

    public UIPlugin() {
        super(new ResourceLocator[]{BaseEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static boolean isRecorderEnabled() {
        return OPEN_RECORDER_METHOD != null;
    }

    public static void openRecorderIfEnabled() {
        if (UIPlugin.isRecorderEnabled()) {
            try {
                OPEN_RECORDER_METHOD.invoke(null, new Object[]{null});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class Implementation
    extends EclipseUIPlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            UtilPlugin.setToggleStateAccessor((UtilPlugin.ToggleStateAccessor)new UtilPlugin.ToggleStateAccessor(){

                public boolean isEnabled(String id) {
                    return ToggleCommandHandler.getToggleState(id);
                }

                public void setEnabled(String id, boolean enabled) {
                    ToggleCommandHandler.setToggleState(id, enabled);
                }
            });
        }
    }
}

